/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: abort.c,v 6.8 1999/11/12 05:19:28 jsquyres Exp $
 *
 *	Function:	- attempts to abort all processes in group
 *			- prints error message
 *	Accepts:	- communicator
 *			- error code
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <lam_config.h>
#include <blktype.h>
#include <ksignal.h>
#include <mpi.h>
#include <mpisys.h>
#include <net.h>
#include <preq.h>
#include <rpisys.h>
#if LAM_WANT_IMPI
#include <impi.h>
#endif


int
MPI_Abort(comm, errcode)

MPI_Comm		comm;
int			errcode;

{
	int		size;			/* group size */
	int		rank;			/* process rank */
	int		err;			/* error code */
	int		class;			/* error class */
	int		i;
	struct _proc	**p;

	lam_initerr();
	lam_setfunc(BLKMPIABORT);
/*
 * Switch error code to extracted errno value.  If the class is 0 then
 * the errno is taken to be the code.
 */
	lam_bkerr(errcode, &class, &i, &err);
	if (class) errcode = err;

	if (comm == MPI_COMM_NULL) comm = MPI_COMM_WORLD;

	err = MPI_Comm_size(comm, &size);
	if (err != MPI_SUCCESS) kexit(errcode);

	err = MPI_Comm_rank(comm, &rank);
	if (err != MPI_SUCCESS) kexit(errcode);

#if LAM_WANT_IMPI
	/* Tell the IMPI client daemon to abort.  IMPI_Abort simply
	   sends a message to the IMPI client daemon telling it to
	   quit; it does not perform any cleanup stuff. */

	if (LAM_IS_IMPI(MPI_COMM_WORLD))
	  IMPI_Abort();
#endif

/*
 * Doom all other processes in the group if we know their pids.
 */
	if ((_kio.ki_rtf & RTF_MPIRUN) || (_kio.ki_parent > 0)) {
		p = comm->c_group->g_procs;

		for (i = 0; i < size; ++i, ++p) {

			if (i != rank) {
				rpdoom((*p)->p_gps.gps_node, SELECT_PID,
						(*p)->p_gps.gps_pid, SIGUDIE);
			}
		}
	}
/*
 * Clean up any published names.
 */
	lam_nukepublished();

/*
 * Abort the local process if in the group.
 */
	if (rank >= 0) {
		kexit(errcode);
	}

	lam_resetfunc(BLKMPIABORT);
	return(MPI_SUCCESS);
}
