-- Copyright (C) 1999 Dave E Martin XXIII and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing
	description: "GtkStyle"
	author: "Dave E Martin XXIII"
	genesis: "199903180429 utc"
	version: "v 0.3.3 GTK+ 1.2.x"
	gtk_version: "1.2"
	cvs: "$Id: gtk_style.e,v 1.4 1999/10/03 02:07:19 richieb Exp $"
	HERE: "still needs querys for the other GC attributes"

class GTK_STYLE

inherit

	GTK_STYLE_EXTERNALS

creation

	make

feature {GTK_WIDGET} -- creation

	make (style_: POINTER) is
		do
			style := style_
		end

feature -- query

	fg_gc (index: INTEGER): like general_gc_cache is
--HERE check contract here as well?
		local
			p: POINTER
		do
			p := c_gtk_style_get_fg_gc (style, index)
			if general_gc_cache = Void or else general_gc_cache.gc /= p then
				!! general_gc_cache.make_from_pointer (p)
			end
			Result := general_gc_cache
		ensure
			Result /= Void
		end

	bg_gc (index: INTEGER): like general_gc_cache is
		local
			p: POINTER
		do
			p := c_gtk_style_get_bg_gc (style, index)
			if general_gc_cache = Void or else general_gc_cache.gc /= p then
				!! general_gc_cache.make_from_pointer (p)
			end
			Result := general_gc_cache
		ensure
			Result /= Void
		end

	light_gc (index: INTEGER): like general_gc_cache is
		local
			p: POINTER
		do
			p := c_gtk_style_get_light_gc (style, index)
			if general_gc_cache = Void or else general_gc_cache.gc /= p then
				!! general_gc_cache.make_from_pointer (p)
			end
			Result := general_gc_cache
		ensure
			Result /= Void
		end

	dark_gc (index: INTEGER): like general_gc_cache is
		local
			p: POINTER
		do
			p := c_gtk_style_get_dark_gc (style, index)
			if general_gc_cache = Void or else general_gc_cache.gc /= p then
				!! general_gc_cache.make_from_pointer (p)
			end
			Result := general_gc_cache
		ensure
			Result /= Void
		end

	mid_gc (index: INTEGER): like general_gc_cache is
		local
			p: POINTER
		do
			p := c_gtk_style_get_mid_gc (style, index)
			if general_gc_cache = Void or else general_gc_cache.gc /= p then
				!! general_gc_cache.make_from_pointer (p)
			end
			Result := general_gc_cache
		ensure
			Result /= Void
		end

	text_gc (index: INTEGER): like general_gc_cache is
		local
			p: POINTER
		do
			p := c_gtk_style_get_text_gc (style, index)
			if general_gc_cache = Void or else general_gc_cache.gc /= p then
				!! general_gc_cache.make_from_pointer (p)
			end
			Result := general_gc_cache
		ensure
			Result /= Void
		end

	base_gc (index: INTEGER): like general_gc_cache is
		local
			p: POINTER
		do
			p := c_gtk_style_get_base_gc (style, index)
			if general_gc_cache = Void or else general_gc_cache.gc /= p then
				!! general_gc_cache.make_from_pointer (p)
			end
			Result := general_gc_cache
		ensure
			Result /= Void
		end

	black_gc: like black_gc_cache is
		local
			p: POINTER
		do
			p := c_gtk_style_get_black_gc (style)
			if black_gc_cache = Void or else black_gc_cache.gc /= p then
				!! black_gc_cache.make_from_pointer (p)
			end
			Result := black_gc_cache
		ensure
			Result /= Void
		end

	white_gc: like white_gc_cache is
		local
			p: POINTER
		do
			p := c_gtk_style_get_white_gc (style)
			if white_gc_cache = Void or else white_gc_cache.gc /= p then
				!! white_gc_cache.make_from_pointer (p)
			end
			Result := white_gc_cache
		ensure
			Result /= Void
		end

feature

	style: POINTER

	black_gc_cache: GDK_GC

	white_gc_cache: GDK_GC

	general_gc_cache: GDK_GC

end -- GTK_STYLE
