-- Copyright 1998 Richie Bielak and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "GTK_PIXMAP - pixmap widget"
	version: "v 0.3.3 GTK+ 1.2.x"
	author: "Richie Bielak"
	cvs: "$Id: gtk_pixmap.e,v 1.10 1999/11/13 03:42:04 richieb Exp $"

class GTK_PIXMAP

-- An image defined by an array of characters at one byte per pixeL

inherit
	
	GTK_MISC

	EGTK_NON_PORTABLE
		undefine
			copy, is_equal
		end

creation

	make_from_xpm,
	make_from_pointer

feature {NONE}

	xpm_path: STRING

	make_from_xpm (new_parent: GTK_WIDGET; file_name: STRING) is
		require
			parent_not_void: new_parent /= Void
			file_name_valid: file_name /= Void and then not file_name.empty
		do
			if file_name @ 1 = '/' then
				xpm_path := clone(file_name)
			else
				find_xpm(file_name)
			end
--			io.put_string("xpm_path set to: '")
--			io.put_string(xpm_path)
--			io.put_string("'%N")
			widget := npc.np_gtk_pixmap_create_from_xpm (new_parent.widget, 
														 xpm_path)
			register_widget
		end

	find_xpm(x: STRING) is
			-- locate the xpm file and set xpm_path to its path
			-- TODO - look for xpm file in standard locations
			--   current directory
			--   /usr/X11R6/include/X11/pixmaps
			--   /usr/X11R6/include/X11/bitmaps
			--   /usr/X11R6/include/bitmaps
			-- or use X resources database

			-- ** Actually this path should from from the gtkrc file
		do
			-- default to current directory for now
			xpm_path := clone("./")
			xpm_path.append(x)
		end
end
