indexing
	description: "List of C function prototypes"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:41 $"
	revision: "$Revision: 1.1.1.1 $"

class
	C_PROTOTYPES

inherit
	LINKED_LIST [C_PROTOTYPE]

creation
	make

feature -- Setup

	resolve_typedefs (tds: C_TYPEDEFS) is
		do
			from start until after loop
				item.set_typedef (tds.get_typedef (item.type))
				from item.arguments.start
				until item.arguments.after
				loop
					item.arguments.item.set_typedef (tds.get_typedef (item.arguments.item.type))
					item.arguments.forth
				end
				forth
			end
		end

feature -- Conversion to Eiffel text

	eiffel_text (include_directive: STRING): STRING is
			-- Eiffel text of external feature wrappers
		do
			Result := "feature -- External C functions%N%N"
			from start until after loop
				Result.append (item.eiffel_text (include_directive))
				forth
			end
		end

end -- class C_PROTOTYPES


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
