(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  Core.v                                  *)
(****************************************************************************)

(* This defines the let macro *)
Abstraction let [0 1] := <<M>><<B>>(((B))@[M]).

(* A cut lemma to be used in order to avoid proof expansion during cuts *)
Definition LET : (A:Type)(B:Prop)(A->B)->A->B.
Exact [A,B,H]H.
Defined.

Definition LAPP : (A,C:Type)(B:Prop)(A->C)->(C->B)->A->B.
Exact [A,C,B,H1,H2,a](H2 (H1 a)).
Defined.

(* $Id: Core.v,v 1.7 1999/11/30 17:43:59 mohring Exp $ *)

