(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 Minus.v                                  *)
(****************************************************************************)

(*********************************************************)
(*    Subtraction                                        *)
(*********************************************************)

(* All theorems of Minus.v are solvable by Omega                            *)

Require Omega.

(* difference between two natural numbers *)
Fixpoint minus [n:nat] : nat -> nat := 
  [m:nat]<nat> Case n of
               (* O *) O
             (* S k *) [k:nat]<nat> Case m of
                                  (* O *)    (S k)
                                (* S l *)    [l:nat](minus k l) end end.

Lemma minus_plus_simpl : (n,m,p:nat)((minus n m)=(minus (plus p n) (plus p m))).
Proof.
Intros; Omega.
Qed.
Hints Resolve minus_plus_simpl : arith.

Lemma minus_n_O : (n:nat)(n=(minus n O)).
Proof.
Intros; Omega.
Qed.
Hints Resolve minus_n_O : arith.

Lemma minus_n_n : (n:nat)(O=(minus n n)).
Proof.
Intros; Omega.
Qed.
Hints Resolve minus_n_n : arith.

Lemma plus_minus : (n,m,p:nat)(n=(plus m p))->(p=(minus n m)).
Proof.
Intros; Omega.
Qed.
Hints Immediate plus_minus : arith.

Lemma minus_plus : (n,m:nat)(minus (plus n m) n)=m.
Proof.
Intros; Omega.
Qed.
Hints Resolve minus_plus : arith.

Require Le.

Lemma le_plus_minus : (n,m:nat)(le n m)->(m=(plus n (minus m n))).
Proof.
Intros; Omega.
Qed.
Hints Resolve le_plus_minus : arith.

Lemma le_plus_minus_r : (n,m:nat)(le n m)->(plus n (minus m n))=m.
Proof.
Intros; Omega.
Qed.
Hints Resolve le_plus_minus_r : arith.


Lemma minus_Sn_m : (n,m:nat)(le m n)->((S (minus n m))=(minus (S n) m)).
Proof.
Intros; Omega.
Qed.
Hints Resolve minus_Sn_m : arith.

Require Lt.

Lemma lt_minus : (n,m:nat)(le m n)->(lt O m)->(lt (minus n m) n).
Proof.
Intros; Omega.
Qed.
Hints Resolve lt_minus : arith.

Lemma lt_O_minus_lt : (n,m:nat)(lt O (minus n m))->(lt m n).
Proof.
Intros; Omega.
Qed.
Hints Immediate lt_O_minus_lt : arith.


(* $Id: Minus_omega.v,v 1.3 1999/06/29 13:09:06 loiseleu Exp $ *)
