(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                   Le.v                                   *)
(****************************************************************************)

(***************************************)
(* Order on natural numbers            *)
(***************************************)


(* Omega solves all theorems of Le.v except the ones mentionning the        *) 
(* predecessor on natural numbers and le_elim_rel which mentions an         *)
(* arbitrary undecidable predicate                                          *)

Require Omega.

Section less_or_equal.
Variable n,m,p:nat.

Theorem le_n_S : (le n m)->(le (S n) (S m)).
Proof.
Omega.
Qed.

Theorem le_trans : (le n m)->(le m p)->(le n p).
Proof.
Omega.
Qed.

Theorem le_n_Sn : (le n (S n)).
Proof.
Omega.
Qed.

Theorem le_O_n : (le O n).
Proof.
Omega.
Qed.

End less_or_equal.
Hints Resolve le_n_S le_n_Sn le_O_n : arith.

Theorem le_pred_n : (n:nat)(le (pred n) n).
Proof.
(*
Intros;Omega.
... Omega do not recognize predecessor on natural numbers ... and fails
*)
Induction n ; Auto with arith v62.
Qed.
Hints Resolve le_pred_n : arith.

Theorem le_trans_S : (n,m:nat)(le (S n) m)->(le n m).
Proof.
Intros; Omega.
(* Omega applies to unquantified formulas: Intros first is necessary *)
Qed.
Hints Immediate le_trans_S : arith.

Theorem le_S_n : (n,m:nat)(le (S n) (S m))->(le n m).
Proof.
Intros; Omega.
Qed.
Hints Immediate le_S_n : arith.

(* Negative properties *)

Theorem le_Sn_O : (n:nat)~(le (S n) O).
Proof.
Intros; Omega.
Qed.
Hints Resolve le_Sn_O : arith.

Theorem le_Sn_n : (n:nat)~(le (S n) n).
Proof.
Intros; Omega.
Qed.
Hints Resolve le_Sn_n : arith.

Theorem le_antisym : (n,m:nat)(le n m)->(le m n)->(n=m).
Proof.
Intros; Omega.
Qed.
Hints Immediate le_antisym : arith.

Theorem le_n_O_eq : (n:nat)(le n O)->(O=n).
Proof.
Intros; Omega.
Qed.
Hints Immediate le_n_O_eq : arith.


(* A different elimination principle for the order on natural numbers *)

Lemma le_elim_rel : (P:nat->nat->Prop)
     ((p:nat)(P O p))->
     ((p,q:nat)(le p q)->(P p q)->(P (S p) (S q)))->
     (n,m:nat)(le n m)->(P n m).
Proof.
(*
Intros; Omega.
... Omega treat only statements of arithmetic (built on connectors ->,
\/, /\, ~, False, True and on arithmetical predicates =, <=, <, >=, >).
Here, P is not one of these predefined (and decidable) predicates.
*)
Induction n; Trivial with arith v62.
Intros n' HRec m Le.
Elim Le; Auto with arith v62.
Qed.


(* $Id: Le_omega.v,v 1.3 1999/06/29 13:09:05 loiseleu Exp $ *)
