(* program generated from PPML *)

(********************************************************************)
(*|                                                                |*)
(*|                              pprinter                          |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : french  *)

open Ppml;;
open Ppaux;;
open Ntpprinter;;
open Ppfrench_aux;;

(* Modifie a la main pour passage en o'caml *)
let def_sep_h1 = 0;;
let def_sep_h2 = 0;;
let def_sep_h = (def_sep_h1, def_sep_h2);;

let def_sep_v1 = 0;;
let def_sep_v2 = 0;;
let def_sep_v = (def_sep_v1, def_sep_v2);;
(* partout dans la suite:
    def_sep_h  remplace par  (def_sep_h1, def_sep_h2)
    def_sep_v  remplace par  (def_sep_v1, def_sep_v2) (en fait 0 fois) *)
(* Fin modification *)

let nc_set_pprinter_text () =
begin
nc_set_pprinter_text_integers ();

(********************************************************************)
(*|                                                                |*)
(*|                              chapter                           |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : vocabulary  *)

(

begin

(p_text_and := function c ->
box "h" (def_sep_h1, def_sep_h2)
  [< 'String "et" >]);

(p_text_theorem := function c ->
box "h" (def_sep_h1, def_sep_h2)
  [< 'String "Thorme" >]);

(p_text_definition := function c ->
box "h" (def_sep_h1, def_sep_h2)
  [< 'String "Dfinition" >]);

(p_text_axiom := function c ->
box "h" (def_sep_h1, def_sep_h2)
  [< 'String "Axiome" >]);

(p_text_type := function c ->
box "h" (def_sep_h1, def_sep_h2)
  [< 'String "Type" >]);

(p_text_statement := function c ->
box "h" (def_sep_h1, def_sep_h2)
  [< 'String "nonc" >]);

(p_text_proof := function c ->
box "h" (def_sep_h1, def_sep_h2)
  [< 'String "Preuve" >]);

(p_text_qed := function c ->
box "h" (def_sep_h1, def_sep_h2)
  [< 'String "Q.E.D." >]);

(p_text_int := function c ->
box "h" (def_sep_h1, def_sep_h2)
  [< 'String (nc_atm_text_int c) >]);

()

end);

(********************************************************************)
(*|                          end of chapter                        |*)
(********************************************************************)

(********************************************************************)
(*|                                                                |*)
(*|                              chapter                           |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : misc  *)

(

begin

(p_definition_expl := function c ->
box "hv" (1, 0)
  [< 'String "la"; 'String "dfinition"; 'String "de"; 'Std_ppcmds (!p_cst c ) >]);

(p_definition_cap := function c ->
box "hv" (1, 0)
  [< 'String "La"; 'String "dfinition"; 'String "de"; 'Std_ppcmds (!p_cst c ) >]);

(p_id_cap := function c ->
box "hv" (1, 0)
  [< (match (nc_int_id_nat c) with
    | 1 ->
      [< (if (nc_int_is_immediate_hypothesis c) = 1 then
            [< 'String "La"; 'String "dernire"; 'String "hypothse" >] else
         [< 'String "L'hypothse"; 'Std_ppcmds (pr_nc c ) >]
         ) >]
    | 2 -> [< 'String "Le"; 'String "thorme"; 'Std_ppcmds (pr_nc c ) >]
    | 3 -> [< 'String "L'axiome"; 'Std_ppcmds (pr_nc c ) >]
    | 4 -> [< 'Std_ppcmds (!p_induct_cst p_definition_cap c ) >]
    | 5 -> [< 'Std_ppcmds (!p_induct_cst p_definition_cap c ) >]
    | _ -> [< 'Std_ppcmds (pr_nc c ) >]
    ) >]);

(p_id_expl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_id_nat c) with
    | 1 ->
      [< (if (nc_int_is_immediate_hypothesis c) = 1 then
            [< 'String "la"; 'String "dernire"; 'String "hypothse" >] else
         [< 'String "l'hypothse"; 'Std_ppcmds (pr_nc c ) >]
         ) >]
    | 2 -> [< 'String "le"; 'String "thorme"; 'Std_ppcmds (pr_nc c ) >]
    | 3 -> [< 'String "l'axiome"; 'Std_ppcmds (pr_nc c ) >]
    | 4 -> [< 'Std_ppcmds (!p_induct_cst p_definition_expl c ) >]
    | 5 -> [< 'Std_ppcmds (!p_induct_cst p_definition_expl c ) >]
    | _ -> [< 'Std_ppcmds (pr_nc c ) >]
    ) >]);

(p_id := function c ->
box "hv" (1, 0)
  [< (match (nc_int_id_nat c) with
    | 1 ->
      [< (if (nc_int_is_immediate_hypothesis c) = 1 then
            [< 'Std_ppcmds (!p_id_expl c ) >] else
         [< 'Std_ppcmds (pr_nc c ) >]
         ) >]
    | 3 -> [< 'Std_ppcmds (!p_id_expl c ) >]
    | _ -> [< 'Std_ppcmds (pr_nc c ) >]
    ) >]);

()

end);

(********************************************************************)
(*|                          end of chapter                        |*)
(********************************************************************)

(********************************************************************)
(*|                                                                |*)
(*|                              chapter                           |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : types  *)

(

begin

(p_type_formula := function c ->
box "hv" (1, 0)
  [< (if (nc_int_is_type_False c) = 1 then [< 'String "une"; 'String "contradiction" >]
       else
    [< 'Std_ppcmds (!p_formula c ) >]
    ) >]);

(p_type_formula_bis := function c ->
box "hv" (1, 0)
  [< (if (nc_int_is_type_False c) = 1 then
       [< 'String "qu'il"; 'String "y"; 'String "a"; 'String "une"; 'String "contradiction" >]
       else
    [< 'Std_ppcmds (!p_formula c ) >]
    ) >]);

(p_type_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 -> [< 'String "pour"; 'String "prouver"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                           [< 'Std_ppcmds
                                                                (!p_type_3_bis c
                                                                ); 'String "," >]);
             'String "montrons"; 'Std_ppcmds (!p_type_2_bis c ); 'String "ce";
             'String "qui"; 'String "est"; 'String "quivalent"; 'String "";
             'Std_ppcmds (!p_type_1 c ) >]
    | 2 -> [< 'String "pour"; 'String "prouver"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                           [< 'Std_ppcmds
                                                                (!p_type_2 c );
                                                             'String "," >]);
             'String "montrons"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | 1 -> [< 'String "montrons"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_intro" >]
    ) >]);

(p_type_intro_cap := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 -> [< 'String "Pour"; 'String "prouver"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                           [< 'Std_ppcmds
                                                                (!p_type_3_bis c
                                                                ); 'String "," >]);
             'String "montrons"; 'Std_ppcmds (!p_type_2_bis c ); 'String "ce";
             'String "qui"; 'String "est"; 'String "quivalent"; 'String "";
             'Std_ppcmds (!p_type_1 c ) >]
    | 2 -> [< 'String "Pour"; 'String "prouver"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                           [< 'Std_ppcmds
                                                                (!p_type_2 c );
                                                             'String "," >]);
             'String "montrons"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | 1 -> [< 'String "Montrons"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_intro_cap" >]
    ) >]);

(p_type_intro_bis := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 -> [< 'String "pour"; 'String "prouver"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                           [< 'Std_ppcmds
                                                                (!p_type_3_bis c
                                                                ); 'String "," >]);
             'String "montrons"; 'Std_ppcmds (!p_type_2_bis c ); 'String "ce";
             'String "qui"; 'String "est"; 'String "quivalent"; 'String "";
             'Std_ppcmds (!p_type_1 c ) >]
    | 2 -> [< 'String "pour"; 'String "prouver"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                           [< 'Std_ppcmds
                                                                (!p_type_2 c );
                                                             'String "," >]);
             'String "montrons"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | 1 -> [< 'String "pour"; 'String "prouver"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_intro_bis" >]
    ) >]);

(p_type_intro_bis_cap := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 -> [< 'String "Pour"; 'String "prouver"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                           [< 'Std_ppcmds
                                                                (!p_type_3_bis c
                                                                ); 'String "," >]);
             'String "montrons"; 'Std_ppcmds (!p_type_2_bis c ); 'String "ce";
             'String "qui"; 'String "est"; 'String "quivalent"; 'String "";
             'Std_ppcmds (!p_type_1 c ) >]
    | 2 -> [< 'String "Pour"; 'String "prouver"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                           [< 'Std_ppcmds
                                                                (!p_type_2 c );
                                                             'String "," >]);
             'String "montrons"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | 1 -> [< 'String "Pour"; 'String "prouver"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_intro_bis_cap" >]
    ) >]);

(p_type_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 ->
      [< 'Std_ppcmds (!p_type_1 c ); 'String "ce"; 'String "qui"; 'String "signifie";
        'Std_ppcmds (!p_type_2_bis c ); 'String "ou";
        'Std_ppcmds (!p_type_3_bis c ) >]
    | 2 ->
      [< 'Std_ppcmds (!p_type_1 c ); 'String "ce"; 'String "qui"; 'String "signifie";
        'Std_ppcmds (!p_type_2_bis c ) >]
    | 1 -> [< 'Std_ppcmds (!p_type_1 c ) >]
    | _ -> [< 'String "ERROR type_concl" >]
    ) >]);

(p_type_concl_bis := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 ->
      [< 'Std_ppcmds (!p_type_1_bis c ); 'String "ce"; 'String "qui"; 'String "signifie";
        'Std_ppcmds (!p_type_2_bis c ); 'String "ou";
        'Std_ppcmds (!p_type_3_bis c ) >]
    | 2 ->
      [< 'Std_ppcmds (!p_type_1_bis c ); 'String "ce"; 'String "qui"; 'String "signifie";
        'Std_ppcmds (!p_type_2_bis c ) >]
    | 1 -> [< 'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_concl_bis" >]
    ) >]);

(p_type_concl_ter := function c ->
box "hv" (1, 0)
  [< (match (nc_int_number_of_types c) with
    | 3 ->
      [< 'String "affirmer"; 'Std_ppcmds (!p_type_1_bis c ); 'String "ce"; 'String "qui";
        'String "ce"; 'String "qui"; 'String "est"; 'String "quivalent"; 'String "";
        'String "affirmer"; 'Std_ppcmds (!p_type_2_bis c ); 'String "ou";
        'Std_ppcmds (!p_type_3_bis c ) >]
    | 2 ->
      [< 'String "affirmer"; 'Std_ppcmds (!p_type_1_bis c ); 'String "ce"; 'String "qui";
        'String "ce"; 'String "qui"; 'String "est"; 'String "quivalent"; 'String "";
        'String "affirmer"; 'Std_ppcmds (!p_type_2_bis c ) >]
    | 1 -> [< 'String "affirmer"; 'Std_ppcmds (!p_type_1_bis c ) >]
    | _ -> [< 'String "ERROR type_concl_ter" >]
    ) >]);

()

end);

(********************************************************************)
(*|                          end of chapter                        |*)
(********************************************************************)

(********************************************************************)
(*|                                                                |*)
(*|                              chapter                           |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : introduction  *)

(

begin

(p_elim_case_intro := function c ->
box "hv" (1, 0)
  [< 'String "Cas"; 'Std_ppcmds (!p_case_number c ); 'Std_ppcmds (box "h" (0, 1)
                                                                [< (match
                                                                     (nc_int_elim_case_nat
                                                                       c) with
                                                                   | 1 -> [< >]
                                                                   | 2 ->
                                                                     [< 'String
                                                                          "(trivial)" >]
                                                                   | 3 ->
                                                                     [< 'String
                                                                          "(absurde)" >]
                                                                   | 4 ->
                                                                     [< 'String
                                                                          "(de base)" >]
                                                                   | 5 ->
                                                                     [< 'String
                                                                          "(inductif)" >]
                                                                   | _ ->
                                                                     [< 'String
                                                                          "ERROR elim_case_intro" >]
                                                                   );
                                                                  'String ":" >]) >]);

(p_lambda_type := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_sort c) with
    | 1 ->
      [< 'Std_ppcmds (!p_lambda_binder_type c );
        (if (not ((nc_int_is_lambda_var_list_anonymous c) = 1)) then
           [< 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                             [< 'String "(";
                               'Std_ppcmds (!p_lambda_var_list_hyp c );
                               'String ")" >]) >] else
        [< >]
        ) >]
    | 2 ->
      [< (if (nc_int_lambda_var_list_length c) = 1 then
            [< 'String "un"; 'String "lment";
              'Std_ppcmds (!p_lambda_var_list c ); 'String "de";
              'Std_ppcmds (!p_lambda_binder_type c ) >] else
         [< 'String (nc_atm_lambda_text_var_list_length c); 'String "lments";
           'Std_ppcmds (!p_lambda_var_list c ); 'String "de";
           'Std_ppcmds (!p_lambda_binder_type c ) >]
         ) >]
    | _ -> [< (match (nc_int_lambda_typ_is_a_sort c) with
              | 1 ->
                [< (if (nc_int_lambda_var_list_length c) = 1 then
                      [< 'String "une"; 'String "proposition";
                        'Std_ppcmds (!p_lambda_var_list c ) >] else
                   [< 'String (nc_atm_lambda_text_var_list_length c);
                     'String "propositions"; 'Std_ppcmds (!p_lambda_var_list c ) >]
                   ) >]
              | 2 ->
                [< (if (nc_int_lambda_var_list_length c) = 1 then
                      [< 'String "un"; 'String "ensemble";
                        'Std_ppcmds (!p_lambda_var_list c ) >] else
                   [< 'String (nc_atm_lambda_text_var_list_length c);
                     'String "ensembles"; 'Std_ppcmds (!p_lambda_var_list c ) >]
                   ) >]
              | 3 ->
                [< (if (nc_int_lambda_var_list_length c) = 1 then
                      [< 'String "un"; 'String "type";
                        'Std_ppcmds (!p_lambda_var_list c ) >] else
                   [< 'String (nc_atm_lambda_text_var_list_length c); 'String "types";
                     'Std_ppcmds (!p_lambda_var_list c ) >]
                   ) >]
              | _ ->
                [< (if (nc_int_lambda_var_list_length c) = 1 then
                      [< 'String "un"; 'String "terme";
                        'Std_ppcmds (!p_lambda_var_list c ); 'String "de";
                        'String "type"; 'Std_ppcmds (!p_lambda_binder_type c ) >]
                      else
                   [< 'String (nc_atm_lambda_text_var_list_length c);
                     'String "termes"; 'Std_ppcmds (!p_lambda_var_list c );
                     'String "de"; 'String "type";
                     'Std_ppcmds (!p_lambda_binder_type c ) >]
                   ) >]
              ) >]
    ) >]);

(p_lambda_type_next := function c ->
box "hv" (1, 0)
  [< (if (nc_int_lambda_var_right c) > 0 then
       [< 'Std_ppcmds (!p_lambda_son p_lambda_type_next c ) >] else
    [< 'Std_ppcmds (!p_lambda_son p_lambda_type_list c ) >]
    ) >]);

(p_lambda_type_list := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_type_right c) with
    | 0 -> [< 'Std_ppcmds (!p_lambda_type c ) >]
    | 1 ->
      [< 'Std_ppcmds (!p_lambda_type c ); 'String "et";
        'Std_ppcmds (!p_lambda_type_next c ) >]
    | _ -> [< 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                             [< 'Std_ppcmds (!p_lambda_type c ); 'String "," >]);
              'Std_ppcmds (!p_lambda_type_next c ) >]
    ) >]);

(p_lambda_sort_next_bis := function c ->
box "hv" (1, 0)
  [< (if (nc_int_lambda_type_right c) > 0 || (nc_int_lambda_var_right c) > 0 then
       [< 'Std_ppcmds (!p_lambda_son p_lambda_sort_next_bis c ) >] else
    [< 'Std_ppcmds (!p_lambda_son p_lambda_sort_list_bis c ) >]
    ) >]);

(p_lambda_sort_bis := function c ->
box "hv" (1, 0)
  [< 'Std_ppcmds (!p_lambda_type_list c ) >]);

(p_lambda_sort_list_bis := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_sort_right c) with
    | 0 -> [< 'Std_ppcmds (!p_lambda_sort_bis c ) >]
    | _ -> [< 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                             [< 'Std_ppcmds (!p_lambda_sort_bis c ); 'String ";" >]);
              'Std_ppcmds (!p_lambda_sort_next c ) >]
    ) >]);

(p_lambda_sort_next := function c ->
box "hv" (1, 0)
  [< (if (nc_int_lambda_type_right c) > 0 || (nc_int_lambda_var_right c) > 0 then
       [< 'Std_ppcmds (!p_lambda_son p_lambda_sort_next c ) >] else
    [< 'Std_ppcmds (!p_lambda_son p_lambda_sort_list c ) >]
    ) >]);

(p_lambda_sort := function c ->
box "hv" (1, 0)
  [< (if (nc_int_is_lambda_in_case c) = 1 then
       [< (match (nc_int_lambda_sort c) with
          | 1 -> [< 'String "nous"; 'String "avons" >]
          | _ -> [< 'String "nous"; 'String "connaissons" >]
          ) >] else
    [< (match (nc_int_lambda_sort c) with
       | 1 -> [< (match (nc_int_lambda_nat c) with
                 | 3 | 4 -> [< 'String "supposons" >]
                 | 5 ->
                   [< 'String "par"; 'String "rcurrence"; 'String "nous";
                     'String "avons" >]
                 | _ -> [< 'String "posons"; 'String "par"; 'String "hypothse" >]
                 ) >]
       | _ -> [< (match (nc_int_lambda_nat c) with
                 | 3 | 4 -> [< 'String "supposons"; 'String "qu'il"; 'String "existe" >]
                 | _ ->
                   [< (if
                         (nc_int_lambda_var_list_length c) = 1 &&
                           (nc_int_lambda_type_right c) = 0 then
                         [< 'String "soit" >] else
                      [< 'String "soient" >]
                      ) >]
                 ) >]
       ) >]
    ); 'Std_ppcmds (!p_lambda_type_list c ) >]);

(p_lambda_sort_cap := function c ->
box "hv" (1, 0)
  [< (if (nc_int_is_lambda_in_case c) = 1 then
       [< (match (nc_int_lambda_sort c) with
          | 1 -> [< 'String "Nous"; 'String "avons" >]
          | _ -> [< 'String "Nous"; 'String "connaissons" >]
          ) >] else
    [< (match (nc_int_lambda_sort c) with
       | 1 -> [< (match (nc_int_lambda_nat c) with
                 | 3 | 4 -> [< 'String "Supposons" >]
                 | 5 ->
                   [< 'String "Par"; 'String "rcurrence"; 'String "nous";
                     'String "avons" >]
                 | _ -> [< 'String "Posons"; 'String "par"; 'String "hypothse" >]
                 ) >]
       | _ -> [< (match (nc_int_lambda_nat c) with
                 | 3 | 4 -> [< 'String "Supposons"; 'String "qu'il"; 'String "existe" >]
                 | _ ->
                   [< (if
                         (nc_int_lambda_var_list_length c) = 1 &&
                           (nc_int_lambda_type_right c) = 0 then
                         [< 'String "Soit" >] else
                      [< 'String "Soient" >]
                      ) >]
                 ) >]
       ) >]
    ); 'Std_ppcmds (!p_lambda_type_list c ) >]);

(p_lambda_sort_list := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_sort_right c) with
    | 0 -> [< 'Std_ppcmds (!p_lambda_sort c ) >]
    | _ -> [< (match (nc_int_lambda_coord c) with
              | 1 ->
                [< 'Std_ppcmds (!p_lambda_sort c );
                  (if
                     (nc_int_lambda_var_list_length c) = 1 &&
                       (nc_int_lambda_type_right c) = 0 then
                     [< 'String "tel"; 'String "que" >] else
                  [< 'String "tels"; 'String "que" >]
                  ); 'Std_ppcmds (!p_lambda_sort_next_bis c ) >]
              | _ -> [< 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                       [< 'Std_ppcmds (!p_lambda_sort c );
                                         'String ";" >]);
                        'Std_ppcmds (!p_lambda_sort_next c ) >]
              ) >]
    ) >]);

(p_lambda_sort_list_cap := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_sort_right c) with
    | 0 -> [< 'Std_ppcmds (!p_lambda_sort_cap c ) >]
    | _ -> [< (match (nc_int_lambda_coord c) with
              | 1 ->
                [< 'Std_ppcmds (!p_lambda_sort_cap c );
                  (if
                     (nc_int_lambda_var_list_length c) = 1 &&
                       (nc_int_lambda_type_right c) = 0 then
                     [< 'String "tel"; 'String "que" >] else
                  [< 'String "tels"; 'String "que" >]
                  ); 'Std_ppcmds (!p_lambda_sort_next_bis c ) >]
              | _ -> [< 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                       [< 'Std_ppcmds (!p_lambda_sort_cap c );
                                         'String ";" >]);
                        'Std_ppcmds (!p_lambda_sort_next c ) >]
              ) >]
    ) >]);

(p_lambda_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1000 -> [< 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                 [< 'Std_ppcmds (!p_type_intro_bis_cap c );
                                   'String "," >]); 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                                [< 'Std_ppcmds
                                                                    (!p_lambda_sort_list
                                                                    c );
                                                                  'String "." >]) >]
    | 0000 -> [< 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                 [< 'Std_ppcmds (!p_lambda_sort_list_cap c );
                                   'String "." >]) >]
    | _ -> [< 'String "ERROR lambda_intro" >]
    ) >]);

(p_apply_std_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "avec";
        'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                       [< 'Std_ppcmds (!p_apply_head p_id c ); 'String "." >]) >]
    | 1000 -> [< 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                 [< 'Std_ppcmds (!p_type_intro_cap c );
                                   'String "." >]) >]
    | 0100 -> [< 'String "Nous"; 'String "utilisons"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                               [< 'Std_ppcmds
                                                                    (!p_apply_head
                                                                    p_id c );
                                                                 'String "." >]) >]
    | _ -> [< 'String "ERROR apply_omit_intro" >]
    ) >]);

(p_apply_omit_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1000 -> [< 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                 [< 'Std_ppcmds (!p_type_intro_cap c );
                                   'String "." >]) >]
    | _ -> [< 'String "ERROR apply_omit_intro" >]
    ) >]);

(p_apply_construct_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "avec";
        'Std_ppcmds (!p_apply_head p_id_expl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1000 -> [< 'Std_ppcmds (!p_type_intro_cap c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0100 ->
      [< 'String "Nous"; 'String "utilisons"; 'Std_ppcmds (!p_apply_head p_id_expl c );
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | _ -> [< 'String "ERROR apply_construct_intro" >]
    ) >]);

(p_elim_match_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1110 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "distinguons";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cas"; 'String "dans";
        'String "l'tude"; 'String "de"; 'Std_ppcmds (!p_elim_head p_id c );
        'String "d'aprs"; 'Std_ppcmds (!p_induct_cst p_definition_expl c );
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "distinguons";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cas"; 'String "d'aprs";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 1010 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "distinguons";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cas"; 'String "dans";
        'String "l'tude"; 'String "de"; 'Std_ppcmds (!p_elim_head p_id c );
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1000 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "distinguons";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cas." >]
    | 0110 ->
      [< 'String "Distinguons"; 'String (nc_atm_text_nbr_elim_cases c); 'String "cas";
        'String "dans"; 'String "l'tude"; 'String "de";
        'Std_ppcmds (!p_elim_head p_id c ); 'String "d'aprs";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 0100 ->
      [< 'String "Distinguons"; 'String (nc_atm_text_nbr_elim_cases c); 'String "cas";
        'String "d'aprs"; 'Std_ppcmds (!p_elim_head p_id c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 0010 ->
      [< 'String "Distinguons"; 'String (nc_atm_text_nbr_elim_cases c); 'String "cas";
        'String "dans"; 'String "l'tude"; 'String "de";
        'Std_ppcmds (!p_elim_head p_id c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0000 ->
      [< 'String "Distinguons"; 'String (nc_atm_text_nbr_elim_cases c);
        'String "cas." >]
    | _ -> [< 'String "ERROR elim_match_intro" >]
    ) >]);

(p_elim_match_one_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1110 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "utilisons";
        'Std_ppcmds (!p_elim_head p_id c ); 'String "avec";
        'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                       [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                         'String "." >]) >]
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "utilisons";
        'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                       [< 'Std_ppcmds (!p_induct_cst p_definition_expl c );
                         'String "." >]) >]
    | 1010 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "nous"; 'String "utilisons";
        'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                       [< 'Std_ppcmds (!p_elim_head p_id c ); 'String "." >]) >]
    | 1000 -> [< 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                 [< 'Std_ppcmds (!p_type_intro_bis_cap c );
                                   'String "." >]) >]
    | 0110 ->
      [< 'String "Nous"; 'String "utilisons"; 'Std_ppcmds (!p_elim_head p_id c );
        'String "avec"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                     [< 'Std_ppcmds (!p_induct_cst
                                          p_definition_expl c ); 'String "." >]) >]
    | 0100 -> [< 'String "Nous"; 'String "utilisons"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                               [< 'Std_ppcmds
                                                                    (!p_induct_cst
                                                                    p_definition_expl
                                                                    c );
                                                                 'String "." >]) >]
    | 0010 -> [< 'String "Nous"; 'String "utilisons"; 'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                                                               [< 'Std_ppcmds
                                                                    (!p_elim_head
                                                                    p_id c );
                                                                 'String "." >]) >]
    | 0000 ->
      [< 'String "Nous"; 'String "utilisons"; 'String "ce"; 'String "dernier";
        'String "rsultat." >]
    | _ -> [< 'String "ERROR elim_match_one_intro" >]
    ) >]);

(p_elim_match_absurd_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1110 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "distinguons";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cas"; 'String "dans";
        'String "l'tude"; 'String "de"; 'Std_ppcmds (!p_elim_head p_id c );
        'String "d'aprs"; 'Std_ppcmds (!p_induct_cst p_definition_expl c );
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "distinguons";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cas"; 'String "d'aprs";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 1010 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "distinguons";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cas"; 'String "dans";
        'String "l'tude"; 'String "de"; 'Std_ppcmds (!p_elim_head p_id c );
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1000 ->
      [< 'Std_ppcmds (!p_type_intro_bis_cap c ); 'String "distinguons";
        'String (nc_atm_text_nbr_elim_cases c); 'String "cas." >]
    | 0110 ->
      [< 'String "Distinguons"; 'String (nc_atm_text_nbr_elim_cases c); 'String "cas";
        'String "dans"; 'String "l'tude"; 'String "de";
        'Std_ppcmds (!p_elim_head p_id c ); 'String "d'aprs";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 0100 ->
      [< 'String "Distinguons"; 'String (nc_atm_text_nbr_elim_cases c); 'String "cas";
        'String "d'aprs"; 'Std_ppcmds (!p_elim_head p_id c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 0010 ->
      [< 'String "Distinguons"; 'String (nc_atm_text_nbr_elim_cases c); 'String "cas";
        'String "dans"; 'String "l'tude"; 'String "de";
        'Std_ppcmds (!p_elim_head p_id c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0000 ->
      [< 'String "Distinguons"; 'String (nc_atm_text_nbr_elim_cases c);
        'String "cas." >]
    | _ -> [< 'String "ERROR elim_match_intro" >]
    ) >]);

(p_elim_induc_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1110 ->
      [< 'String "Avec"; 'Std_ppcmds (!p_elim_head p_id c ); 'Sep (def_sep_h1, def_sep_h2);
        'String ","; 'Std_ppcmds (!p_type_intro c ); 'String "par"; 'String "induction";
        'String "sur"; 'Std_ppcmds (!p_induct_cst p_definition_expl c );
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1100 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "par"; 'String "induction";
        'String "sur"; 'Std_ppcmds (!p_induct_cst p_definition_expl c );
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1010 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "par"; 'String "induction";
        'String "sur"; 'Std_ppcmds (!p_elim_head p_id c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 1000 ->
      [< 'Std_ppcmds (!p_type_intro_cap c ); 'String "par"; 'String "induction";
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0110 ->
      [< 'String "Avec"; 'Std_ppcmds (!p_elim_head p_id c ); 'Sep (def_sep_h1, def_sep_h2);
        'String ","; 'String "faisons"; 'String "une"; 'String "induction"; 'String "sur";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 0100 ->
      [< 'String "Nous"; 'String "faisons"; 'String "une"; 'String "induction";
        'String "sur"; 'Std_ppcmds (!p_induct_cst p_definition_expl c );
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0010 ->
      [< 'String "Nous"; 'String "faisons"; 'String "une"; 'String "induction";
        'String "sur"; 'Std_ppcmds (!p_elim_head p_id c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 0000 ->
      [< 'String "Nous"; 'String "faisons"; 'String "une"; 'String "induction";
        'String "." >]
    | _ -> [< 'String "ERROR elim_induc_intro" >]
    ) >]);

(p_trivial_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_lambda_sort c) with
    | 1 -> [< 'String "Nous"; 'String "avons" >]
    | _ -> [< 'String "Nous"; 'String "connaissons" >]
    ); (match (nc_int_lambda_sort_right c) with
       | 0 -> [< 'Std_ppcmds (!p_lambda_type_list c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
       | _ -> [< (match (nc_int_lambda_coord c) with
                 | 1 ->
                   [< 'Std_ppcmds (!p_lambda_type_list c );
                     (if
                       (nc_int_lambda_var_list_length c) = 1 &&
                         (nc_int_lambda_type_right c) = 0 then
                       [< 'String "tel"; 'String "que" >] else
                     [< 'String "tels"; 'String "que" >]
                     ); 'Std_ppcmds (!p_lambda_sort_next_bis c ); 'Sep (def_sep_h1, def_sep_h2);
                     'String "." >]
                 | _ ->
                   [< 'Std_ppcmds (!p_lambda_type_list c ); 'Sep (def_sep_h1, def_sep_h2);
                     'String ";"; 'Std_ppcmds (!p_lambda_sort_next c );
                     'Sep (def_sep_h1, def_sep_h2); 'String "." >]
                 ) >]
       ) >]);

(p_misc_intro := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_intro_elements c) with
    | 1000 -> [< 'Std_ppcmds (!p_type_intro_cap c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | _ -> [< 'String "ERROR misc_intro" >]
    ) >]);

()

end);

(********************************************************************)
(*|                          end of chapter                        |*)
(********************************************************************)

(********************************************************************)
(*|                                                                |*)
(*|                              chapter                           |*)
(*|                                                                |*)
(********************************************************************)
(*  Name : conclusions  *)

(

begin

(p_lambda_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 -> [< (match (nc_int_lambda_nat c) with
                  | 3 ->
                    [< 'String "Nous"; 'String "avons"; 'String "donc";
                      'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
                  | 4 ->
                    [< 'String "Nous"; 'String "pouvons"; 'String "donc";
                      'Std_ppcmds (!p_type_concl_ter c ); 'Sep (def_sep_h1, def_sep_h2);
                      'String "." >]
                  | _ ->
                    [< 'String "Nous"; 'String "avons"; 'String "montr";
                      'Std_ppcmds (!p_type_concl_bis c ); 'Sep (def_sep_h1, def_sep_h2);
                      'String "." >]
                  ) >]
    | _ -> [< 'String "ERROR lambda_concl" >]
    ) >]);

(p_apply_std_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1110 ->
      [< (if (nc_int_is_concl_false c) = 1 && (nc_int_number_of_types c) = 1 then
            [< 'String "Or,"; 'Std_ppcmds (!p_apply_head p_id c ); 'String "contredit";
              'Std_ppcmds (!p_apply_sub_horiz_expl c ); 'Sep (def_sep_h1, def_sep_h2);
              'String "." >] else
         [< 'String "En"; 'String "utilisant"; 'Std_ppcmds (!p_apply_head p_id c );
           'String "avec"; 'Std_ppcmds (!p_apply_sub_horiz c ); 'String "nous";
           'String "obtenons"; 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2);
           'String "." >]
         ) >]
    | 1100 ->
      [< (if (nc_int_is_concl_false c) = 1 && (nc_int_number_of_types c) = 1 then
            [< (if (nc_int_apply_subs_number c) = 1 then
                 [< 'String "Or,"; 'Std_ppcmds (!p_apply_head p_id c );
                   'String "contredit"; 'String "ce"; 'String "rsultat." >] else
               [< 'String "Or,"; 'Std_ppcmds (!p_apply_head p_id c );
                 'String "contredit"; 'String "ces"; 'String "rsultats." >]
               ) >] else
         [< (if (nc_int_apply_subs_number c) = 1 then
               [< 'String "En"; 'String "utilisant";
                 'Std_ppcmds (!p_apply_head p_id c ); 'String "avec"; 'String "ce";
                 'String "rsultat"; 'String "nous"; 'String "obtenons";
                 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >] else
            [< 'String "En"; 'String "utilisant"; 'Std_ppcmds (!p_apply_head p_id c );
              'String "avec"; 'String "ces"; 'String "rsultats"; 'String "nous";
              'String "obtenons"; 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2);
              'String "." >]
            ) >]
         ) >]
    | 1010 ->
      [< (if
            ((nc_int_is_concl_false c) = 1 && (nc_int_number_of_types c) = 1) &&
              (nc_int_apply_subs_number c) = 1 then
            [< 'String "Or,"; 'String "ce"; 'String "rsultat"; 'String "contredit";
              'Std_ppcmds (!p_apply_sub_horiz c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
            else
         [< 'String "Donc,"; 'String "avec"; 'Std_ppcmds (!p_apply_sub_horiz c );
           'String "nous"; 'String "obtenons"; 'Std_ppcmds (!p_type_concl c );
           'Sep (def_sep_h1, def_sep_h2); 'String "." >]
         ) >]
    | 1000 ->
      [< (if (nc_int_is_concl_false c) = 1 then
            [< (if (nc_int_number_of_types c) = 1 then
                 [< (if (nc_int_apply_subs_number c) = 1 then
                       [< 'String "Or,"; 'String "ces"; 'String "deux";
                         'String "rsultats"; 'String "sont";
                         'String "contradictoires." >] else
                    [< (if (nc_int_is_apply_head_up c) = 1 then
                          [< 'String "Or,"; 'String "le"; 'String "premier";
                            'String "rsultat"; 'String "contredit"; 'String "les";
                            'String "suivants." >] else
                       [< 'String "Or,"; 'String "ce"; 'String "dernier";
                         'String "rsultat"; 'String "contredit"; 'String "les";
                         'String "prcdents" >]
                       ) >]
                    ) >] else
               [< (if (nc_int_apply_subs_number c) = 1 then
                    [< (if (nc_int_is_apply_head_up c) = 1 then
                          [< 'String "Or,"; 'String "en"; 'String "appliquant";
                            'String "le"; 'String "premier"; 'String "rsultat";
                            'String "au"; 'String "second"; 'String "nous";
                            'String "obtenons"; 'Std_ppcmds (!p_type_concl c );
                            'Sep (def_sep_h1, def_sep_h2); 'String "." >] else
                       [< 'String "Or,"; 'String "en"; 'String "ce"; 'String "dernier";
                         'String "rsultat"; 'String "au";
                         'String "prcdent"; 'String "nous";
                         'String "obtenons"; 'Std_ppcmds (!p_type_concl c );
                         'Sep (def_sep_h1, def_sep_h2); 'String "." >]
                       ) >] else
                  [< (if (nc_int_is_apply_head_up c) = 1 then
                       [< 'String "Or,"; 'String "en"; 'String "appliquant"; 'String "le";
                         'String "premier"; 'String "rsultat"; 'String "aux";
                         'String "suivants"; 'String "nous"; 'String "obtenons";
                         'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2);
                         'String "." >] else
                    [< 'String "Or,"; 'String "en"; 'String "ce"; 'String "dernier";
                      'String "rsultat"; 'String "aux"; 'String "prcdents";
                      'String "nous"; 'String "obtenons";
                      'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
                    ) >]
                  ) >]
               ) >] else
         [< (if (nc_int_apply_subs_number c) = 1 then
               [< (if (nc_int_is_apply_head_up c) = 1 then
                    [< 'String "En"; 'String "appliquant"; 'String "le";
                      'String "premier"; 'String "rsultat"; 'String "au";
                      'String "second"; 'String "nous"; 'String "obtenons";
                      'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
                    else
                  [< 'String "En"; 'String "ce"; 'String "dernier"; 'String "rsultat";
                    'String "au"; 'String "prcdent"; 'String "nous";
                    'String "obtenons"; 'Std_ppcmds (!p_type_concl c );
                    'Sep (def_sep_h1, def_sep_h2); 'String "." >]
                  ) >] else
            [< (if (nc_int_is_apply_head_up c) = 1 then
                  [< 'String "En"; 'String "appliquant"; 'String "le"; 'String "premier";
                    'String "rsultat"; 'String "aux"; 'String "suivants";
                    'String "nous"; 'String "obtenons"; 'Std_ppcmds (!p_type_concl c );
                    'Sep (def_sep_h1, def_sep_h2); 'String "." >] else
               [< 'String "En"; 'String "ce"; 'String "dernier"; 'String "rsultat";
                 'String "aux"; 'String "prcdents"; 'String "nous";
                 'String "obtenons"; 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2);
                 'String "." >]
               ) >]
            ) >]
         ) >]
    | 0110 ->
      [< 'String "Nous"; 'String "appliquons"; 'Std_ppcmds (!p_apply_head p_id c );
        'String ""; 'Std_ppcmds (!p_apply_sub_horiz c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 0100 ->
      [< 'String "Nous"; 'String "appliquons"; 'String "maintenant";
        'Std_ppcmds (!p_apply_head p_id c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0010 ->
      [< 'String "Nous"; 'String "appliquons"; 'String "ce"; 'String "rsultat";
        'String ""; 'Std_ppcmds (!p_apply_sub_horiz c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 0000 ->
      [< (if (nc_int_is_apply_head_up c) = 1 then
            [< (if (nc_int_apply_subs_number c) = 1 then
                 [< 'String "Nous"; 'String "appliquons"; 'String "le"; 'String "premier";
                   'String "rsultat"; 'String "au"; 'String "second." >] else
               [< 'String "Nous"; 'String "appliquons"; 'String "le"; 'String "premier";
                 'String "rsultat"; 'String "aux"; 'String "suivants." >]
               ) >] else
         if (nc_int_apply_subs_number c) = 1 then
           [< 'String "Nous"; 'String "appliquons"; 'String "ce"; 'String "dernier";
             'String "rsultat"; 'String "au"; 'String "prcdent." >] else
         [< 'String "Nous"; 'String "appliquons"; 'String "ce"; 'String "dernier";
           'String "rsultat"; 'String "aux"; 'String "prcdents." >]
         ) >]
    | _ -> [< 'String "ERROR apply_concl" >]
    ) >]);

(p_apply_std_specialization_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1100 ->
      [< 'String "De"; 'Std_ppcmds (!p_apply_head p_id c ); 'String "il";
        'String "vient"; 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1000 ->
      [< 'String "De"; 'String "ce"; 'String "rsultat"; 'String "il"; 'String "vient";
        'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0100 ->
      [< 'String "Nous"; 'String "spcialisons";
        'Std_ppcmds (!p_apply_head p_id c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0000 ->
      [< 'String "Nous"; 'String "spcialisons"; 'String "ce"; 'String "rsultat" >]
    | _ -> [< 'String "ERROR apply_specialization_concl" >]
    ) >]);

(p_apply_omit_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1010 ->
      [< 'String "Par"; 'Std_ppcmds (!p_apply_sub_horiz c ); 'String "nous";
        'String "avons"; 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 1000 ->
      [< (if (nc_int_apply_subs_number c) = 1 then
            [< 'String "De"; 'String "ce"; 'String "rsultat"; 'String "il";
              'String "vient"; 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2);
              'String "." >] else
         [< 'String "De"; 'String "ces"; 'String "rsultats"; 'String "il";
           'String "vient"; 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2);
           'String "." >]
         ) >]
    | 0010 ->
      [< 'String "Nous"; 'String "utilisons"; 'Std_ppcmds (!p_apply_sub_horiz c );
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | _ -> [< 'String "ERROR omit_concl" >]
    ) >]);

(p_apply_omit_specialization_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "Nous"; 'String "obtenons"; 'String "directement";
        'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0000 -> [< 'String "Cela"; 'String "est"; 'String "immdiat." >]
    | _ -> [< 'String "ERROR omit_specialization_concl" >]
    ) >]);

(p_apply_construct_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1110 ->
      [< 'String "D'aprs"; 'Std_ppcmds (!p_apply_head p_id_expl c );
        'Sep (def_sep_h1, def_sep_h2); 'String ","; 'String "avec";
        'Std_ppcmds (!p_apply_sub_horiz c ); 'String "nous"; 'String "avons";
        'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1100 ->
      [< 'String "Donc,"; 'String "d'aprs";
        'Std_ppcmds (!p_apply_head p_id_expl c ); 'String "nous"; 'String "avons";
        'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1010 ->
      [< 'String "Avec"; 'Std_ppcmds (!p_apply_sub_horiz c ); 'String "nous";
        'String "avons"; 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 1000 ->
      [< 'String "Donc,"; 'String "nous"; 'String "avons";
        'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0110 ->
      [< 'String "Nous"; 'String "appliquons";
        'Std_ppcmds (!p_apply_head p_id_expl c ); 'String "";
        'Std_ppcmds (!p_apply_sub_horiz c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0100 ->
      [< 'String "Nous"; 'String "appliquons"; 'String "maintenant";
        'Std_ppcmds (!p_apply_head p_id_expl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0010 ->
      [< 'String "Nous"; 'String "utilisons"; 'Std_ppcmds (!p_apply_sub_horiz c );
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | _ -> [< 'String "ERROR construct_concl" >]
    ) >]);

(p_apply_construct_specialization_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1100 ->
      [< 'String "De"; 'Std_ppcmds (!p_apply_head p_id_expl c ); 'String "il";
        'String "vient"; 'String "directement"; 'Std_ppcmds (!p_type_concl c );
        'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1000 ->
      [< 'String "Nous"; 'String "avons"; 'String "directement";
        'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0100 ->
      [< 'String "Nous"; 'String "spcialisons";
        'Std_ppcmds (!p_apply_head p_id_expl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0000 ->
      [< 'String "Nous"; 'String "spcialisons"; 'String "ce"; 'String "rsultat." >]
    | _ -> [< 'String "ERROR construct_specialization_concl" >]
    ) >]);

(p_elim_match_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "Nous"; 'String "avons"; 'String "montr";
        'Std_ppcmds (!p_type_concl_bis c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | _ -> [< 'String "ERROR elim_match_concl" >]
    ) >]);

(p_elim_match_one_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "Nous"; 'String "avons"; 'String "montr";
        'Std_ppcmds (box "h" (def_sep_h1, def_sep_h2)
                       [< 'Std_ppcmds (!p_type_concl_bis c ); 'String "." >]) >]
    | _ -> [< 'String "ERROR elim_match_one_concl" >]
    ) >]);

(p_elim_match_no_case_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1110 ->
      [< (if (nc_int_is_concl_false c) = 1 then
            [< 'Std_ppcmds (!p_elim_head p_id_cap c ); 'String "contredit";
              'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'Sep (def_sep_h1, def_sep_h2);
              'String "." >] else
         [< 'Std_ppcmds (!p_elim_head p_id_cap c ); 'String "contredit";
           'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'Sep (def_sep_h1, def_sep_h2);
           'String ","; 'String "nous"; 'String "pouvons"; 'String "donc";
           'Std_ppcmds (!p_type_concl_ter c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
         ) >]
    | 1100 ->
      [< (if (nc_int_is_concl_false c) = 1 then
            [< 'String "Ce"; 'String "rsultat"; 'String "contredit";
              'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'Sep (def_sep_h1, def_sep_h2);
              'String "." >] else
         [< 'String "Ce"; 'String "rsultat"; 'String "contredit";
           'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'Sep (def_sep_h1, def_sep_h2);
           'String ","; 'String "nous"; 'String "pouvons"; 'String "donc";
           'Std_ppcmds (!p_type_concl_ter c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
         ) >]
    | 1010 ->
      [< 'String "Avec"; 'Std_ppcmds (!p_elim_head p_id c ); 'String "nous";
        'String "pouvons"; 'Std_ppcmds (!p_type_concl_ter c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 1000 ->
      [< 'String "Nous"; 'String "pouvons"; 'String "donc";
        'Std_ppcmds (!p_type_concl_ter c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0110 ->
      [< 'Std_ppcmds (!p_elim_head p_id_cap c ); 'String "contredit";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 0100 ->
      [< 'String "Ce"; 'String "rsultat"; 'String "contredit";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | _ -> [< 'String "ERROR elim_no_case_concl" >]
    ) >]);

(p_elim_match_absurd_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< (if
            ((nc_int_is_concl_false c) = 1 && (nc_int_number_of_types c) = 1) &&
              (nc_int_apply_subs_number c) = 1 then
            [< 'String "Nous"; 'String "avons"; 'String "montr";
              'Std_ppcmds (!p_type_concl_bis c ); 'String "dans"; 'String "chaque";
              'String "cas." >] else
         [< 'String "Tous"; 'String "les"; 'String "cas"; 'String "mnent";
           'String ""; 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2);
           'String "." >]
         ) >]
    | _ -> [< 'String "ERROR elim_match_absurd_concl" >]
    ) >]);

(p_elim_match_trivial_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1110 ->
      [< 'String "En"; 'String "utilisant"; 'Std_ppcmds (!p_elim_head p_id c );
        'String "avec"; 'Std_ppcmds (!p_induct_cst p_definition_expl c );
        'Sep (def_sep_h1, def_sep_h2); 'String ","; 'String "nous"; 'String "obtenons";
        'String "trivialement"; 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 1100 ->
      [< 'String "Avec"; 'Std_ppcmds (!p_induct_cst p_definition_expl c );
        'Sep (def_sep_h1, def_sep_h2); 'String ","; 'String "nous"; 'String "obtenons";
        'String "trivialement"; 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | 1010 ->
      [< 'String "En"; 'String "utilisant"; 'Std_ppcmds (!p_elim_head p_id c );
        'String ","; 'String "nous"; 'String "obtenons"; 'String "trivialement";
        'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 1000 ->
      [< 'String "Nous"; 'String "obtenons"; 'String "trivialement";
        'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0110 ->
      [< 'String "Nous"; 'String "utilisons"; 'Std_ppcmds (!p_elim_head p_id c );
        'String "avec"; 'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'String "de";
        'String "faon"; 'String "triviale." >]
    | 0100 ->
      [< 'String "Nous"; 'String "utilisons";
        'Std_ppcmds (!p_induct_cst p_definition_expl c ); 'String "de";
        'String "faon"; 'String "triviale." >]
    | 0010 ->
      [< 'String "Nous"; 'String "utilisons"; 'Std_ppcmds (!p_elim_head p_id c );
        'String "de"; 'String "faon"; 'String "triviale." >]
    | _ -> [< 'String "ERROR elim_trivial_concl" >]
    ) >]);

(p_elim_induc_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "Nous"; 'String "avons"; 'String "montr";
        'Std_ppcmds (!p_type_concl_bis c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | _ -> [< 'String "ERROR elim_induc_concl" >]
    ) >]);

(p_fix_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "Nous"; 'String "avons"; 'String "montr";
        'Std_ppcmds (!p_type_concl_bis c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | _ -> [< 'String "ERROR fix_conl" >]
    ) >]);

(p_identifier_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1001 ->
      [< 'String "Par"; 'Std_ppcmds (!p_id c ); 'String "nous"; 'String "avons";
        'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0001 ->
      [< 'String "Nous"; 'String "utilisons"; 'Std_ppcmds (!p_id c ); 'Sep (def_sep_h1, def_sep_h2);
        'String "." >]
    | _ -> [< 'String "ERROR identifier_concl" >]
    ) >]);

(p_metavar_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 -> [< 'Std_ppcmds (box "hv" (1, 0)
                                 [< 'String "Imaginez"; 'String "une";
                                   'String "preuve"; 'String "de" >]);
                 'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0000 -> [< 'Std_ppcmds (box "hv" (1, 0)
                                 [< 'String "Imaginez"; 'String "une";
                                   'String "preuve." >]) >]
    | _ -> [< 'String "ERROR metavar_concl" >]
    ) >]);

(p_trivial_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "Nous"; 'String "avons"; 'String "trivialement";
        'Std_ppcmds (!p_type_concl c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | 0000 -> [< 'String "Cela"; 'String "est"; 'String "trivial." >]
    | _ -> [< 'String "ERROR trivial_concl" >]
    ) >]);

(p_misc_concl := function c ->
box "hv" (1, 0)
  [< (match (nc_int_select_concl_elements c) with
    | 1000 ->
      [< 'String "Nous"; 'String "avons"; 'String "montr";
        'Std_ppcmds (!p_type_concl_bis c ); 'Sep (def_sep_h1, def_sep_h2); 'String "." >]
    | _ -> [< 'String "ERROR misc_concl" >]
    ) >]);

()

end)

(********************************************************************)
(*|                          end of chapter                        |*)
(********************************************************************)

end;;

(********************************************************************)
(*|                          end of pprinter                       |*)
(********************************************************************)
