(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 pcoq.mli                                 *)
(****************************************************************************)

(* The lexer and parser of Coq *)
val lexer : Token.lexer
module Gram : Grammar.S
type typed_entry =
    Ast of CoqAst.t Gram.Entry.e
  | ListAst of CoqAst.t list Gram.Entry.e
val grammar_extend :
  typed_entry -> Gramext.position option ->
    (string option * Gramext.g_assoc option *
     (Gramext.g_symbol list * Gramext.g_action) list) list
    -> unit
val remove_grammars : int -> unit

(* Parse a string *)
val parse_string : 'a Gram.Entry.e -> string -> 'a
val eoi_entry : 'a Gram.Entry.e -> 'a Gram.Entry.e
val map_entry : ('a -> 'b) -> 'a Gram.Entry.e -> 'b Gram.Entry.e

val slam_ast : CoqAst.loc -> CoqAst.t -> CoqAst.t -> CoqAst.t


(* Entry types *)
type entry_type = ETast | ETastl

val entry_type : CoqAst.t -> entry_type
val type_of_entry : typed_entry -> entry_type


(* Table of Coq's grammar entries *)
type gram_universe

val get_univ : string -> string * gram_universe
val get_entry :  string * gram_universe -> string -> typed_entry

val create_entry : string * gram_universe -> string -> entry_type ->
  typed_entry
val force_entry_type : string * gram_universe -> string ->
  entry_type -> typed_entry

(* Quotations *)
val define_quotation : bool -> string -> (CoqAst.t Gram.Entry.e) -> unit

(* The main entry: reads an optional vernac command *)
val main_entry : CoqAst.t option Gram.Entry.e

(* Initial state of the grammar *)
module Command :
  sig
    val abstraction_tail : CoqAst.t Gram.Entry.e
    val binder : CoqAst.t Gram.Entry.e
    val cofixbinder : CoqAst.t Gram.Entry.e
    val cofixbinders : CoqAst.t list Gram.Entry.e
    val command : CoqAst.t Gram.Entry.e
    val command0 : CoqAst.t Gram.Entry.e
    val command1 : CoqAst.t Gram.Entry.e
    val command10 : CoqAst.t Gram.Entry.e
    val command2 : CoqAst.t Gram.Entry.e
    val command3 : CoqAst.t Gram.Entry.e
    val command5 : CoqAst.t Gram.Entry.e
    val command6 : CoqAst.t Gram.Entry.e
    val command7 : CoqAst.t Gram.Entry.e
    val command8 : CoqAst.t Gram.Entry.e
    val command9 : CoqAst.t Gram.Entry.e
    val command91 : CoqAst.t Gram.Entry.e
    val command_eoi : CoqAst.t Gram.Entry.e
    val equation : CoqAst.t Gram.Entry.e
    val fixbinder : CoqAst.t Gram.Entry.e
    val fixbinders : CoqAst.t list Gram.Entry.e
    val ident : CoqAst.t Gram.Entry.e
    val lassoc_command4 : CoqAst.t Gram.Entry.e
    val lcommand : CoqAst.t Gram.Entry.e
    val lsimple_pattern : (string list * CoqAst.t) Gram.Entry.e
    val ne_binder_list : CoqAst.t list Gram.Entry.e
    val ne_command91_list : CoqAst.t list Gram.Entry.e
    val ne_command9_list : CoqAst.t list Gram.Entry.e
    val ne_command_list : CoqAst.t list Gram.Entry.e
    val ne_eqn_list : CoqAst.t list Gram.Entry.e
    val ne_ident_comma_list : CoqAst.t list Gram.Entry.e
    val ne_pattern_list : (string list * CoqAst.t list) Gram.Entry.e
    val pattern : (string list * CoqAst.t) Gram.Entry.e
    val pattern_list : (string list * CoqAst.t list) Gram.Entry.e
    val product_tail : CoqAst.t Gram.Entry.e
    val raw_command : CoqAst.t Gram.Entry.e
    val simple_pattern : (string list * CoqAst.t) Gram.Entry.e
    val simple_pattern2 : (string list * CoqAst.t) Gram.Entry.e
    val simple_pattern_list : (string list * CoqAst.t list) Gram.Entry.e
  end


module Tactic :
  sig
    val autoarg_adding : CoqAst.t Gram.Entry.e
    val autoarg_depth : CoqAst.t Gram.Entry.e
    val autoarg_destructing : CoqAst.t Gram.Entry.e
    val autoarg_excluding : CoqAst.t Gram.Entry.e
    val autoarg_usingTDB : CoqAst.t Gram.Entry.e
    val binding_list : CoqAst.t Gram.Entry.e
    val clausearg : CoqAst.t Gram.Entry.e
    val cofixdecl : CoqAst.t list Gram.Entry.e
    val com_binding_list : CoqAst.t list Gram.Entry.e
    val comarg : CoqAst.t Gram.Entry.e
    val comarg_binding_list : CoqAst.t list Gram.Entry.e
    val comarg_list : CoqAst.t list Gram.Entry.e
    val fixdecl : CoqAst.t list Gram.Entry.e
    val identarg : CoqAst.t Gram.Entry.e
    val intropattern : CoqAst.t Gram.Entry.e
    val lcomarg : CoqAst.t Gram.Entry.e
    val lcomarg_binding_list : CoqAst.t list Gram.Entry.e
    val ne_identarg_list : CoqAst.t list Gram.Entry.e
    val ne_intropattern : CoqAst.t Gram.Entry.e
    val ne_num_list : CoqAst.t list Gram.Entry.e
    val ne_pattern_list : CoqAst.t list Gram.Entry.e
    val ne_pattern_hyp_list : CoqAst.t list Gram.Entry.e
    val ne_unfold_occ_list : CoqAst.t list Gram.Entry.e
    val numarg : CoqAst.t Gram.Entry.e
    val numarg_binding_list : CoqAst.t list Gram.Entry.e
    val one_intropattern : CoqAst.t Gram.Entry.e
    val pattern_occ : CoqAst.t Gram.Entry.e
    val pattern_occ_hyp : CoqAst.t Gram.Entry.e
    val red_flag : CoqAst.t Gram.Entry.e
    val red_tactic : CoqAst.t Gram.Entry.e
    val simple_binding : CoqAst.t Gram.Entry.e
    val simple_binding_list : CoqAst.t list Gram.Entry.e
    val simple_intropattern : CoqAst.t Gram.Entry.e
    val simple_tactic : CoqAst.t Gram.Entry.e
    val tactic : CoqAst.t Gram.Entry.e
    val tactic_com : CoqAst.t Gram.Entry.e
    val tactic_com_list : CoqAst.t Gram.Entry.e
    val tactic_com_tail : CoqAst.t Gram.Entry.e
    val tactic_eoi : CoqAst.t Gram.Entry.e
    val unfold_occ : CoqAst.t Gram.Entry.e
    val with_binding_list : CoqAst.t Gram.Entry.e
  end

module Vernac :
  sig
    val binder : CoqAst.t Gram.Entry.e
    val block : CoqAst.t list Gram.Entry.e
    val block_old_style : CoqAst.t list Gram.Entry.e
    val check_tok : CoqAst.t Gram.Entry.e
    val comarg : CoqAst.t Gram.Entry.e
    val def_tok : CoqAst.t Gram.Entry.e
    val definition_tail : CoqAst.t Gram.Entry.e
    val dep : CoqAst.t Gram.Entry.e
    val destruct_location : CoqAst.t Gram.Entry.e
    val destruct_location : CoqAst.t Gram.Entry.e
    val extracoindblock : CoqAst.t list Gram.Entry.e
    val extraindblock : CoqAst.t list Gram.Entry.e
    val field : CoqAst.t Gram.Entry.e
    val fields : CoqAst.t Gram.Entry.e
    val finite_tok : CoqAst.t Gram.Entry.e
    val hyp_tok : CoqAst.t Gram.Entry.e
    val hyps_tok : CoqAst.t Gram.Entry.e
    val idcom : CoqAst.t Gram.Entry.e
    val identarg : CoqAst.t Gram.Entry.e
    val import_tok : CoqAst.t Gram.Entry.e
    val indpar : CoqAst.t Gram.Entry.e
    val lcomarg : CoqAst.t Gram.Entry.e
    val lidcom : CoqAst.t Gram.Entry.e
    val orient:CoqAst.t Gram.Entry.e;; 
    val lvernac : CoqAst.t list Gram.Entry.e
    val meta_binding : CoqAst.t Gram.Entry.e
    val meta_binding_list : CoqAst.t list Gram.Entry.e
    val ne_binder_semi_list : CoqAst.t list Gram.Entry.e
    val ne_comarg_list : CoqAst.t list Gram.Entry.e
    val ne_identarg_comma_list : CoqAst.t list Gram.Entry.e
    val ne_identarg_list : CoqAst.t list Gram.Entry.e
    val ne_lidcom : CoqAst.t list Gram.Entry.e
    val ne_numarg_list : CoqAst.t list Gram.Entry.e
    val ne_stringarg_list : CoqAst.t list Gram.Entry.e
    val nefields : CoqAst.t list Gram.Entry.e
    val numarg : CoqAst.t Gram.Entry.e
    val numarg_list : CoqAst.t list Gram.Entry.e
    val onecorec : CoqAst.t Gram.Entry.e
    val oneind : CoqAst.t Gram.Entry.e
    val oneind_old_style : CoqAst.t Gram.Entry.e
    val onerec : CoqAst.t Gram.Entry.e
    val onescheme : CoqAst.t Gram.Entry.e
    val opt_identarg_list : CoqAst.t list Gram.Entry.e
    val option_value : CoqAst.t Gram.Entry.e
    val param_tok : CoqAst.t Gram.Entry.e
    val params_tok : CoqAst.t Gram.Entry.e
    val rec_constr : CoqAst.t Gram.Entry.e
    val record_tok : CoqAst.t Gram.Entry.e
    val sortdef : CoqAst.t Gram.Entry.e
    val specif_tok : CoqAst.t Gram.Entry.e
    val specifcorec : CoqAst.t list Gram.Entry.e
    val specifrec : CoqAst.t list Gram.Entry.e
    val specifscheme : CoqAst.t list Gram.Entry.e
    val stringarg : CoqAst.t Gram.Entry.e
    val tacarg : CoqAst.t Gram.Entry.e
    val theorem_body : CoqAst.t Gram.Entry.e
    val theorem_body_line : CoqAst.t Gram.Entry.e
    val theorem_body_line_list : CoqAst.t list Gram.Entry.e
    val thm_tok : CoqAst.t Gram.Entry.e
    val varg_ne_stringarg_list : CoqAst.t Gram.Entry.e
    val vernac : CoqAst.t Gram.Entry.e
    val vernac_eoi : CoqAst.t Gram.Entry.e
  end


module Prim :
  sig
    val ast : CoqAst.t Gram.Entry.e
    val ast_eoi : CoqAst.t Gram.Entry.e
    val astact : CoqAst.t Gram.Entry.e
    val astpat: CoqAst.t Gram.Entry.e
    val entry_type : CoqAst.t Gram.Entry.e
    val grammar_entry : CoqAst.t Gram.Entry.e
    val grammar_entry_eoi : CoqAst.t Gram.Entry.e
    val ident : CoqAst.t Gram.Entry.e
    val number : CoqAst.t Gram.Entry.e
    val path : CoqAst.t Gram.Entry.e
    val string : CoqAst.t Gram.Entry.e
    val syntax_entry : CoqAst.t Gram.Entry.e
    val syntax_entry_eoi : CoqAst.t Gram.Entry.e
    val var : CoqAst.t Gram.Entry.e
  end

(* $Id: pcoq.mli,v 1.26 1999/08/26 12:40:30 barras Exp $ *)
