(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  mlm.ml                                  *)
(****************************************************************************)
open Std;;

type ('a,'b) t = ('a * 'b) list ref;;

let create () = ref ([] : ('a * 'b) list);;
let empty mlm = mlm := [];;
let map mlm k = Listmap.map !mlm k;;
let dom mlm = Listmap.dom !mlm;;
let rng mlm = Listmap.rng !mlm;;
let in_dom mlm = Listmap.in_dom !mlm;;
let in_rng mlm = Listmap.in_rng !mlm;;
let inv mlm = Listmap.inv !mlm;;
let add mlm p = (mlm := Listmap.add !mlm p);;
let rmv mlm k = (mlm := Listmap.rmv !mlm k);;
let remap mlm k v = (mlm := Listmap.remap !mlm k v);;
let app f mlm = Listmap.app f !mlm;;
let toList mlm = !mlm;;

(* $Id: mlm.ml,v 1.6 1999/06/29 07:47:19 loiseleu Exp $ *)
