(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                nametab.ml                                *)
(****************************************************************************)

open Std;;
open Names;;
open Pp;;

let id_tab = (Mhmfs.create 17 : (identifier,section_path) Mhmfs.t);;

type frozen_t = (identifier,section_path) Mhmfs.frozen_t;;

(*** old version
let sp_of_id kind id =
  let sp = match mhs__map id_tab id with
             h::_ -> h
           | []   -> raise Not_found
  in coerce_path kind sp
;;
***)

let fw_sp_of_id id = 
    let l = Mhmfs.map id_tab id in 
let rec look_for_kind_fw = function
    sp::l -> if kind_of_path sp <> FW then look_for_kind_fw l else sp
  | []    -> raise Not_found in
look_for_kind_fw l;;

let sp_of_id kind id =
  let rec look_for_kind_fw = function
    sp::_ -> coerce_path FW sp
  | []    -> raise Not_found in
  let rec look_for_other_kind = function
    sp::l -> if kind_of_path sp <> FW then coerce_path kind sp
	                              else look_for_other_kind l
  | []    -> raise Not_found in
  let l = Mhmfs.map id_tab id in
  match kind with
    FW -> look_for_kind_fw l
  | _  -> look_for_other_kind l
;;

let push id sp =
    Mhmfs.add id_tab (id,sp)
;;

let init () = (Mhmfs.empty id_tab);;

let freeze () = Mhmfs.freeze id_tab;;

let unfreeze fidt =
    (Mhmfs.unfreeze fidt id_tab);;


Summary.declare_summary "names"
{Summary.freeze_function = freeze;
 Summary.unfreeze_function = unfreeze;
 Summary.init_function = init}
;;

let rollback f () =
    let fs = freeze()
    in try f ()
       with e -> (unfreeze fs; raise e)
;;

(* $Id: nametab.ml,v 1.11 1999/10/29 23:18:57 barras Exp $ *)
