## $Revision: 1.2 $, $Date: 1999/01/14 23:06:19 $
## The following line is edited by my ship script to contain the true
## version I am shipping from cvs. (kir)
%define VERSION 1.1.3
%define BR /tmp/clig-rpmbuild

Summary: Command Line Interpreter Generator
Name: clig
Version: %VERSION
Release: 0
Copyright: GPL
Group: Development/Tools
Source: somewhere/clig-%{VERSION}.tar.gz
URL: http://wsd.iitb.fhg.de/~kir/
Packager: Harald Kirsch (kir@iitb.fhg.de)

Requires: tcl >= 7.3

BuildRoot: %{BR}

%description 
Based on a simple specification file clig generates C-code for a function

        Cmdline *parseCmdline(int argc, char **argv)

which parses the command-line of a typical C-program and returns the
result in a structure of type Cmdline. Besides parseCmdline(), the
function

        void usage(void)

is generated and will be called by the command-line parser if the
command line contains obvious errors. One of the main reasons to use
clig is the automatic generation of a usage()-function which is
always up-to- date with respect to the options actually understood by
the program. Additionally, clig creates a manual page.

%prep
%setup

%build
%install
make install \
	prefix=$RPM_BUILD_ROOT/usr \
	MAN1DIR=$RPM_BUILD_ROOT/usr/man/man1 \
	TCLSRCDIR=$RPM_BUILD_ROOT/usr/lib/clig-%VERSION/tcl \
	CTMPLDIR=$RPM_BUILD_ROOT/usr/lib/clig-%VERSION/c \
	DOCDIR=$RPM_BUILD_ROOT/usr/doc/clig-%VERSION \
	LROOT=/this.should.not.exist
## Sadly, the %{BR} will be wrong in the main file as well as in the
## manual page
for i in %{BR}/usr/bin/clig %{BR}/usr/man/man1/clig.1 ; do 
  cp $i $i.orig
  sed -e "s,%{BR},," $i.orig >$i
  rm $i.orig
done



%post
## Fix the path to the tclsh
# Actually I would like to do the following, but is does not work due
# to rpms database locking (stupid)
# TCLSH=#\!`rpm -ql tcl|grep /tclsh$`
set -x
TCLSH=#\!`which tclsh`
p=/usr/bin
cp $p/clig $p/clig.orig
sed -e "1s,.*,$TCLSH," $p/clig.orig >$p/clig
rm $p/clig.orig

%files
%attr(-,root,root) /usr/doc/clig-%{VERSION}
%attr(-,root,root) /usr/lib/clig-%{VERSION}
%attr(-,root,root) /usr/man/man1
%attr(-,root,root) /usr/bin


