use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
@@@@@@@@K@L`@{
@@@@@@@@\@@@@k
@@@@@@@@K@L`@\
@@@@@@@@@
';

print "1..12\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(0, \&foo) };
print $@ =~ /456 NO SPLAT/ ? "" : "not ", "ok 1\n";
print @foo == 0 ? "" : "not ", "ok 2\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(0, \&foo) };
print $@ =~ /456 NO SPLAT/ ? "" : "not ", "ok 3\n";
print @foo == 0 ? "" : "not ", "ok 4\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo= ();
eval { prog_q(0, \&foo) };
print $@ =~ /456 NO SPLAT/ ? "" : "not ", "ok 5\n";
print @foo == 0 ? "" : "not ", "ok 6\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
eval { prog_p(0, \&foo) };
print $@ =~ /456 NO SPLAT/ ? "" : "not ", "ok 7\n";
print @foo == 0 ? "" : "not ", "ok 8\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo= ();
eval { prog_qp(0, \&foo) };
print $@ =~ /456 NO SPLAT/ ? "" : "not ", "ok 9\n";
print @foo == 0 ? "" : "not ", "ok 10\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo= ();
_run_db(prog_d(0, \&foo));
print $@ =~ /456 NO SPLAT/ ? "" : "not ", "ok 11\n";
print @foo == 0 ? "" : "not ", "ok 12\n";

sub foo {
    push @foo, join('', @_);
}

