
#define SCPLX
#include "atlas_misc.h"
#include "atlas_level1.h"
#include "cblas.h"

void cblas_cdotc_sub(const int N, const void *X, const int incX, 
                      const void *Y, const int incY, void * dot)
{
   const float *x = X, *y = Y;
   int incx = incX, incy = incY;

   if (incX < 0)
   {
      if (incY < 0) { incx = -incx; incy = -incY; }
      else x += -incX * ((N-1)<<1);
   }
   else if (incY < 0)
   {
      incy = -incy;
      incx = -incx;
      x += (N-1)*(incX<<1);
   }
   ATL_cdotc_sub(N, x, incx, y, incy, dot);
}
