#include<stdio.h>
#include<stdlib.h>
#include<assert.h>

main(int nargs, char **args)
{
   char pre, pres[4] = {'d', 's', 'z', 'c'};
   char ln[128], nam[128], tnam[128];
   int ipr, muladd, lat, nb, mu, nu, ku, ffetch, ifetch, nfetch, lbnreg;
   double mflop;
   FILE *fpin, *fpout;

   if (nargs != 2)
   {
      fprintf(stderr, "usage: %s <ARCH dir>\n", args[0]);
      exit(-1);
   }
   for (ipr=0; ipr < 4; ipr++)
   {
      pre = pres[ipr];
      sprintf(nam, "%s/%cMMRES", args[1], pre);
      sprintf(tnam, "%s/%cMMRES00", args[1], pre);
      fpin = fopen(nam, "r");
      fpout = fopen(tnam, "w");
      if (fpin == NULL) fprintf(stderr, "file %s not found!!\n\n", nam);
      assert(fpin && fpout);
      fgets(ln, 128, fpin);
      fputs(ln, fpout);

      fscanf(fpin, " %d  %d %d %d %d %d %d %d %d %lf\n",
             &muladd, &lat, &nb, &mu, &nu, &ku, &ffetch, &ifetch, &nfetch, 
             &mflop);
      mflop = -mflop;
      fprintf(fpout, "%6d  %3d %3d %3d %3d %3d  %5d  %5d  %5d  %7.2lf\n",
              muladd, lat, nb, mu, nu, ku, ffetch, ifetch, nfetch, mflop);

      while(fgets(ln, 128, fpin)) fputs(ln, fpout);
      fclose(fpin);
      fclose(fpout);
      remove(nam);
      if (rename(tnam, nam))
      {
         fprintf(stderr, "could not rename %s to %s!!\n", nam, tnam);
         exit(-1);
      }
   }
   for (ipr=0; ipr < 2; ipr++)
   {
      pre = pres[ipr];
      sprintf(nam, "%s/%cMULADD", args[1], pre);
      fpin = fopen(nam, "r");
      if (fpin == NULL) fprintf(stderr, "file %s not found!!\n\n", nam);
      assert(fpin);
      assert(fscanf(fpin, " %d", &muladd) == 1);
      assert(fscanf(fpin, " %d", &lat) == 1);
      assert(fscanf(fpin, " %lf", &mflop) == 1);
      assert(fscanf(fpin, " %d", &lbnreg) == 1);
      fclose(fpin);
      fpout = fopen(nam, "w");
      assert(fpout);
      fprintf(fpout, "%d\n%d\n%lf\n%d\n", muladd, lat, mflop, lbnreg);
      fclose(fpout);
   }
   exit(0);
}
