/*
 *
 *              This program is free software; you can redistribute it and/or
 *              modify it under the terms of the GNU General Public License
 *              as published by the Free Software Foundation;
 * 		Look at the file LICENSE for details
 *
*/
#ifndef     CASIO_H
#define	    CASIO_H 1
#ifdef      IN_CAS
#define	    Cext
#else
#define	    Cext  extern
#endif

#include    <stdio.h>
#include    <string.h>
#include    <errno.h>
#include    <sys/time.h>
#include    <sys/types.h>
#include    <sys/stat.h>
#include    <unistd.h>
#include    <termios.h>
#include    <fcntl.h>
#include    <signal.h>
#include    <time.h>
#include    <string.h>
#include    <stdlib.h>

#ifndef __i386__
#define swapl(x)	\
        ((x & 0xff000000U) >> 24) | \
        ((x & 0x00ff0000U) >>  8) | \
        ((x & 0x0000ff00U) <<  8) | \
        ((x & 0x000000ffU) << 24)
#define swaps(x)	\
        ((x & 0xff00) >> 8) | \
        ((x & 0x00ff) << 8)

#define ntohl(x)	swapl(x)
#define ntohs(x)	swaps(x)
#define htonl(x)	swapl(x)
#define htons(x)	swaps(x)

#define NTOHL(x)        (x) = ntohl((u_long)x)
#define NTOHS(x)        (x) = ntohs((u_short)x)
#define HTONL(x)        (x) = htonl((u_long)x)
#define HTONS(x)        (x) = htons((u_short)x)

#endif

/*
 * defines:
 */
#define READ    1
#define WRITE   0
#define WAIT    1
#define NOWAIT  0
#define TIMEOUT  60500L
#define MAXTYPE 16

/*
 * Control codes for handshake
 */
#if defined(Solaris2)
#define CR              '\r'
#define LF              '\n'
#else
#define CR              0x0d
#define LF              0x0a
#endif /* defined(Solaris2) */
#define XON             0x11
#define XOFF            0x13
#define ACK             0x23
#define NACK            0x3f
#define STOP            0x21
#define IACK		0xBD	/* Ack for Illuminator */
#define ILLH		0x8A	/* recor header for Illuminator */

#define RCLINELEN       80
#define RCFNAME         "~/.casiorc"

#define DEFAULTDB       "~/.casiodb"

#define NELEM(a)        ((int)(sizeof(a) / sizeof((a)[0])))


typedef unsigned char   byte ;
typedef unsigned short  word ;
/*
 * Structure of a record header as it is
 * exhanged with the CASIO
 */
typedef struct
{
        byte    marker ;        /* ':' marks the start of a record              */
        word    nbytes ;        /* 2 digit ASCII, # databytes                   */
        word    type ;          /* 2 digit ASCII, record type                   */
        word    low ;           /* 2 digit ASCII, low memory address            */
        word    high ;          /* 2 digit ASCII, high memory address           */
} CasioHeader ;

/*
 * Internal representation of such a header
 */
typedef struct
{
       byte    ourhead ;        /* always 0x8A */
        byte    type ;        /* type*/
        byte    nbytes ;        /* number of databytes in the record  */

} Header ;

int     bytelen,
        tflag ,
        debugmode;


/*
 * variables for getopt
 */
extern char *optarg;
extern int optind;
int ch;

char *tilde_expand_filename(const char *filename, uid_t my_uid);

FILE *dbg;
FILE *data;
FILE *casiofile;
time_t now;
struct tm *tmstruct;
char tbuff[256];
char deb[256];
char dat[256];





typedef struct
{
byte type;
byte length;
byte data[256];
byte cksum;
struct casiorec *next;
} casiorec;


typedef struct
{
byte text;
byte data[254];
} tel1;

typedef struct
{
byte day;
byte month;
byte year;
byte text;
byte data[251];
} memot;

typedef struct
{
byte day;
byte month;
byte year;
byte text;
byte priority;
byte text2;
byte data[249];
} todot;

typedef struct
{
byte day;
byte month;
byte year;
byte unused;
byte sctype;
byte text;
byte data[249];
} schd2;

typedef struct
{
byte day;
byte month;
byte year;
byte smin;
byte shour;
byte emin;
byte ehour;
byte amin;
byte ahour;
byte unused;
byte sctype;
byte text;
byte data[246];
} schd3;

typedef struct
{
byte day;
byte month;
byte year;
byte day2;
byte month2;
byte year2;
byte unused;
byte sctype;
byte text;
byte data[246];
} schd1;

typedef struct
{
byte day;
byte month;
byte year;
byte unused;
byte paytype;
byte exptype;
byte receipt;
byte amount[5];
byte text;
byte data[249];
} expense;

typedef struct
{
byte day;
byte month;
byte year;  /* always hex FC */
byte day2;
byte month2;
byte year2;
byte unused;
byte amin;
byte ahour;   /* FF if alarm has expired */
byte icon;
byte unused2;
byte text;
byte data[244];
} remind;

/*
 * global variables:
 */
byte nbytes;

byte Stopped;

byte LastRead, WriteStatus;
time_t now;
struct tm *tmstruct;
char tbuff[256];
char deb[256];
char dat[256];

CasioHeader CHeader;
static struct termios term;
static struct termios save_stdin;
static struct termios oldterm;

Header MHeader;
casiorec ourdata;

unsigned int Record;
int blkflg;
byte DataBuffer[512], WBuffer[1024];
byte Direction ;
int firstheader;



/*
byte Direction = WRITE;
byte Direction = WRITE;
byte Direction = READ;
*/


int NOCHECK = 0;
byte ourheader = 0x8A;
int displayed[17]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};


char rectypes[MAXTYPE][10]={"Tel1","Tel2","Tel3","Memo1","Memo2","Memo3","Todo1","Todo2","Todo3","Expense1","Expense2","Expense3","schedule1","schedule2","schedule3","Reminder"};

#ifdef jamal
char rectypes[MAXTYPE][10]={"Tel1","Tel2","Tel3","Memo1","Memo2","Memo3","Todo1","Todo2","Todo3","Expense1","Expense2","Expense3","schedule1","schedule2","schedule3","Reminder"};
int displayed[17]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

char tels[8][32]={"Name","Phone #1","Phone #2","Phone #3","Company","Address","Email","Note/Position"};
char expt[8][32]={"Meals","Hotel","Car","Phone","Fares","Entertainment","Tips","Misc."};
char payt[8][32]={"Cash","Check","Credit Card","other","other1","other2","other3","other4"};
#endif
/*
 * function prototypes:
 */
void UpperCase (char *s);
byte ReadByte (int secs,int usecs,int mode );
void ReadHeader (void);
void WriteByte (byte d);
void WaitForCasio (void);
int WriteLine (FILE * infile);
void WriteBuffer (casiorec *ourdata);
byte ReadHex (void);
byte atoh (char c);
void ReadLine (void);
char htoa (byte c);
void DisplayStatus (void);
int kbhit (void);
int tty_cbreak (int fd);	/* put stdin into a raw mode */
int tty_reset (int fd);		/* restore stdins's mode */
static void sig_catch (int);	/*signal catcher  */
void terminate ();		/* terminator */
int cas_cksum();   /* computes checksum for illuminator */
int (*displayers[16])();
casiorec *therecs[16];
extern int waitforchar (int fd , unsigned int secs, unsigned int usecs);

#endif
