# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: record.tcl,v 1.29 1999/09/18 09:38:54 jfontain Exp $}


class record {

    proc record {this args} switched {$args} {
        switched::complete $this
    }

    proc ~record {this} {
        variable ${this}data
        catch {unset ${this}data}
    }

    proc options {this} {
        return [list\
            [list -file {} {}]\
        ]
    }

    proc set-file {this value} {}

    proc write {this} {
        if {[string length $switched::($this,-file)]==0} {
            error {-file option undefined}
        }
        set file [open $switched::($this,-file) w+]                                                           ;# create or overwrite

        puts $file "version $global::applicationVersion"
        set seconds [clock seconds]
        puts $file "date [clock format $seconds -format %D] time [clock format $seconds -format %T]"

        set list {}
        foreach name [configuration::variables] {
            lappend list $name [set ::global::$name]
        }
        puts $file "configuration {$list}"

        # main window coordinates are not saved as it would be bad manners to force initial window placement
        set path $::widget::($global::scroll,path)                   ;# use scroll area size as icons area may or may not be present
        puts $file "width [winfo width $path] height [winfo height $path]"
        puts $file "pollTime $global::pollTime"
        puts $file "modules \{"
        foreach module $modules::(namespaces) {
            puts $file "    $module \{"
            puts $file "        arguments \{$modules::($module,arguments)\}"
            puts $file "        tables \{"
            foreach table $dataTable::(list) {
                # filter other module tables
                if {[string compare $module [namespace qualifiers [composite::cget $table -data]]]!=0} continue
                foreach {x y width height} [canvasWindowManager::getGeometry $global::windowManager $widget::($table,path)] {}
                set level [canvasWindowManager::getStackLevel $global::windowManager $widget::($table,path)]
                puts $file "            $table \{"
                puts $file "                x $x y $y width $width height $height level $level"
                foreach {switch value} [dataTable::initializationConfiguration $table] {
                    puts $file "                $switch [list $value]"
                }
                puts $file "            \}"
            }
            puts $file "        \}"
            puts $file "    \}"
        }
        puts $file \}
        puts $file "viewers \{"
        foreach viewer $viewer::(list) {
            puts $file "    $viewer \{"
            puts $file "        class [classof $viewer]"
            foreach {x y width height} [canvasWindowManager::getGeometry $global::windowManager $widget::($viewer,path)] {}
            set level [canvasWindowManager::getStackLevel $global::windowManager $widget::($viewer,path)]
            puts $file "        x $x y $y width $width height $height level $level"
            puts $file "        cells {[viewer::cells $viewer]}"
            foreach {switch value} [viewer::initializationConfiguration $viewer] {
                puts $file "        $switch [list $value]"
            }
            puts $file "    \}"
        }
        puts $file \}

        close $file
    }

    proc read {this} {
        variable ${this}data

        if {[string length $switched::($this,-file)]==0} {
            error {-file option undefined}
        }
        set file [open $switched::($this,-file)]
        array set ${this}data [::read $file]
        close $file
    }

    proc modules {this} {                            ;# indexed modules must be sorted so that they are created in the correct order
        variable ${this}data

        array set data [set ${this}data(modules)]
        return [lsort -dictionary [array names data]]
    }

    proc modulesWithArguments {this} {           ;# return list of format: module [-option [value] -option ...] module [-option ...]
        set list {}
        foreach module [modules $this] {
            moduleData $this $module data
            eval lappend list $module $data(arguments)
        }
        return $list
    }

    proc pollTime {this} {
        variable ${this}data

        return [set ${this}data(pollTime)]
    }

    proc sizes {this} {
        variable ${this}data

        return "[set ${this}data(width)] [set ${this}data(height)]"
    }

    proc viewersData {this} {
        variable ${this}data

        array set data [set ${this}data(viewers)]
        set list {}
        foreach id [lsort -integer [array names data]] {
            catch {unset viewer}
            set viewer(level) {}        ;# for backward compatibility when level was not stored in save file (versions 5.1 and down)
            array set viewer $data($id)
            set options {}                                  ;# gather viewer specific switched options in a switch / value pair list
            foreach {name value} [array get viewer -*] {
                lappend options $name $value
            }
            lappend list $viewer(class) $viewer(cells) $viewer(x) $viewer(y) $viewer(width) $viewer(height) $viewer(level) $options
        }
        return $list
    }

    proc moduleData {this module dataName} {
        variable ${this}data
        upvar $dataName data

        array set all [set ${this}data(modules)]
        array set data $all($module)
    }

    proc tableData {this module creationIndex dataName} {              ;# index is module data table creation index, starting with 0
        variable ${this}data
        upvar $dataName data

        moduleData $this $module moduleData
        array set tablesData $moduleData(tables)
        unset moduleData
        set data(level) {}              ;# for backward compatibility when level was not stored in save file (versions 5.1 and down)
        # use table identifier at the specified index in creation order sorted table indices
        array set data $tablesData([lindex [lsort -integer [array names tablesData]] $creationIndex])
    }

    proc tableWindowManagerData {this module creationIndex} {
        tableData $this $module $creationIndex data
        return [list $data(x) $data(y) $data(width) $data(height) $data(level)]
    }

    proc tableOptions {this module creationIndex} {
        tableData $this $module $creationIndex data
        set options {}                                       ;# gather table specific switched options in a switch / value pair list
        foreach {name value} [array get data -*] {
            lappend options $name $value
        }
        return $options
    }

    proc configurationData {this} {                                                             ;# return a global name / value list
        variable ${this}data

        return [set ${this}data(configuration)]
    }

}
