#include <unistd.h>
#include <stdio.h>
extern char **environ;

#include <locale.h>
#include <libintl.h>

#define LOCALEDIR "/usr/share/locale"
#define _(String) gettext(String)


/*
  For some reason, the `shell' (#!prog) of a script may not be
  another shell script. For that reason, /usr/sbin/install-fvwmgenmenu
  is this real binary, that simply exec-s a script again. Clumsy, but
  it works
*/

int main(int argc, char **argv){

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);

  if(argc < 2){
    fprintf(stderr,_("install-fvwmgenmenu should always be called with at least one argument (name of menu-method\n"));
    exit(1);
  }
  execl("/usr/sbin/install-fvwmgenmenu.sh", argv[0], argv[1], NULL);
  perror("install-fvwmgenmenu");
  return 0;
}
