#pragma interface
#ifndef SECTION_H
#define SECTION_H

#include <misc.h>
/*
	A PAIRES simply associate a keyword with a value which is a string
*/
class PAIRES: public ARRAY_OBJ{
public:
	char *keyw;
	char *arg;			// Value on the same line as the keyword
	/*~PROTOBEG~ PAIRES */
public:
	PAIRES (const char *keyword, const char *value);
	virtual ~PAIRES (void);
	/*~PROTOEND~ PAIRES */
};

class OPTION: public PAIRES{
	/*~PROTOBEG~ OPTION */
public:
	OPTION (const char *keyword, const char *value);
	virtual OPTION *clone (void)const;
	virtual void merge (const OPTION *src);
	virtual void print (FILE *fout)const;
	virtual int validate (char *msg);
	/*~PROTOEND~ OPTION */
};

class OPTIONS: public ARRAY{
	/*~PROTOBEG~ OPTIONS */
public:
	OPTION *getitem (int no)const;
	virtual void print (FILE *fout, int indent)const;
	/*~PROTOEND~ OPTIONS */
};


struct SECTION_DISPATCH{
	char *keyw;
	OPTION (*screa_section)(const char *keyw,
		const char *arg,
		FILE *fin,
		const char *fname,
		int &noline);
	SECTION_DISPATCH *subdisp;	// Which suboption are valid for
								// for this section
};

class SECTION: public OPTIONS{
protected:
	char *name;
	/*~PROTOBEG~ SECTION */
public:
	SECTION (const char *_name);
	virtual SECTION *clone (void)const;
	const char *findarg (const char *keyw);
	void print (FILE *fout, int indent)const;
	int readdisp (FILE *fin,
		 const char *fname,
		 int &noline,
		 SECTION_DISPATCH disp[]);
	int validate (char *msg);
	virtual ~SECTION (void);
	/*~PROTOEND~ SECTION */
};

class SECTIONS: public ARRAY{
	/*~PROTOBEG~ SECTIONS */
	/*~PROTOEND~ SECTIONS */
};

class COMMENTS: public SECTION{
	/*~PROTOBEG~ COMMENTS */
public:
	COMMENTS (void);
	void print (FILE *fout);
	/*~PROTOEND~ COMMENTS */
};
class XCONFIG: public SECTION{
	COMMENTS comments;	// Comments added to the Xconfig
						// while configuring
						// It tells mostly what was selected
	SECTIONS tbsect;

//	struct {
//		OPTION *section;
//		OPTION *subopt;
//		SECTION_DISPATCH *subdisp;
//	} parsing;
	/*~PROTOBEG~ XCONFIG */
public:
	XCONFIG (void);
	void addcomment (const char *keyw,
		 const char *manuf_id,
		 const char *model_id);
	const char *getcomment (const char *keyw);
	void merge (const XCONFIG *src);
	int print (FILE *fout, int indent);
	int read (const char *fname);
	void sort (void);
	int write (const char *fname);
	/*~PROTOEND~ XCONFIG */
};

#endif
