/*
	The treemenu module is a prototype. Maybe this stuff will be merged
	in the core as it may become the standard menuing strategy.
*/
#pragma implementation
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <confdb.h>
#include <translat.h>
#include <userconf.h>
#include "treemenu.h"
#include "treemenu.m"
#include "../../diajava/diajava.h"
#include "../../diajava/proto.h"
#include "../../main/main.h"

extern HELP_FILE help_mainintro;

MODULE_DEFINE_VERSION(treemenu);

PUBLIC MODULE_treemenu::MODULE_treemenu()
	: LINUXCONF_MODULE("treemenu")
{
	linuxconf_loadmsg ("treemenu",PACKAGE_REV);
}

static void treemenu_jump(const char *key)
{
	dialog_jumpto (key);
	linuxconf_main(1);
	dialog_jumpto (NULL);
}

static void ft (void *p)
{
	const char *key = (const char *)p;
	static SSTRINGS tb;
	/* #specification: treemenu / double trigger
		The treemenu module avoids trigerring the same dialog twice. It
		remembers in a table the "key" used to locate the dialog
		associated with a tree option. Searching the key in a table tells
		the treemenu module that a dialog was already triggered.

		This code should be enhanced at some point to deal with focus
		management, bringing the current dialog associated with this thread
		to the forefront.
	*/
	if (tb.lookup(key)==-1){
		SSTRING *s = new SSTRING (key);
		tb.add (s);
		treemenu_jump (key);
		tb.remove_del (s);
	}
	free (p);
}

static const char K_TREESTATE[]="state";
static const char K_STATESAVE[]="statesave";
/*
	Ananlyse the treemenu and assign each item to a level and tell
	if it is a terminal item or a sub-menu.

	Return the maximum width of the tree (in character).
*/
static int treemenu_setup (
	SSTRINGS &keys,
	SSTRINGS &titles,
	bool statopen[],
	bool terminal[],
	int level[])
{
	int n = keys.getnb();
	memset (statopen,0,n*sizeof(bool));
	memset (terminal,0,n*sizeof(bool));
	memset (level,0,n*sizeof(int));
	terminal[n-1] = true;
	for (int i=0; i<n; i++){
		int lev = 0;
		const char *pt = keys.getitem(i)->get();
		while (*pt != '\0'){
			if (*pt == '/') lev++;
			pt++;
		}
		level[i] = lev;
	}
	int maxw = 0;
	for (int i=0; i<n-1; i++){
		int lev = level[i];
		if (lev >= level[i+1]){
			terminal[i] = true;
		}
		int len = titles.getitem(i)->getlen() + (lev-1)*2;
		if (len > maxw) maxw = len;
	}
	{
		/* #Specification: treemenu / state / session
			The state of the treemenu is preserved in /var/run/treemenu.cache.
			This file is normally used to keep the structure of the treemenu
			since it takes few seconds to walk linuxconf. Given that
			the file is flushed each time a configuration change occurs (A new
			module is installed, a new version of linuxconf), it makes
			sens to store this state information there too. It will be
			preserved until a new menu is built.

			The information is stored using the real user id of the user.
			This means that multiple users are keeping their own state
			concurently.
		*/
		extern CONFIG_FILE f_treemenu;
		CONFDB db (f_treemenu);
		char uid[10];
		sprintf (uid,"%d",getuid());
		SSTRINGS states;
		if (db.getvalnum(K_STATESAVE,uid,0)){
			db.getall (K_TREESTATE,uid,states,1);
			for (int i=0; i<states.getnb(); i++){
				const char *s = states.getitem(i)->get();
				int pos = keys.lookup (s);
				if (pos != -1){
					statopen[pos] = true;
				}
			}
		}else{
			/* #Specification: treemenu / initial state
				The tree menu first appears to the user half opened.
				When the user quits, the state is saved and reused
				for the next sessions. This behavior is used to give
				a chance for the user to realise that Linuxconf has a very
				large menu tree and it is worth investigating.

				Originally, the menu was showned fully opened, but
				this was annoying. You really had to close most
				branches to find your way. So this was changed to
				show only the 3 first levels.
			*/
			for (int i=0; i<n; i++){
				if (!terminal[i] && level[i] < 3) statopen[i] = 1;
			}
			//memset (statopen,1,n*sizeof(bool));
		}
	}
	return maxw;
}

static void treemenu_savestate(
	SSTRINGS &states)
{
	extern CONFIG_FILE f_treemenu;
	CONFDB db (f_treemenu);
	char uid[10];
	sprintf (uid,"%d",getuid());
	db.replace (K_TREESTATE,uid,states);
	db.replace (K_STATESAVE,uid,1);

	perm_setbypass (1);
	db.save();
	perm_setbypass (0);
}

static void treemenu_checkupdate()
{
	int status = netconf_checkupdate(false);
	if (status == 0){
		xconf_notice (MSG_U(N_NOJOB,"Nothing to do!"));
	}
}

static void treemenu_maingui(bool dontcheck)
{
	SSTRINGS keys;
	SSTRINGS titles;
	linuxconf_gettree(keys,titles);
	char title[80],sidetitle[80];
	linuxconf_setmaintitle(title,sidetitle);
	if (diajava_context){
		/*
			We have to support both front-end (old and new)
			The old gnome-linuxconf expects a single treemenu and
			does not support context. We are using diajava_context to
			tell apart old and new front-end.

			With the new front-end, we create a more complex layout. On
			the left, we create a "leftside" form that will accept 2 tree
			organised in a notebook.

			On the right, we create an empty book and set the default context
			on it. All new dialog will be reparent in this book.

			At the bottom, we create another book. This will be used by
			logs which will register various pages there.

			Because of the old and new, you will find a few
			"if (diajava_context)" here and there.
		*/
		diagui_sendcmd (P_MainForm,"maintree \"%s\"\n",title);
		diagui_sendcmd (P_Form,"leftside\n");
		diagui_sendcmd (P_End,"\n");
		diagui_sendcmd (P_Book,"book\n");
		diagui_sendcmd (P_End,"\n");
		diagui_sendcmd (P_Newline,"\n");
		diagui_sendcmd (P_Book,"logs\n");
		diagui_sendcmd (P_End,"\n");
		diagui_sendcmd (P_Dispolast,"l 2 t 1\n");
		diagui_sendcmd (P_Newline,"\n");
		//diagui_sendcmd (P_End,"\n");	// The End is done after the tree is layout
										// to avoid showing a small window
										// first
		diagui_setdefaultctx ("maintree.book");
	}
	extern int uithread_id;
	char dianame[10];
	sprintf (dianame,"tree-%d",uithread_id);
	const char *leftside = "maintree.leftside";
	if (diajava_context) diagui_sendcmd (P_Setcontext,"%s\n",leftside);
	diagui_sendcmd (P_MainForm,"%s \"%s\"\n",dianame,title);
	if (diajava_context){
		diagui_sendcmd (P_Book,"%s\n",dianame);
	}else{
		// We still support old front-end which are expecting a single tree
		diagui_sendcmd (P_Treemenu,"%s.tree1.tree\n",dianame);
	}

	int n=keys.getnb();
	bool statopen[n],terminal[n];
	int level[n];
	treemenu_setup (keys,titles,statopen,terminal,level);
	int last_level = 1;
	int notree = 0;
	for (int i=0; i<n; i++){
		for (int j=last_level; j > level[i] && j > 1; j--){
			diagui_sendcmd (P_End,"\n");
		}
		last_level = level[i];
		char tmp[1000];
		const char *title = diagui_quote(titles.getitem(i)->get(),tmp);
		if (diajava_context && last_level == 1){
			if (i != 0){
				diagui_sendcmd (P_End,"\n");
			}
			diagui_sendcmd (P_Page,"page %s\n",title);
			diagui_sendcmd (P_Treemenu,"tree-%d\n",notree++);
		}else{
			if (terminal[i]){
				diagui_sendcmd (P_Treeelem,"\"\" %s\n",title);
			}else{
				diagui_sendcmd (P_Treesub,"%d \"\" %s\n"
					,statopen[i]
					,title);
			}
		}
	}
	for (int j=last_level; j > 1; j--){
		diagui_sendcmd (P_End,"\n");
	}
	if (diajava_context){
		diagui_sendcmd (P_End,"\n");
	}
	diagui_sendcmd (P_End,"\n");
	diagui_sendcmd (P_Newline,"\n");
	diagui_sendcmd (P_Formbutton,"buttons\n");
	diagui_sendcmd (P_Button,"B1 1 %s\n",MSG_U(B_QUIT,"Quit"));
	if (!dontcheck){
		diagui_sendcmd (P_Button,"B2 1 %s\n",MSG_U(B_ACTIVATE,"Act/Changes"));
	}
	diagui_sendcmd (P_Button,"B3 0 %s\n",MSG_U(B_HELP,"Help"));
	diagui_sendcmd (P_End,"\n");
	diagui_sendcmd (P_End,"\n");
	if (diajava_context){
		diagui_sendcmd (P_End,"\n");
		diagui_sendcmd (P_End,"\n");
	}
	while (1){
		SSTRING action,path;
		int code = diagui_sync (dianame,path,action);
		if (code == 1 || code == 99){
			SSTRINGS states;
			for (int t=0; t<notree; t++){
				char diapath[200];
				if (diajava_context){
					snprintf (diapath,sizeof(diapath)-1
						,"%s.%s.page.tree-%d"
						,dianame,dianame,t);
				}else{
					snprintf (diapath,sizeof(diapath)-1
						,"%s.tree-1.tree"
						,dianame);
				}
				for (int i=0; ; i++){
					char tmpkey[200];
					const char *key = diagui_getval(diapath,'t',i);
					if (key[0] == '\0') break;
					if (diajava_context){
						snprintf(tmpkey,sizeof(tmpkey)-1,"%d/%s"
							,t,key);
						key = tmpkey;
					}
					states.add (new SSTRING(key));
				}
			}
			treemenu_savestate(states);
			if (dontcheck || netconf_checkupdate(true)!=2) break;
		}else if (code == 2){
			treemenu_checkupdate();
		}else if (code == 3){
			diagui_showhelp(help_mainintro);
		}else{
			if (diajava_context){
				// Rebuild the absolute tree action using the tree id
				const char *pt = path.get();
				pt += strlen(pt)-1;
				action.setfromf("%s/%s",pt,action.get());
			}
			uithread (ft,strdup(action.get()));
		}
	}
}
static void treemenu_maintext(bool dontcheck)
{
	SSTRINGS keys;
	SSTRINGS titles;
	linuxconf_gettree(keys,titles);
	int nof = 0;
	int n = keys.getnb();
	bool statopen[n],terminal[n];
	int level[n];
	int maxw = treemenu_setup (keys,titles,statopen,terminal,level);
	DIALOG dia;
	int butopt = 0;
	if (!dontcheck){
		butopt = MENUBUT_USR1;
	}
	while (1){
		dia.remove_all();
		int lookup[n];
		int nbshow = 0;
		int visible_level = 1;
		for (int i=0; i<n; i++){
			int lev = level[i];
			bool term = terminal[i];
			if (lev <= visible_level){
				const char *openchar = " + ";
				if (!term){
					if (statopen[i]){
						openchar = " - ";
						visible_level = lev + 1;
					}else{
						visible_level = lev;
					}
				}
				char spaces[] = "                  ";
				int offset = (lev-1)*2;
				spaces[offset] = '\0';
				char tmp[200];
				sprintf (tmp,"%s%-*s",spaces,maxw-offset,titles.getitem(i)->get());
				dia.new_menuitem (term ? "" : openchar,tmp);
				lookup[nbshow++] = i;
			}
		}
		dia.setbutinfo (MENU_USR1,MSG_R(B_ACTIVATE),MSG_R(B_ACTIVATE));
		// Make sure the size is always the same when the tree
		// is expanded or collapsed.
		dia.setheight_hint();
		char title[80],sidetitle[80];
		linuxconf_setmaintitle(title,sidetitle);
		MENU_STATUS code = dia.editmenu (title
			,""
			,help_mainintro,nof,butopt);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			if (dontcheck || netconf_checkupdate(true)!=2) break;
		}else if (code == MENU_USR1){
			treemenu_checkupdate();
		}else if (nof >= 0 && nof < nbshow){
			int no = lookup[nof];
			if (terminal[no]){
				// Terminal option, let linuxconf pops the dialog
				const char *key = keys.getitem(no)->get();
				treemenu_jump (key);
			}else{
				statopen[no] = !statopen[no];
			}
		}			
	}
	{
		SSTRINGS states;
		for (int i=0; i<keys.getnb(); i++){
			if (statopen[i]){
				states.add (new SSTRING(keys.getitem(i)->get()));
			}
		}
		treemenu_savestate(states);
	}
}

static void treemenu_main(bool dontcheck)
{
	dialog_clear();
	if (dialog_mode == DIALOG_GUI && diajava_treemenu){
		treemenu_maingui(dontcheck);
	}else{
		treemenu_maintext(dontcheck);
	}
}


PUBLIC int MODULE_treemenu::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"treemenu")==0 && diajava_treemenu){
		treemenu_main(true);
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"treemenu usage\n"
		 "\n"
		 "treemenu --option ...\n")
		);
}

PUBLIC int MODULE_treemenu::message (
	const char *msg,
	int argc,
	const char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	static bool inside = false;
	if (!inside){
		inside = true;
		if (strcmp(msg,"mainmenu")==0 && dialog_mode != DIALOG_HTML){
			dialog_clear();
			if (diajava_treemenu){
				bool dontcheck = argc == 1 && strcmp(argv[0],"1")==0;
				treemenu_main(dontcheck);
				ret = 0;
			}
		}
		inside = false;
	}
	return ret;
}


PUBLIC int MODULE_treemenu::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"treemenu")==0){
		ret = -1;
		if (argc == 1){
			treemenu_main(false);
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_treemenu treemenu;

