/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include <netconf.h>
#include <userconf.h>
#include "redhat.h"
#include "redhat.m"
#include "../module_apis/servicectl_api.h"

MODULE_DEFINE_VERSION(redhat);

PUBLIC MODULE_redhat::MODULE_redhat()
	: LINUXCONF_MODULE ("redhat")
{
	linuxconf_loadmsg ("redhat",PACKAGE_REV);
	linuxconf_sethook (filter_fctnew);
	if (redhat_release()>=501){
		hostinfo_sethook (devinfo_load,devinfo_save);
		groutes_sethook (routes_load,routes_save);
		ipalias_sethook (devinfo_ipalias_load,devinfo_ipalias_save);
	}
	if (redhat_release()>=500){
		#if defined(__GLIBC__) && defined(HAS_PAM)
			users_sethook (reduser_del,reduser_add,reduser_change);
			passwd_sethook (pam_check_pass,pam_change_pass,pam_check_pair);
		#else
			xconf_notice (MSG_U(N_WRONGVERSION
				,"You have installed a Linuxconf version suited for\n"
				 "RedHat 4.x on a RedHat 5.x system.\n"
				 "Things will operate normally, except for the following\n"
				 "shortcomings:\n"
				 "    -PAM won't be used for user authentication and passwords\n"
				 "     updates.\n"
				 "    -Linuxconf will update the password database itself\n"
				 "     instead of relying on the useradd, userdel and usermod\n"
				 "     utilities.\n"
				 "We suggest you install the proper version. You can \"upgrade\"\n"
				 "by using the -U and --force rpm command line options."));
		#endif
	}
	module_register_api (SERVICECTL_API_KEY,SERVICECTL_API_REV
		,sysv_api_get,sysv_api_release);
}


PUBLIC int MODULE_redhat::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"redhat")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"redhat usage\n"
		 "\n"
		 "redhat --option ...\n")
		);
}

PUBLIC int MODULE_redhat::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"redhat")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_redhat redhat;

const char *vendor_getid()
{
	return "Red Hat Software";
}

const char *vendor_getdistid()
{
	int release = redhat_release();
	const char *ret = "";
	if (release == 601){
		ret = "BlueSky";
	}else if (release == 600){
		ret = "BlueSky";
	}else if (release == 502){
		ret = "Manhattan";
	}else if (release == 501){
		ret = "Manhattan";
	}else if (release == 500){
		ret = "Hurricane";
	}else if (release == 402){
		ret = "Biltmore";
	}
	return ret;
}

