#pragma implementation
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <translat.h>
#include <module.h>
#include <userconf.h>
#include <daemoni.h>
#include <netconf.h>
#include "internal.h"
#include <context.h>
#include "netadm.h"
#include "netadm.m"
#include "../paths.h"

const char subsys_netadm[]="netadm";
static NETADM_HELP_FILE help_netadm ("netadm");


MODULE_DEFINE_VERSION(netadm);

PUBLIC MODULE_NETADM::MODULE_NETADM()
	: LINUXCONF_MODULE ("netadm")
{
	linuxconf_loadmsg ("netadm",PACKAGE_REV);
}
static const char *keymenu=NULL;
static bool netadm_inmenu;
static char *publish_menu=NULL;

/*
	get the current admin tree name
*/
static const char *netadm_getcurtree ()
{
	const char *ret = NULL;
	assert (!context_isroot());
	const char *pt = strrchr(ui_context.basepath,'/');
	if (pt != NULL){
		ret = pt + 1;
	}
	assert (ret != NULL);
	return ret;
}

PUBLIC void MODULE_NETADM::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_MAIN_CONFIG){
		free (publish_menu);
		publish_menu = NULL;
		if (!netadm_inmenu){
			keymenu = MSG_U(M_NETADM,"cluster administration");
			dia.new_menuitem ("netadm","",keymenu);
		}else{
			char tmp[100];
			snprintf (tmp,sizeof(tmp)-1,MSG_U(M_PUBLISHING,"Publishing admin tree %s")
				,netadm_getcurtree());
			publish_menu = strdup(tmp);
			dia.new_menuitem ("netadm","",publish_menu);
		}
	}
}

static const char *admingroups;
static const char *admintree;
static const char *remoteadmin;

static void netadm_remadm()
{
	if (perm_rootaccess(MSG_U(P_ROOTONLY,"do remote administration"))){
		if (dialog_mode != DIALOG_GUI){
			xconf_notice (MSG_U(N_GUIMODEONLY
				,"This function is only available when running\n"
				 "the graphical user interface."));
		}else{
			remadm_ctl();
		}
	}
}

static void ft (void *p)
{
	const char *key = (const char *)p;
	if (perm_rootaccess(MSG_R(P_ROOTONLY))){
		if (key == admingroups){
			CLUSTERS clu;
			clu.edit();
		}else if (key == admintree){
			tree_edit();
		}else if (key == remoteadmin){
			netadm_remadm();
		}
	}
}

/*
	Read the index of a admin group to learn which subsystems were
	published to it.
	Return -1 if any error
*/
int netadm_readsubsyss(const char *group, SSTRINGS &subsyss)
{
	int ret = -1;
	char indexsys[PATH_MAX];
	snprintf (indexsys,PATH_MAX-1,"%s/%s/index.subsys"
		,ETC_LINUXCONF_GROUPS,group);
	FILE *fin = xconf_fopen (indexsys,"r");
	if (fin != NULL){
		char line[200];
		while (fgets(line,sizeof(line)-1,fin)!=NULL){
			strip_end (line);
			if (line[0] != '\0') subsyss.add (new SSTRING(line));
		}
		fclose (fin);
		ret = 0;
	}
	return ret;
}

int netadm_import (const char *group)
{
	int ret = -1;
	SSTRINGS subsyss;
	if (netadm_readsubsyss(group,subsyss)!=-1){
		net_introlog (NETINTRO_IMPORT);
		net_prtlog (NETLOG_SECTION,MSG_U(I_IMPORTING
			,"Importing admin group %s\n")
			,group);
		ret = configf_extract (subsyss,"netadmextract.sh",group);
	}
	return ret;
}


void netadm_edit()
{
	int choice=0;
	admingroups = MSG_U(M_ADMINGROUPS,"Admin groups definitions");
	admintree = MSG_U(M_ADMINTREE,"Admin trees management");
	remoteadmin = MSG_U(M_REMOTEADMIN,"managing remote hosts");

	static const char *menuopt[]={
		"groups:",			admingroups,
		"tree:",			admintree,
		"remote:",			remoteadmin,
		NULL
	};
	DIALOG_MENU dia;
	dia.setsidetitle (MSG_U(T_NETADMIN,"NETADMIN"));
	dia.new_menuitems (menuopt);
	while (1){
		MENU_STATUS code = dia.editmenu (
			MSG_U(T_NETADMINT,"Network administrator")
			,MSG_U(I_NETADMINT,"This package allows you to manage\n"
			 "other hosts on the network, either one by one or as groups.")
			,help_netadm
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = dia.getmenustr(choice);
			uithread (ft,(void*)key);
		}
	}
}

PUBLIC int MODULE_NETADM::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_MAIN_CONFIG){
		if (key == keymenu){
			// Avoid seeing netadm menu recursivly
			netadm_inmenu = true;
			netadm_edit();
			netadm_inmenu = false;
		}else if (key == publish_menu){
			// We must publish the current admin tree to all admin groups
			// sharing it.
			// We extract the tree name out of the current context
			SSTRING tree (netadm_getcurtree());
			LINUXCONF_CONTEXT tmp (ui_context);
			LINUXCONF_CONTEXT ctx("/");
			ui_context.set (ctx);
			CLUSTERS clus;
			clus.publish (tree.get());
			ui_context.set(tmp);
		}
	}
	return 0;
}


PUBLIC int MODULE_NETADM::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"netadm")==0){
		if (fork()==0){
			int fd = html_gethandle();
			slave_proto (fd,fd);
			_exit (0);
		}
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module netadm\n"
		 "\n"
		 "    --import admin-group\n"
		 "    --remadm [ host ]\n"
		 "    --slave\n")
		);
}

PUBLIC void MODULE_NETADM::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING(MSG_R(T_USAGE)));
}

PUBLIC int MODULE_NETADM::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"netadm")==0){
		ret = -1;
		if (argc == 2 && strcmp(argv[1],"--slave")==0){
			if (geteuid() != 0){
				fprintf (stderr,"Only root may do that\n");
			}else{
				setuid (0);
				ret = slave_proto (0,1);
			}
		}else if (netconf_mainaccess()){
			if (argc == 3 && strcmp(argv[1],"--import")==0){
				if (perm_rootaccess(MSG_U(P_IMPORT
					,"to import configuration files"))){
					ret = netadm_import(argv[2]);
				}
			}else if (argc == 2 && strcmp(argv[1],"--help")==0){
				::usage();
			}else if ((argc == 2 || argc == 3)
				&& strcmp(argv[1],"--remadm")==0){
				if (argc == 2){
					dialog_clear();
					netadm_remadm();
				}else if (perm_rootaccess(MSG_R(P_ROOTONLY))){
					remadm_call(argv[2]);
				}
			}else if (argc == 1){
				netadm_inmenu = true;
				netadm_edit();
				netadm_inmenu = false;
				ret = 0;
			}else{
				::usage();
			}
		}
	}
	return ret;
}

static MODULE_NETADM netadm;
