#ifndef DNSCONF_APIDEF_H
#define DNSCONF_APIDEF_H

class DNS;
class IP_ADDRS;
class SSTRINGS;

struct DNSCONF_API{
	int (*set) (const char *host, const char *tbip[], int nbip);
	int (*setfromip) (const char *host, const char *ip);
	int (*setcname) (const char *host,const char *nickname);
	int (*setns) (const char *domain, const char *tbns[], int nbns);
	int (*setmx) (const char *domain, const char *tbmx[], int nbmx);
	int (*setfromrange) (const char *host, const char *range);
	int (*unset) (const char *host);
	int (*geta) (const char *host, IP_ADDRS &tbip);
	int (*getns) (const char *host, SSTRINGS &tbns);
	int (*getmx) (const char *host, SSTRINGS &tbmx);
	int (*write) ();
	int (*newdomain) (const char *newdomain, const char *templ);
	int (*deldomain) (const char *domain);
	int (*delsecondary) (const char *domain);
	DNS *dns;
};

#endif
