#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <limits.h>
#include <misc.h>
#include "internal.h"
#include "../paths.h"
#include <daemoni.h>
#include <netconf.h>
#include "mailconf.h"
#include "mailconf.m"
#include <popen.h>

extern MAILCONF_HELP_FILE help_mailconf;

CONFIG_FILE f_sendmail (ETC_SENDMAIL_CF,help_mailconf
	,CONFIGF_GENERATED|CONFIGF_OPTIONNAL|CONFIGF_PROBED
	,subsys_sendmail);

CONFIG_FILE f_virtuser (ETC_MAIL_VIRTUSER,help_mailconf
	,CONFIGF_OPTIONNAL|CONFIGF_PROBED
	,subsys_mail);
CONFIG_FILE f_pophash (ETC_MAIL_POPHASH,help_mailconf
	,CONFIGF_OPTIONNAL|CONFIGF_PROBED
	,subsys_mail);

extern CONFIG_FILE f_mailtable;
extern CONFIG_FILE f_sendmail_cw;

/*
	Avoid repeating the same path over and over
*/
class MAILCONF_FILE: public CONFIG_FILE{
public:
	SSTRING refpath;	// Path of the template in /usr/lib/linuxconf
	MAILCONF_FILE(const char *fname);
};

PUBLIC MAILCONF_FILE::MAILCONF_FILE(const char *fname)
	: CONFIG_FILE (fname,help_mailconf,CONFIGF_OPTIONAL,subsys_mail)
{
	char path[PATH_MAX];
	snprintf (path,sizeof(path)-1,"%s/%s.cf",ETC_MAIL_MAILCONF,fname);
	setkey (path);
	refpath.setfromf("%s/mailconf/%s.cf",USR_LIB_LINUXCONF,fname);
}

static MAILCONF_FILE f_intro ("intro");
static MAILCONF_FILE f_copyright ("copyright");
static MAILCONF_FILE f_stdmacros ("stdmacros");
static MAILCONF_FILE f_stdoptions ("stdoptions");

static MAILCONF_FILE f_rulesets ("rulesets");
static MAILCONF_FILE f_rulesets_s0_intro ("rulesets.s0.intro");
static MAILCONF_FILE f_rulesets_s0_90 ("rulesets.s0.90");
static MAILCONF_FILE f_rulesets_s0_local ("rulesets.s0.local");
static MAILCONF_FILE f_rulesets_parse1_init ("rulesets.parse1.init");
static MAILCONF_FILE f_rulesets_parse1_virtuser ("rulesets.parse1.virtuser");
static MAILCONF_FILE f_rulesets_parse1_middle  ("rulesets.parse1.middle");
static MAILCONF_FILE f_rulesets_parse1_mailtable ("rulesets.parse1.mailtable");
static MAILCONF_FILE f_rulesets_parse1_remote ("rulesets.parse1.remote");
static MAILCONF_FILE f_rulesets_s3 ("rulesets.s3");
static MAILCONF_FILE f_rulesets_s90 ("rulesets.s90");
static MAILCONF_FILE f_rulesets_s96_dns ("rulesets.s96.dns");
static MAILCONF_FILE f_rulesets_s96_nodns ("rulesets.s96.nodns");
static MAILCONF_FILE f_rulesets_s96_fewdns ("rulesets.s96.fewdns");
static MAILCONF_FILE f_rulesets_relay ("rulesets.relay");
static MAILCONF_FILE f_rulesets_junk ("rulesets.junk");

static MAILCONF_FILE f_localmailer ("localmailer.std");
static MAILCONF_FILE f_faxmailer ("faxmailer");
static MAILCONF_FILE f_delivermailer ("localmailer.deliver");
static MAILCONF_FILE f_procmailmailer ("localmailer.procmail");
static MAILCONF_FILE f_progmailer ("progmailer");
static MAILCONF_FILE f_uucpmailer ("uucpmailer.std");
static MAILCONF_FILE f_virtmailer ("virtualmailer.std");
//static MAILCONF_FILE f_uucpnbmailer ("uucpmailer.nobatch");
static MAILCONF_FILE f_smtpmailer ("smtpmailer.std");

static MAILCONF_FILE f_localmailer_tst ("localmailer.tst");
static MAILCONF_FILE f_uucpmailer_tst ("uucpmailer.tst");
static MAILCONF_FILE f_smtpmailer_tst ("smtpmailer.tst");

const int TOKEN_VALLEN = 100;
/*
	Copy a text file into fout with token replacement
	Return 0 if ok, -1 if any error.
*/
static int copyfile (
	MAILCONF_FILE &filesrc,
	FILE *fout,
	const char *token[],
	const char repl[][TOKEN_VALLEN],
	int nbtoken)
{
	int ret = -1;
	/* #Specification: sendmail.cf / strategy
		The sendmail.cf file is built by using templates in
		/usr/lib/linuxconf/mailconf. The user has tbe ability
		to provide its own copies in /etc/mail/mailconf. Linuxconf
		will use those, overriding its own.
	*/
	const char *path = filesrc.getpath();
	if (!file_exist (path)){
		path = filesrc.refpath.get();
	}
	FILE *fin = filesrc.fopen(path,"r");
	if (fin != NULL){
		ret = 0;
		char buf[1000];
		while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
			for (int i=0; i<nbtoken; i++){
				const char *tok = token[i];
				char *pt = strstr(buf,tok);
				if (pt != NULL){
					char buf2[1000];
					int len = (int)(pt-buf);
					memcpy (buf2,buf,len);
					strcpy (buf2+len,repl[i]);
					strcat (buf2,buf+len+strlen(tok));
					strcpy (buf,buf2);
				}
			}
			fputs (buf,fout);
		}
		fclose (fin);
	}
	return ret;
}

/*
	Copy a text file into fout.
	Return 0 if ok, -1 if any error.
*/
static int copyfile (MAILCONF_FILE &filesrc, FILE *fout)
{
	return copyfile (filesrc,fout,NULL,NULL,0);
}

/*
	Produce the file /etc/sendmail.cf using the configuration.

	It mail generate the normal sendmail.cf or a temporary one
	for automated test purpose (If its argument is true).
	Not implemented yet.

	Return -1 if any error
*/
PRIVATE int MAILCONF::generate(FILE *fout)
{
	int	ret = copyfile (f_intro,fout);
	ret |= copyfile (f_copyright,fout);
	THISHOST thishost;
	const char *hname = thishost.getname1();
	fputs ("# Alias for this host\n",fout);
	if (mainserv){
		const char *dom = thishost.getdomain();
		if (dom != NULL){
			fprintf (fout,"Cw %s\n",dom);
		}else{
			xconf_error (MSG_U(E_NODOMAIN
				,"Can't compute the domain name of this server\n"
				 "It won't accept email correctly.\n"
				 "Please enter a fully qualified domain name in the\n"
				 "\"Basic host information\" screen."));
		}
	}
	fprintf (fout,"Cw localhost %s\n",hname);
	if (sendmail_cw){
		fprintf (fout,"Fw%s\n",f_sendmail_cw.getpath());
	}else{
		for (int i=0; i<alias.getnb(); i++){
			fprintf (fout,"Cw %s\n",alias.getitem(i)->get());
		}
	}
	fputs ("# Virtual email domain\n",fout);
	VDOMAINS vdomains;		// Virtual domains
	for (int i=0; i<vdomains.getnb(); i++){
		VDOMAIN *v = vdomains.getitem(i);
		fprintf (fout,"CV %s\n",v->domain.get());
		for (int o=0; o<v->others.getnb(); o++){
			SSTRING *s = v->others.getitem(o);
			fprintf (fout,"CV %s\n",s->get());
		}
	}
	/* #specification: generating sendmail.cf / other module contribution
		When generating the sendmail.cf, the mailconf module allows
		other modules to participate in the generation. We are using the
		general purpose messaging facility. Various messages are sent
		at different stage of the sendmail.cf generation.

		THe messaging api is text only using an argc,argv[] pair. We
		encode a FILE pointer as the first argument. A strategy used by
		co-manager might be better.
	*/
	const char *message_argv[2];
	message_argv[0] = (const char *)fout;
	message_argv[1] = NULL;
	module_sendmessage ("mailconf:defclass",1,message_argv);
	
	fputs ("# who I masquerade as (null for no masquerading)\n",fout);
	if (!mailas.is_empty())	fprintf (fout,"DM%s\n",mailas.get());

	/* #Specification: mailconf / sendmail.cf / smarthost
		If we specify that we are our own smarthost, this
		is causing problem with sendmail. It could be
		argue that it makes sens (independant of sendmail).

		Given also that linuxconf mail configuration
		will be shareable one day, this makes sens.

		When we detect that the smarthost is this host
		we simply ignore it (The S macro of sendmail.cf
		remain empty).

		We do the same for the mailhost (Macro H of
		sendmail.cf)
	*/
	fputs ("# Smart host\n",fout);
	if (smarthost.icmp(hname)==0){
		fputs  ("DS\n",fout);
	}else{
		fprintf  (fout,"DS%s\n",smarthost.get());
	}
	fputs ("# Use this mailer to reach the Smart host\n",fout);
	fprintf  (fout,"DN%s\n",smartmailer.get());

	fputs ("# Central host for local mail\n",fout);
	if (mailhost.icmp(hname)==0){
		fputs  ("DH\n",fout);
	}else{
		fprintf (fout,"DH%s\n",mailhost.get());
	}

	fputs ("# class L: names that should be delivered locally, even if we have a relay\n",fout);
	fprintf (fout,"CL%s\n",users.deliverlocal.get());

	fputs ("# class E: names that should be exposed as from this host, even if we masquerade\n",fout);
	fprintf (fout,"CE%s\n",users.dontmasque.get());

	fputs ("# Trust users\n",fout);
	{
		const char *pt = users.trust.get();
		while (1){
			char word[100];
			pt=str_copyword(word,pt,sizeof(word)-1);
			if (word[0] == '\0') break;
			fprintf (fout,"T%s\n",word);
		}
	}

	fputs ("# Database for special routing\n",fout);
	if (features.mailertable){
		fprintf (fout,"Kmailertable %s %s\n"
			,features.dbformat.get(),f_mailtable.getpath());
	}else{
		fputs("# Not activated\n",fout);
		if (spcs.getnb()>0){
			xconf_notice(MSG_U(E_MTABLEON
				,"The /etc/sendmail.cf will be generated without\n"
				 "special (domain) routing enabled. This system\n"
				 "has already some special routing definition(s)\n"
				 "and this sendmail.cf won't make use of them.\n"
				 "Enable \"special routing database\" in the\n"
				 "\"basic information\" dialog to fix this\n"
				 "and regenerate the sendmail.cf."));
		}
	}

	fputs ("# Restrict DNS to those domain only\n",fout);
	fputs ("CD ",fout);
	int restricted_dns = 0;
	for (int i=0; i<dnsfor.getnb(); i++){
		SSTRING *item = dnsfor.getitem(i);
		if (!item->is_empty()) restricted_dns = 1;
		fprintf (fout," %s",item->get());
	}
	fputc ('\n',fout);

	ret |= copyfile (f_stdmacros,fout);

	if (features.relayctrl){
		if (f_spam_ip_allow.exist()){
			fputs ("# file containing IP numbers of machines which can use our relay\n",fout);
			fprintf (fout,"F{LocalIP} %s\n",f_spam_ip_allow.getpath());
		}
		if (f_spam_name_allow.exist()){
			fputs ("# file containing names of machines which can use our relay\n",fout);
			fprintf (fout,"F{LocalNames} %s\n",f_spam_name_allow.getpath());
		}
		if (f_spam_relay_allow.exist()){
			fputs ("# file containing names we relay to\n",fout);
			fprintf (fout,"F{RelayTo} %s\n",f_spam_relay_allow.getpath());
		}
	}
	if (f_spam_deny.exist()){
		fputs ("# file containing known spammers by email,domain,ip\n",fout);
		fprintf (fout,"Kjunk %s -a@JUNK %s\n",features.dbformat.get()
			,f_spam_deny.getpath());
	}
	if (f_virtuser.exist()){
		fputs ("# Virtual user table (maps incoming users\n",fout);
		fprintf (fout,"Kvirtuser %s %s\n",features.dbformat.get()
			,f_virtuser.getpath());
	}
	if (f_pophash.exist()){
		fputs ("# Roaming pop users accces\n",fout);
		fprintf (fout,"Kpopauth %s %s\n",features.dbformat.get()
			,f_pophash.getpath());
	}


	fputs ("# Deliver mail only in DNS is available\n",fout);
	fputs (features.dnsneeded ? "OI\n" : "#OI\n", fout);
	fputs ("# Match full user name when receiving\n",fout);
	fputs (features.usegecos ? "OGTrue\n" : "OGFalse\n", fout);
	fputs ("# maximum message size\n",fout);
	if (features.maxmsgsize > 0){
		fprintf (fout,"O MaxMessageSize=%d\n",features.maxmsgsize);
	}else{
		fputs ("#O MaxMessageSize=1000000\n",fout);
	}
	if (features.maxrecipients > 0){
		fprintf (fout,"O MaxRecipientsPerMessage=%d\n"
			,features.maxrecipients);
	}else{
		fputs ("#O MaxRecipientsPerMessage=xxxxx\n",fout);
	}

	fputs ("# delivery mode\n",fout);
	fprintf (fout,"O DeliveryMode=%s\n"
		, features.deferdeliv ? "deferred" : "background");
	if (features.bogushelo){
		fputs ("# Give a chance to broken mail client\n",fout);
		fputs ("O AllowBogusHELO\n",fout);
	}
	{
		static const char *usertoken[]={
			"$(MAILMAIL)","$(MQUEUE)"
		};
		char userrepl[2][TOKEN_VALLEN];
		strcpy (userrepl[0],"mail:mail");
		if (strcmp(linuxconf_getdistdir(),"suse")==0){
			strcpy (userrepl[0],"bin:bin");
		}
		strcpy (userrepl[1],configf_lookuppath("/var/spool/mqueue"));
		ret |= copyfile (f_stdoptions,fout,usertoken,userrepl,2);
	}
	ret |= copyfile (f_rulesets,fout);
	if (features.mailertable) ret |= copyfile (f_rulesets_s90,fout);
	if (features.relayctrl){
		static const char *usertoken[]={
			"$(POPHASH)"
		};
		char userrepl[1][TOKEN_VALLEN];
		if (f_pophash.exist()){
			strcpy (userrepl[0],"");
		}else{
			strcpy (userrepl[0],"#");
		}
		ret |= copyfile (f_rulesets_relay,fout,usertoken,userrepl,1);
	}
	if (f_spam_deny.exist()){
		ret |= copyfile (f_rulesets_junk,fout);
	}else{
		fputs ("#Empty junk rule\nSjunk\n\nSjunkIP\n\n",fout);
	}

	ret |= copyfile (f_rulesets_s0_intro,fout);

	// Let a module define complex/exceptional routing
	module_sendmessage ("mailconf:complex_s0",1,message_argv);
	COMPLEX_ROUTES cplx;
	cplx.rule0 (fout,alias,vdomains);
	#if 0
		// Alias for virtual email domain
		for (i=0; i<vdomains.getnb(); i++){
			VDOMAIN *v = vdomains.getitem(i);
			for (int o=0; o<v->others.getnb(); o++){
				SSTRING *s = v->others.getitem(o);
				fprintf (fout,"R$*<@%s>\t$#virtual $@ %s $: $1\n"
					,s->get(),v->domain.get());
				fprintf (fout,"R$*<@%s.>\t$#virtual $@ %s $: $1\n"
					,s->get(),v->domain.get());
			}
		}
	#endif

	if (mfax.enable){
		const char *dom = thishost.getdomain();
		if (dom == NULL) dom = "";
		fprintf (fout,"R$*<@fax.%s>\t$#fax $@ $1 $: _\n",dom);
		fprintf (fout,"R$*<@fax.%s.>\t$#fax $@ $1 $: _\n",dom);
		fprintf (fout,"R$*<@$*.fax.%s>\t$#fax $@ $2 $: $1\n",dom);
		fprintf (fout,"R$*<@$*.fax.%s.>\t$#fax $@ $2 $: $1\n",dom);
	}
	
	ret |= copyfile (f_rulesets_s0_local,fout);
	ret |= copyfile (f_rulesets_parse1_init,fout);
	if (f_virtuser.exist()){
		ret |= copyfile (f_rulesets_parse1_virtuser,fout);
	}
	ret |= copyfile (f_rulesets_parse1_middle,fout);
	if (features.mailertable) ret |= copyfile (f_rulesets_parse1_mailtable,fout);
	ret |= copyfile (f_rulesets_parse1_remote,fout);

	if (features.mailertable) ret |= copyfile (f_rulesets_s0_90,fout);

	ret |= copyfile (f_rulesets_s3,fout);
	if (features.nodns){
		ret |= copyfile (f_rulesets_s96_nodns,fout);
	}else if (restricted_dns){
		ret |= copyfile (f_rulesets_s96_fewdns,fout);
	}else{
		ret |= copyfile (f_rulesets_s96_dns,fout);
	}
	if (deliver.is_empty()){
		if (file_exist ("/bin/mail.local")){
			ret |= copyfile (f_localmailer,fout);
		}else if (file_exist ("/usr/bin/deliver")){
			ret |= copyfile (f_delivermailer,fout);
		}else if (file_exist ("/usr/bin/procmail")){
			ret |= copyfile (f_procmailmailer,fout);
		}
	}else if (deliver.cmp("deliver")==0){
		ret |= copyfile (f_delivermailer,fout);
	}else if (deliver.cmp("procmail")==0){
		ret |= copyfile (f_procmailmailer,fout);
	}else if (deliver.cmp("mail.local")==0){
		ret |= copyfile (f_localmailer,fout);
	}
	{
		static const char *progtoken[]={
			"$(SHELL)"
		};
		char progrepl[1][TOKEN_VALLEN];
		strcpy (progrepl[0],"/bin/sh");
		if (features.usesmrsh){
			DAEMON_INTERNAL *dae = daemon_find ("smrsh");
			if (dae != NULL){
				const char *path = dae->getpath();
				if (file_exist (path)){
					strcpy (progrepl[0],path);
				}else if (!simul_ison()){
					xconf_error (MSG_U(E_NOSMRSH
						,"The smrsh shell is not installed\n"
						 "on this system.\n"
						 "Generating a sendmail.cf using /bin/sh"));
				}
			}
		}
		ret |= copyfile (f_progmailer,fout,progtoken,progrepl,1);
	}
	ret |= copyfile (f_virtmailer,fout);
	ret |= copyfile (f_faxmailer,fout);
	{
		static const char *uucptoken[]={
			"$(MAXSIZ)","$(UUXOPT)"
		};
		char uucprepl[2][TOKEN_VALLEN];
		uucprepl[0][0] = '\0';
		if (features.uucpmax > 0){
			sprintf (uucprepl[0],"M=%d,",features.uucpmax);
		}
		strcpy (uucprepl[1],features.uucpnobatch ? "" : "-r");
		ret |= copyfile (f_uucpmailer,fout
			,uucptoken,uucprepl,2);
	}
	ret |= copyfile (f_smtpmailer,fout);
	// Let modules record mailer
	module_sendmessage ("mailconf:defmailer",1,message_argv);

	ret |= masqs.rule1(fout);
	return ret;
}
	
static const char K_SENDMAILSUM[]="sendmailsum";

/*
	Check if the sendmail.cf currently installed was generated by me
	Use the MD5 checksum to make sure.

	sendmail_sum[] will contain the MD5 checksum of the current sendmail.cf
*/
PRIVATE bool MAILCONF::generated_byme(char sendmail_sum[])
{
	bool ret = false;
	const char *gensum = confread_getval (K_SENDMAILSUM,"");
	if (f_sendmail.md5sum(sendmail_sum)!= -1
		&& strcmp(gensum,sendmail_sum)==0){
		ret = true;
	}
	return ret;
}

PUBLIC int MAILCONF::generate_go(bool confirm)
{
	int ret = -1;
	FILE *fout = f_sendmail.fopen ("w");
	if (fout != NULL){
		ret = generate (fout);
		if (features.mailertable) spcs.build();
		fclose (fout);
		char sum[100];
		f_sendmail.md5sum(sum);
		linuxconf_setcursys(subsys_sendmail);
		confread_replace (K_SENDMAILSUM,sum);
		linuxconf_save();
		if (ret != -1 && confirm){
			xconf_notice (MSG_U(N_HASGEN,"%s has been regenerated!")
				,f_sendmail.getpath());
		}
	}
	return ret;
}

/*
	Produce the file /etc/sendmail.cf using the configuration.

	It mail generate the normal sendmail.cf or a temporary one
	for automated test purpose (If its argument is true).
	Not implemented yet.

	Return -1 if any error
*/
PUBLIC int MAILCONF::generate(bool confirm)
{
	int ret = -1;
	const char *path = f_sendmail.getpath();
	net_prtlog (NETLOG_CMD,MSG_U(I_UPDSENDMAILCF
		,"Generating %s\n"),path);
	bool go = true;
	char sum[100];
	if (!generated_byme(sum)){
		char pathold[PATH_MAX];
		sprintf (pathold,"%s.old",path);
		char bufmsg[1000];
		snprintf (bufmsg,sizeof(bufmsg)-1,MSG_U(Q_NOTBYME
			,"The file %s was not generated by Linuxconf.\n"
			 "It was either never generated by Linuxconf\n"
			 "or has been modified manually later.\n"
			 "\n"
			 "Linuxconf will overwrite it and produce a backup file\n"
			 "named %s.\n"
			 "\n"
			 "\tOk ?")
			,path,pathold);
		if (xconf_yesno (MSG_U(T_NOTBYME,"Attention"),bufmsg,help_nil)
			!=MENU_YES){
			go = false;
			net_prtlog (NETLOG_VERB,MSG_U(I_USERSAYNO
				,"Not done as confirmed by the admin\n"));
		}else{
			path = f_sendmail.getpath();
			net_prtlog (NETLOG_CMD,"mv %s %s\n",path,pathold);
			rename (path,pathold);
		}
	}
	if (go) ret = generate_go(confirm);
	return ret;
}
/*
	Return true if the sendmail.cf was generated once by Linuxconf
*/
bool mailconf_generated_once ()
{
	// No need to check that the configuration was ever edited
	// by linuxconf. We simply check that linuxconf did generate at
	// least once a sendmail.cf. This proves the user has visited
	// the sendmail configuration menu
	const char *gensum = confread_getval (K_SENDMAILSUM,"");
	return strcmp(gensum,"")!=0;
}
/*
	Generate a new sendmail.cf if needed.
	We compare the md5 checksum of sendmail.cf with the one we would get
	if the file was generated from linuxconf config. If the checksum
	differ, then sendmail.cf needs to be updated.
	Return	1 if the sendmail.cf was regenerated
				(or should be if run in simul mode)
			0 if all is fine
			-1 if any error
*/
PUBLIC int MAILCONF::generate_if(bool confirm)
{
	int ret = -1;
	if (mailconf_generated_once()){
		POPEN pop ("md5sum","");
		if (pop.isok()){
			// Imitate the way CONFIG_FILE::md5sum works by sending this line
			SSTREAM_POPEN ss (pop);
			configf_sendexist (ss,true);
			FILE *fout = pop.getfout();
			ret = generate (fout);
			pop.close();
			if (ret != -1){
				char line[100];
				if (pop.readout(line,sizeof(line)-1)==0){
					char sum_file[100],sum_conf[100];
					str_copyword (sum_conf,line,sizeof(sum_conf));
					if (generated_byme (sum_file)
						&& strcmp(sum_conf,sum_file)!=0){
						net_prtlog (NETLOG_CMD,MSG_R(I_UPDSENDMAILCF)
							,f_sendmail.getpath());
						ret = 1;
						if (!simul_ison()){
							ret = generate_go(confirm);
							if (ret != -1) ret = 1;
						}
					}
				}
			}
		}
	}
	return ret;
}

