#include <string.h>
#include <errno.h>
#include <usercomng.h>
#include "internal.h"
#include "apache.m"

static APACHE_HELP_FILE help_domain ("domain");

/*
	Make sure the document root directory  for the virtual host does exist
*/
PUBLIC  int HTTPD_DOMAIN::createroot()
{
	int ret = 0;
	const char *path = opt.documentroot.get();
	if (!context_fexist(path)){
		ret = context_mkdirp (path,"root","root",0755);
	}
	return ret;
}


PUBLIC int HTTPD_DOMAIN::edit()
{
	int ret = -1;
	DIALOG dia;
	dia.newf_str (MSG_U(F_VDOMNAME,"Virtual host name"),name);
	opt.setdia (dia,true);
	dia.newf_str (MSG_U(F_SERVERALIAS,"Server aliases"),serveralias);
	opt.feats.setdia (dia);
	ssl_setdia(dia,ssl.opts,true);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_VDOMAIN,"Virtual host setup")
			,MSG_U(I_VDOMAIN,"You are allowed to enter configurations\n"
				"for a virtual host/domain\n")
			,help_domain
			,nof,MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_DEL);
		if (code == MENU_ESCAPE || code == MENU_CANCEL){
			break;
		}else if (code == MENU_DEL){
			if (xconf_delok()){
				ret = 1;
				break;
			}
		}else{
			createroot();
			ret = 0;
			break;
		}
	}
	if (ret != 0) dia.restore();
	return ret;
}

static HTTPD_CONFIG *httpd;

PUBLIC int HTTPD_DOMAINS::write()
{
	return httpd->write();
}

PUBLIC int HTTPD_DOMAINS::edit(HTTPD_CONFIG &_httpd)
{
	httpd = &_httpd;
	int ret = -1;
	int nof = 0;

	DIALOG_RECORDS dia;
	dia.setkeyformat (HTML_KEY_INDEX);
	dia.newf_head ("",MSG_U(T_DOMAINS,"Virtual host\tServer name"));		

	dia.addwhat (MSG_U(I_NEWDOMAIN,"Select [Add] to add a new virtual domain"));
	while (1){
		int n = getnb();
		HTTPD_DOMAINS tmp;
		tmp.neverdelete();
		for (int i=0; i<n; i++) tmp.add (getitem(i));

		/* scan default unknown directive blocks for domains
		 - Marcelo */

		n = httpd->defdom.unks.getnb();

		for(int i=0;i<n;i++) {
			HTTPD_UNKNOWN *unk = httpd->defdom.unks.getitem(i);
			int m = unk->doms.getnb();
			for (int j=0; j<m; j++) tmp.add (unk->doms.getitem(j));
		}

		for (int i=0; i<tmp.getnb(); i++){
			HTTPD_DOMAIN *d = tmp.getitem(i);
			dia.set_menuitem(i,d->name.get(),d->opt.servername.get());
		}
		dia.remove_last (tmp.getnb()+1);

		MENU_STATUS code = dia.editmenu (MSG_R(T_DOMAINS)
			,MSG_U(I_DOMAINS
				,"You can define multiple independant virtual\n"
				 "domains on this server")
			,help_domain
			,nof,0);
		if (code == MENU_ESCAPE || code == MENU_QUIT){
			break;
		}else if (code == MENU_ADD){
			HTTPD_DOMAIN *d = new HTTPD_DOMAIN;
			ret = editone (d);
		}else if (nof < tmp.getnb() && nof >= 0){
			HTTPD_DOMAIN *d = tmp.getitem(nof);
			ret = d->edit();
			if (ret == 0){
				_httpd.write();
			}else if (ret == 1){
				// Note that d may not be part of a known section
				// of httpd.conf. For now, we do not delete it
				// remove_del will silently fail
				remove_del(d);
				_httpd.write();
			}
		}
	}
	return ret;
}

class VIRTUAL_COMNG: public USERACCT_COMNG{
	HTTPD_DOMOPT opt;
	/*~PROTOBEG~ VIRTUAL_COMNG */
public:
	VIRTUAL_COMNG (DICTIONARY&_dict);
	int deluser (PRIVILEGE *);
	int save (PRIVILEGE *priv);
	void setupdia (DIALOG&dia);
	int validate (DIALOG&, int &nof);
	/*~PROTOEND~ VIRTUAL_COMNG */
};

PUBLIC VIRTUAL_COMNG::VIRTUAL_COMNG(
	DICTIONARY &_dict)
	: USERACCT_COMNG (_dict)
{
}


PUBLIC void VIRTUAL_COMNG::setupdia (
	DIALOG &dia)
{
	dia.newf_title (MSG_U(T_MVIRTUAL,"web"),1
			,"",MSG_R(T_MVIRTUAL));
	opt.setdia (dia,false);
	//opt.feats.setdia (dia);
}	

PUBLIC int VIRTUAL_COMNG::save(
	PRIVILEGE *priv)
{
	int ret = 0;
	char vhost[PATH_MAX];
	snprintf (vhost,sizeof(vhost)-1,"www.%s",dict.get_str ("vdomain"));
	return ret;
}

/*
	Locate an HTTPD_DOMAIN record (virtual host) from its vhost name
*/
PUBLIC HTTPD_DOMAIN* HTTPD_CONFIG::locatevhost(const char *vhost)
{
	HTTPD_DOMAIN *ret = NULL;
	for (int i=0; i<domains.getnb(); i++){
		HTTPD_DOMAIN *d = domains.getitem(i);
		if (d->name.cmp(vhost)==0){
			ret = d;
			break;
		}
	}
	return ret;
}

PUBLIC int VIRTUAL_COMNG::validate(
	DIALOG &,
	int &nof)
{
	int ret = 0;
	char vhost[PATH_MAX];
	snprintf (vhost,sizeof(vhost)-1,"www.%s",dict.get_str ("vdomain"));
	HTTPD_CONFIG http;
	// Check if this vhost is already there
	if (http.locatevhost (vhost)!=NULL){
		xconf_error (MSG_U(E_VHOSTEXIST,"Virtual host %s\n"
			"is already configured\n"
			"for the service http"),vhost);
		ret = -1;
	}
	return ret;
}

PUBLIC int VIRTUAL_COMNG::deluser (
	PRIVILEGE *)
{
	return 0;
}

static USERACCT_COMNG *httpd_newcomng(
	const char *key,
	DICTIONARY &dict)
{
	USERACCT_COMNG *ret = NULL;
	if (strcmp(key,"virtual")==0){
		ret = new VIRTUAL_COMNG (dict);
	}
	return ret;
}


static REGISTER_USERACCT_COMNG xxx (httpd_newcomng);


int vhostedit_del (const char *host)
{
	int ret = -1;
	HTTPD_CONFIG http;
	HTTPD_DOMAIN *dom = http.locatevhost (host);
	if (dom != NULL){
		http.domains.remove_del(dom);
		ret = http.write();
	}else{
		fprintf (stderr,MSG_U(E_MISSING
			,"Apache: Virtual host %s is not configured\n")
			,host);
	}
	return ret;
}

int vhostedit_add (const char *host, int argc, const char *argv[])
{
	int ret = -1;
	HTTPD_CONFIG http;
	HTTPD_DOMAIN *dom = http.locatevhost (host);
	if (dom != NULL){
		fprintf (stderr,MSG_U(E_HOSTEXIST
			,"Apache: Virtual host %s already configured\n")
			,host);
	}else{
		dom = new HTTPD_DOMAIN;
		dom->name.setfrom (host);
		bool err = false;
		for (int i=0; i<argc; i++){
			const char *opt = argv[i];
			const char *arg = argv[i+1];
			if (strcmp(opt,"--root")==0){
				dom->opt.documentroot.setfrom (arg);
				i++;
			}else{
				fprintf (stderr,MSG_U(E_IVLDOPT,"Invalid option %s\n"),opt);
				err = true;
			}
		}
		if (dom->opt.documentroot.is_empty()){
			fprintf (stderr,MSG_U(E_NOROOT,"Apache: no root specified\n"));
		}else if (!err){
			if (dom->createroot() != -1){
				http.domains.add (dom);
				ret = http.write();
			}else{
				fprintf (stderr,MSG_U(E_CREATEROOT,"Can't create document root directory %s(%s)\n")
					,dom->opt.documentroot.get(),strerror(errno));
			}
		}
	}
	return ret;
}

