#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <netdb.h>
#include "misc.h"
/*
	Format in text the major IP number of a HOST
*/
void ipnum_ip2a(struct hostent *ent, char *buf)
{
	unsigned char *numadr = (unsigned char *)ent->h_addr_list[0];
	char *pt = buf;
	int len = ent->h_length;
	for (int i=0; i<len; i++){
		pt += sprintf (pt,i==0 ? "%d":".%d",numadr[i]);
	}
}
void ipnum_ip2a(struct hostent *ent, SSTRING &ip)
{
	char buf[16];
	ipnum_ip2a (ent,buf);
	ip.setfrom (buf);
}
/*
	Format in text an IP number
*/
void ipnum_ip2a(unsigned long ip, char *buf)
{
	sprintf (buf,"%u.%u.%u.%u"
		,(unsigned)(ip >> 24)
		,(unsigned)((ip >> 16 ) & 0xff)
		,(unsigned)((ip >> 8 ) & 0xff)
		,(unsigned)(ip & 0xff));
}
/*
	Format in text the major IP number of a NET
*/
void ipnum_ip2a(struct netent *ent, char *buf)
{
	ipnum_ip2a (ent->n_net,buf);
}
void ipnum_ip2a(struct netent *ent, SSTRING &ip)
{
	char buf[16];
	ipnum_ip2a (ent->n_net,buf);
	ip.setfrom (buf);
}

/*
	Translate an IP number (ascii) into four numbers
	Return -1 if the IP number is invalid.
*/
int ipnum_aip24 (const char *aip, int num4[4])
{
	int ret = 0;
	for (int i=0; i<4; i++){
		if (!isdigit(aip[0])){
			ret = -1;
			break;
		}else{
			int no = num4[i] = atoi(aip);
			if (no < 0 || no > 255) ret = -1;
			while (isdigit(*aip)) aip++;
			if (i < 3){
				if (*aip != '.'){
					ret = -1;
					break;
				}
				aip++;
			}
		}
	}
	if (*aip != '\0' && !isspace(*aip)) ret = -1;
	return ret;
}

/*
	Compute an IP number from a string.
*/
unsigned long ipnum_aip2l (const char *aip)
{
	unsigned long ret = 0xffffffffl;
	int n[4];
	if (ipnum_aip24(aip,n) != -1){
		ret = ((unsigned)n[0] << 24) + (n[1] << 16) + (n[2] << 8) + n[3];
	}
	return ret;
}


/*
	Check is a string is valid IP number.
	if (ishost), check if the IP is not a broadcast or a network address.
*/
bool ipnum_validip(const char *aip, bool ishost)
{
	int num4[4];
	bool ret = false;
	if (ipnum_aip24(aip,num4) != -1){
		ret = true;
		if (ishost && (num4[3] == 0 || num4[3] == 255)){
			ret = false;
		}
	}
	return ret;
}

/*
	Check is a string is valid IP number.
	if (ishost), check if the IP is not a broadcast or a network address.
*/
bool ipnum_validip(
	const char *aip,
	const char *netmask,	// aip must be a either valid
							// host or network according to this mask.
							// If netmask is not supplied, the default
							// netmask for that network is supplied
	bool ishost)
{
	if (netmask == NULL || netmask[0] == '\0'){
		int first = atoi(aip);
		if ((first & 192) != 0){
			netmask = "255.255.255.0";
		}else if ((first & 128) != 0){
			netmask = "255.255.0.0";
		}else{
			netmask = "255.0.0.0";
		}
	}
	int num4[4];
	bool ret = false;
	if (ipnum_aip24(aip,num4) != -1){
		unsigned long ip = ipnum_aip2l (aip);
		unsigned long mask = ipnum_aip2l (netmask);
		ret = true;
		unsigned long network = ip & mask;
		unsigned long bcast = network | (~mask);
		if (ishost){
			ret = ip != network && ip != bcast;
		}else{
			ret = ip == network;
		}
	}
	return ret;
}

