#!/bin/sh

# join all sgml files from SRCDIR/help.files/HELPLANG tree into one sgml file

: ${HELPLANG:=en}
: ${SRCDIR:=..}
# without full path ALLHELPFILE will be created in HELPLANG directory 
ALLHELPFILE="linuxconf-manual.sgml"

####################### end of configuration ###########################

if [ "$HELPLANG" = "en" ]; then
	HELPLANG=sources
fi

HELPPATH=${SRCDIR}/help.files/${HELPLANG}

# check if this script is running from help.files directory
# or if proper full SRCDIR name and/or HELPLANG is passed with enviroment
cd ${HELPPATH} || \
	{ echo "No such directory (${HELPPATH})" ; exit 1 }

# replace existing linuxdoc tags with needed to fit our goal
# delete <!doctype linuxdoc system>
# delete <article>
# delete </article>
# <title> -> <sect>
# delete </title>
# delete <author>* = <subtitle>* by intro.sgml
# delete </subtitle>*
# <abstract> -> <p>
# delete </abstract>
# <sect3> -> <sect4>
# <sect2> -> <sect3>
# <sect1> -> <sect2>
# <sect> -> <sect1>

newdoctags(){
perl -pe 's/<!doctype linuxdoc system>.*\n//g; \
	s/<article>.*\n//g; \
	s/<\/article>//g; \
	s/<subtitle>.*<\/subtitle>//g; \
	s/<\/title>.*//g; \
	s/<author>.*\n/<p>/g; \
	s/<\/abstract>//g; \
	s/<sect3>/<sect4>/g; \ 
	s/<sect2>/<sect3>/g; \
	s/<sect1>/<sect2>/g; \
	s/<sect>/<sect1>/g; \
	s/<title>/<sect>/g; \
	s/<abstract>/<p>/g;'
}

# not included: dialog redhat xconf
HELPDIR="main notices askrunlevel fstab misc status motd \
netconf dialout pppdialin uucp dnsconf firewall mailconf \
rarp dhcp samba wuftpd apache mrtg squid netadm \
userconf"

# sgml head
cat <<END_HEAD >${ALLHELPFILE}
<!doctype linuxdoc system>

<article>
<title>Linuxconf 1.9</title>
<author>Jacques Gelinas (jacques@solucorp.qc.ca)
<toc>
END_HEAD

# sgml body
for DIR in ${HELPDIR}; do
	if [ -d ${DIR} ]; then
		if [ -f ${DIR}/FILE_LIST ]; then
			SGMLFILES=`cat ${DIR}/FILE_LIST`
			for SGMLFILE in ${SGMLFILES}; do
			echo ${DIR}/$SGMLFILE
				if [ -f ${DIR}/${SGMLFILE}.sgml ]; then
					cat ${DIR}/${SGMLFILE}.sgml | \
						newdoctags >> ${ALLHELPFILE}
				fi
			done
		fi
	fi
done

# sgml foot
echo '</article>' >> ${ALLHELPFILE}
