#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include "dialog.h"
#include "diadef.h"

static int timeout_sec=-1;
static MENU_STATUS keyret;
static bool reactivate = false;
/*
	Specify the timeout for the next input in seconds.
	The timeout reset itself. It means that the first key pressed
	by the user will desactivated the timeout feature until
	dialog_settimeout() is called again. This function is generally
	called only once at the beginning of a program which must
	continue by itself if the user do not interact (there is no user).

	If the timeout expire before a key is depressed, retcod is returned.
	retcod is generally MENU_ESCAPE or something equivalent.
*/
void dialog_settimeout(
	int nbsec,
	MENU_STATUS retcod,
	bool rearm)		// Reactivate itself a each input
{
	timeout_sec = nbsec;
	keyret = retcod;
	reactivate = rearm;
}

static int current_timeout_sec;

/*
	Initialise the timeout before the first call to dialog_wgetch().
*/
void dialog_starttimeout()
{
	current_timeout_sec = timeout_sec;
}

int dialog_getcurtimeout()
{
	return current_timeout_sec;
}

/*
	Wait for a char and check the timeout.
	If the timeout is active, terminate every seconds to allow
	the dialog editor to take control once in a while
*/
int dialog_wgetch(WINDOW *w, MENU_STATUS &timeout_button)
{
	int ret;
	wrefresh(w);
	doupdate();
	while (1){
		int quit_now = 0;
		if (current_timeout_sec != -1){
			fd_set set;
			struct timeval out;
			FD_ZERO (&set);
			FD_SET  (0,&set);
			out.tv_sec = 1;
			current_timeout_sec--;
			out.tv_usec = 0;
			if (select(1,&set,NULL,NULL,&out) > 0){		
				ret = wgetch(w);
				current_timeout_sec = -1;
			}else{
				ret = 0;
				if (current_timeout_sec <= 0){
					// This is the final timeout
					timeout_button = keyret;
				}else{
					// This is a stop gap one second timeout
					timeout_button = MENU_INTERNAL_TIMEOUT;
				}
				quit_now = 1;
			}		
			if (!reactivate) timeout_sec = -1;
		}else{
			ret = wgetch(w);
		}
		if (!quit_now && ret == 0x1b){
			fd_set set;
			struct timeval out;
			FD_ZERO (&set);
			FD_SET  (0,&set);
			out.tv_sec = 0;
			out.tv_usec = 10000;
			if (wgetch(w) != 0x1b){
				ret = wgetch(w);
				if (ret == 0x32){
					ret = INS;
					break;
				}
			}else{
				/* It was really an escape alone */
				break;
			}
		}else{
			break;
		}
	}
	#if 0
	{
		FILE *fout = fopen ("/tmp/dbg","a");
		fprintf (fout,"ret = %x %o %d\n",ret,ret,ret);
		fclose (fout);
	}
	#endif
	return ret;
}

