/*
   fbgetty 
   Copyright (C) 1999 Yann DRONEAUD (lch@multimania.com). 

   fbgetty is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   fbgetty is distributed in the hope that it will be useful, but 
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

 */

#include "global.h"
#include "options.h"
#include "errors.h"

#include "prompt.h"

#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/mman.h>
#include <sys/ioctl.h>

#ifdef HAVE_LINUX_VT_H
#include <linux/vt.h>
#endif

void install_vt_handler(void);
RETSIGTYPE vt_handler(int sig);
void restore_default_vt_handling(void);

int vt_active;

void 
install_vt_handler(void)
{
  struct vt_mode *vt_mode;
  struct vt_stat *vt_stat;

  /* vt switching handling */
  signal(SIGUSR1, vt_handler);

  /* set up the virtual terminal */
  if ((vt_mode = (struct vt_mode *) malloc (sizeof (struct vt_mode))) == NULL)
    fatal_error("Can't allocate memory for setting up virtual terminal");

  if (ioctl(fgoptions->tty_fd, VT_GETMODE, vt_mode) == -1)
      fatal_error ("ioctl VT_GETMODE failed: %m");
  
  vt_mode->mode = VT_PROCESS; /* the switching between is handle by the program */
  vt_mode->relsig = SIGUSR1;  /* signal sent when another VT is activated */
  vt_mode->acqsig = SIGUSR1; /* signal sent when VT is activated */

  if (ioctl(fgoptions->tty_fd, VT_SETMODE, vt_mode) == -1)
    fatal_error("ioctl VT_SETMODE failed: %m");

  free (vt_mode);

  if ((vt_stat = (struct vt_stat *) malloc (sizeof (struct vt_stat))) == NULL)
    fatal_error("Can't allocate memory for state of virtual terminal");
  
  if (ioctl(STDOUT_FILENO,VT_GETSTATE,vt_stat) == -1)
    fatal_error("ioctl VT_GETSTATE failed: %m");

  if (fgoptions->tty_number != vt_stat->v_active)
    vt_active = FALSE;
  else
    vt_active = TRUE;

#ifdef FB_GETTY_DEBUG
   error("tty number: %d",fgoptions->tty_number);
   error("vt active: %d",vt_stat->v_active);   
#endif

  free(vt_stat);

}

RETSIGTYPE 
vt_handler(int sig)
{

#ifdef FB_GETTY_DEBUG
  error("signal %s received",sys_siglist[sig]); 
#endif

switch (vt_active)
  {
  case FALSE: /* fbgetty activated */

#ifdef FB_GETTY_DEBUG
    error("- refreshing screen");
#endif

    /* redraw the screen (show issue, prompt) */
    refresh_screen();
    
    vt_active = TRUE;

    return;
    break;

  case TRUE: /* Leave vt */
#ifdef FB_GETTY_DEBUG
    error("- leaving console");
#endif
    if (ioctl(fgoptions->tty_fd, VT_RELDISP, 1) == -1)
      fatal_error("ioctl VT_RELDISP: %m");

    vt_active = FALSE;

    return;
    break;

  default:
    error ("state of virtual terminal unknwon : 0x%x",vt_active);
    error ("reseting to the inactive state");
    error ("please report this to " AUTHOR_MAIL);
    vt_active = FALSE;
    break;

  }
}

/* do some cleanning */
void 
restore_default_vt_handling(void)
{
  struct vt_mode *vt_mode;

  /* set up the virtual terminal */
  if ((vt_mode = (struct vt_mode *) malloc (sizeof (struct vt_mode))) == NULL)
    fatal_error("Can't allocate memory for setting up virtual terminal");

  /* restore default vt handling */
  if (ioctl(fgoptions->tty_fd, VT_GETMODE, vt_mode) == -1)
    fatal_error("ioctl VT_GETMODE: %m");
  vt_mode->mode = VT_AUTO;
  if (ioctl(fgoptions->tty_fd, VT_SETMODE, vt_mode) == -1)
    fatal_error("ioctl VT_SETMODE: %m");

  free(vt_mode);

  /* restore signal handling */
  signal(SIGUSR1,SIG_DFL);

}






