/*
   fbgetty 
   Copyright (C) 1999 Yann DRONEAUD (lch@multimania.com). 

   fbgetty is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   fbgetty is distributed in the hope that it will be useful, but 
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

 */


#include "global.h"
#include "options.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <syslog.h>


void 
fatal_error (const char *fmt, ...)
{
        va_list va_alist;
        char *buf;

	buf = (char *) malloc (256);
        buf[0] = '\0';
  
        va_start (va_alist, fmt);
        vsprintf (buf, fmt, va_alist);
        va_end (va_alist);


        syslog (LOG_ERR, buf);
        closelog ();

	free (buf);

	if ((fgoptions->tty_device != NULL) && (fgoptions->tty_fd != -1))
	  close (fgoptions->tty_fd);

#ifdef USE_FRAME_BUFFER 
	if ((fgoptions->fb_device != NULL) && (fgoptions->fb_fd != -1))
	  close (fgoptions->fb_fd);
#endif

	closelog();

        exit (EXIT_FAILURE);
}

void 
error (const char *fmt, ...)
{
        va_list va_alist;
        char *buf;

	buf = (char *) malloc (256);
        buf[0] = '\0';
  
        va_start (va_alist, fmt);
        vsprintf (buf, fmt, va_alist);
        va_end (va_alist);

        syslog (LOG_ERR, buf);

	free(buf);

        return;
}
