
#ifndef _menu_H
#define _menu_H

#ifdef HAVE_LIBGPM
#include <gpm.h>
#endif

class MenuDrop:public Dialog
{ public:
	enum Menu
	{
		M_Functions = 0,
		M_Movement = 1,
		M_Toggles = 2,
		M_Modifiers = 3,
		M_Filters = 4,
		M_Sorting = 5
	}
	Current;

	struct menu_item_list
	{
		Menu menu;
		void (*binding) ();
		const char *caption;
	};

      private:
	static menu_item_list mi[];

	void move_toward(Menu);
	void clear_menu_items();
	void import_menu_items(Menu);
	void sorting();

      public:
	 virtual bool external_key_handler(int key);
#ifdef HAVE_LIBGPM
	virtual int gpm_handler(Gpm_Event * event);
#endif

	 MenuDrop(Menu);
};

#endif /* _menu_H */
