#ifndef _byteorder_h
#define _byteorder_h

#include <endian.h>
#include <asm/byteorder.h>

/* 2.0.x kernel headers don't define __cpu_to_le32 etc. */
#ifndef __cpu_to_le32
static inline unsigned long __swap32(unsigned long x)
{
    return  ((x << 24)           )
         | ((x <<  8) & 0xff0000)
         | ((x >>  8) & 0x00ff00)
         | ((x >> 24)           );
}

static inline unsigned short __swap16(unsigned short x)
{
    return (x << 8) | (x >> 8);
}

#if (__BYTE_ORDER == __LITTLE_ENDIAN)
#define __cpu_to_le32(x)	(x)
#define __le32_to_cpu(x)	(x)
#define __cpu_to_le16(x)	(x)
#define __le16_to_cpu(x)	(x)
#define __cpu_to_be32(x)       __swap32(x)
#define __be32_to_cpu(x)       __swap32(x)
#define __cpu_to_be16(x)       __swap16(x)
#define __be16_to_cpu(x)       __swap16(x)
#else
#define __cpu_to_be32(x)	(x)
#define __be32_to_cpu(x)	(x)
#define __cpu_to_be16(x)	(x)
#define __be16_to_cpu(x)	(x)
#define __cpu_to_le32(x)       __swap32(x)
#define __le32_to_cpu(x)       __swap32(x)
#define __cpu_to_le16(x)       __swap16(x)
#define __le16_to_cpu(x)       __swap16(x)
#endif
#endif

#endif  /* _byteorder_h */

