#! /bin/sh

. ./common.sh

curdir=`pwd`

if [ ${debug} ]; then
    loadkeys="loadkeys"
else
    loadkeys="loadkeys -q"
fi

# Print a usage message and exit if the argument count is wrong.
if [ $# != 1 ]; then
echo "Usage: "$0" console-data" 1>&2
        cat 1>&2 << EOF

        console-data: the Debian package containing the keymaps.
EOF
        exit -1
fi

package=$1

rm -f keymaps.tgz

##
## Keymap list
##   must keep utilities/dbootstrap/kbdconfig.c sync'd up with this
##
case "$arch" in
m68k)
	export keymaps="atari/atari-de.kmap.gz
	atari/atari-se.kmap.gz
	atari/atari-uk.kmap.gz
	atari/atari-us.kmap.gz
	amiga/amiga-de.kmap.gz
	amiga/amiga-es.kmap.gz
	amiga/amiga-fr.kmap.gz
	amiga/amiga-it.kmap.gz
	amiga/amiga-se.kmap.gz
	amiga/amiga-sg.kmap.gz
	amiga/amiga-us.kmap.gz
	mac/mac-us-std.kmap.gz
	mac/mac-us-ext.kmap.gz
	mac/mac-fr2-ext.kmap.gz"
	;;
powerpc)
# FIXME: Removed German Mac keymap due to loadkey failures
#	export keymaps="mac/mac-de-latin1-nodeadkeys.kmap.gz
	export keymaps="amiga/amiga-de.kmap.gz
	amiga/amiga-es.kmap.gz
	amiga/amiga-fr.kmap.gz
	amiga/amiga-it.kmap.gz
	amiga/amiga-se.kmap.gz
	amiga/amiga-sg.kmap.gz
	amiga/amiga-us.kmap.gz
	i386/azerty/be-latin1.kmap.gz
	i386/azerty/fr-latin1.kmap.gz
	i386/dvorak/dvorak.kmap.gz
	i386/qwerty/br-abnt2.kmap.gz
	i386/qwerty/br-latin1.kmap.gz
	i386/qwerty/bg.kmap.gz
	i386/qwerty/cf.kmap.gz
	i386/qwerty/cz-lat2.kmap.gz
	i386/qwerty/dk-latin1.kmap.gz
	i386/qwerty/es.kmap.gz
	i386/qwerty/fi-latin1.kmap.gz
	i386/qwerty/gr.kmap.gz
	i386/qwerty/hebrew.kmap.gz
	i386/qwerty/is-latin1.kmap.gz
	i386/qwerty/it.kmap.gz
	i386/qwerty/jp106.kmap.gz
	i386/qwerty/no-latin1.kmap.gz
	i386/qwerty/pl.kmap.gz
	i386/qwerty/pt-latin1.kmap.gz
	i386/qwerty/ru.kmap.gz
	i386/qwerty/se-latin1.kmap.gz
	i386/qwerty/sk-qwerty.kmap.gz
	i386/qwerty/trq.kmap.gz
	i386/qwerty/uk.kmap.gz
	i386/qwerty/us.kmap.gz
	i386/qwerty/us-latin1.kmap.gz
	i386/qwertz/croat.kmap.gz
	i386/qwertz/de-latin1-nodeadkeys.kmap.gz
	i386/qwertz/hu.kmap.gz
	i386/qwertz/slovene.kmap.gz
	mac/mac-fr2-ext.kmap.gz
	mac/mac-us-ext.kmap.gz
	mac/mac-us-std.kmap.gz"
	;;
sparc)
	export keymaps="sun/sunkeymap.kmap.gz
	sun/sunt4-es.kmap.gz
	sun/sunt5-de-latin1.kmap.gz
	sun/sunt5-es.kmap.gz
	sun/sunt5-fi-latin1.kmap.gz
	sun/sunt5-fr-latin1.kmap.gz
	sun/sunt5-ru.kmap.gz
	i386/azerty/be-latin1.kmap.gz
	i386/qwerty/br-abnt2.kmap.gz
	i386/qwerty/br-latin1.kmap.gz
	i386/qwerty/bg.kmap.gz
	i386/qwerty/cf.kmap.gz
	i386/qwertz/croat.kmap.gz
	i386/qwerty/cz-lat2.kmap.gz
	i386/qwertz/de-latin1-nodeadkeys.kmap.gz
	i386/qwerty/dk-latin1.kmap.gz
	i386/dvorak/dvorak.kmap.gz
	i386/qwerty/es.kmap.gz
	i386/qwerty/fi-latin1.kmap.gz
	i386/azerty/fr-latin1.kmap.gz
	i386/qwerty/gr.kmap.gz
	i386/qwerty/hebrew.kmap.gz
	i386/qwertz/hu.kmap.gz
	i386/qwerty/is-latin1.kmap.gz
	i386/qwerty/it.kmap.gz
	i386/qwerty/jp106.kmap.gz
	i386/qwerty/no-latin1.kmap.gz
	i386/qwerty/pl.kmap.gz
	i386/qwerty/pt-latin1.kmap.gz
	i386/qwerty/ru.kmap.gz
	i386/qwerty/se-latin1.kmap.gz
	i386/qwertz/slovene.kmap.gz
	i386/qwerty/sk-qwerty.kmap.gz
	i386/qwerty/trq.kmap.gz
	i386/qwerty/uk.kmap.gz
	i386/qwerty/us.kmap.gz
	i386/qwerty/us-latin1.kmap.gz"
	;;
arm)
	export keymaps="acorn/uk.kmap.gz
	i386/azerty/be-latin1.kmap.gz
	i386/qwerty/br-abnt2.kmap.gz
	i386/qwerty/bg.kmap.gz
	i386/qwerty/cf.kmap.gz
	i386/qwertz/croat.kmap.gz
	i386/qwerty/cz-lat2.kmap.gz
	i386/qwertz/de-latin1-nodeadkeys.kmap.gz
	i386/qwerty/dk-latin1.kmap.gz
	i386/dvorak/dvorak.kmap.gz
	i386/qwerty/es.kmap.gz
	i386/qwerty/fi-latin1.kmap.gz
	i386/azerty/fr-latin1.kmap.gz
	i386/qwerty/hebrew.kmap.gz
	i386/qwertz/hu.kmap.gz
	i386/qwerty/is-latin1.kmap.gz
	i386/qwerty/it.kmap.gz
	i386/qwerty/jp106.kmap.gz
	i386/qwerty/no-latin1.kmap.gz
	i386/qwerty/pl.kmap.gz
	i386/qwerty/ru.kmap.gz
	i386/qwerty/se-latin1.kmap.gz
	i386/qwertz/slovene.kmap.gz
	i386/qwerty/sk-qwerty.kmap.gz
	i386/qwerty/trq.kmap.gz
	i386/qwerty/uk.kmap.gz
	i386/qwerty/us.kmap.gz
	i386/qwerty/us-latin1.kmap.gz"
	;;
*)
	export keymaps="i386/azerty/be-latin1.kmap.gz
	i386/qwerty/br-abnt2.kmap.gz
	i386/qwerty/br-latin1.kmap.gz
	i386/qwerty/bg.kmap.gz
	i386/qwerty/cf.kmap.gz
	i386/qwertz/croat.kmap.gz
	i386/qwerty/cz-lat2.kmap.gz
	i386/qwertz/de-latin1-nodeadkeys.kmap.gz
	i386/qwerty/dk-latin1.kmap.gz
	i386/dvorak/dvorak.kmap.gz
	i386/qwerty/es.kmap.gz
	i386/qwerty/fi-latin1.kmap.gz
	i386/azerty/fr-latin1.kmap.gz
	i386/qwerty/gr.kmap.gz
	i386/qwerty/hebrew.kmap.gz
	i386/qwertz/hu.kmap.gz
	i386/qwerty/is-latin1.kmap.gz
	i386/qwerty/it.kmap.gz
	i386/qwerty/jp106.kmap.gz
	i386/qwerty/no-latin1.kmap.gz
	i386/qwerty/pl.kmap.gz
	i386/qwerty/pt-latin1.kmap.gz
	i386/qwerty/ru.kmap.gz
	i386/qwerty/se-latin1.kmap.gz
	i386/qwertz/slovene.kmap.gz
	i386/qwerty/sk-qwerty.kmap.gz
	i386/qwerty/trq.kmap.gz
	i386/qwerty/uk.kmap.gz
	i386/qwerty/us.kmap.gz
	i386/qwerty/us-latin1.kmap.gz"
	;;
esac

extractdir=${tmpdir}/boot-floppies/extract-tmp-$$
kmaptmpdir=${tmpdir}/boot-floppies/tmp-$$
scriptdir=`pwd`/utilities/writemaps

rm -rf $extractdir
make_tmpdir $extractdir

info extracting console-data to $extractdir
if [ ! -f $package ]; then
	echo "Unable to find console-data package: $package"
	return 1;
fi
dpkg-deb --extract $package $extractdir

##
## creating binary keymaps
##

rm -rf $kmaptmpdir
make_tmpdir $kmaptmpdir

info converting keymaps
(cd $extractdir
    for i in $keymaps; do
	j=`basename $i .kmap.gz`
	k=`dirname $i`
	f=`basename $i`
	mkdir -p $kmaptmpdir/$k
	(cd usr/share/keymaps/$k && zcat $f | $scriptdir/loadkeys -b \
		> $kmaptmpdir/$k/$j\.bmap)
    done
)
testexit

rm -rf $extractdir

info making keymaps tarball
# creating the tarball
( cd $kmaptmpdir && GZIP=-9 tar czf $curdir/keymaps.tgz * )
testexit

# check for empty tarball
[ -f keymaps.tgz ]
tar -tzf keymaps.tgz  | grep '.\+' >/dev/null 2>/dev/null || error "empty keymaps.tgz"

if [ ! ${debug} ]; then
    rm -rf $kmaptmpdir
fi

info keymap tarball is `ls -l keymaps.tgz`
