// pkg_info_screen.cc
//
//  Copyright 2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Gathers information about a package into one
// spot (pkg_grouppolicy_info*) and provides dedicated code to display
// it (pkg_info_screen)

#include "pkg_info_screen.h"

#include "vs_staticitem.h"
#include "pkg_subtree.h"
#include "pkg_item_with_subtree.h"
#include "dep_item.h"
#include "pkg_ver_item.h"
#include "pkg_description_treeitem.h"
#include "apt.h"

#include <apt-pkg/strutl.h>

class pkg_grouppolicy_info:public pkg_grouppolicy
{
public:
  pkg_grouppolicy_info(pkg_subtree *_root):pkg_grouppolicy(_root) {}

  void add_package(pkgCache::PkgIterator pkg);

  static void setup_package_info(pkgCache::PkgIterator pkg, pkg_item_with_generic_subtree *tree);
};

void pkg_grouppolicy_info::add_package(pkgCache::PkgIterator pkg)
{
  pkg_item_with_generic_subtree *newtree=new pkg_item_with_generic_subtree(pkg, true);

  setup_package_info(pkg, newtree);

  get_root()->add_child(newtree);
}

void pkg_grouppolicy_info::setup_package_info(pkgCache::PkgIterator pkg,
					      pkg_item_with_generic_subtree *tree)
{
  if(!pkg.VersionList().end())
    {
      pkgRecords::Parser &rec=apt_package_records->Lookup(pkg.VersionList().FileList());
      tree->add_child(new pkg_description(pkg.VersionList()));
      tree->add_child(new vs_staticitem("Priority: ",pkg.VersionList().PriorityType()));
      tree->add_child(new vs_staticitem("Section: ",pkg.Section()?pkg.Section():"Unknown"));
      tree->add_child(new vs_staticitem("Maintainer: ",rec.Maintainer()));
      tree->add_child(new vs_staticitem("Compressed size: ", SizeToStr(pkg.VersionList()->Size)));
      tree->add_child(new vs_staticitem("Uncompressed size: ", SizeToStr(pkg.VersionList()->InstalledSize)));
      if(!rec.SourcePkg().empty())
	tree->add_child(new vs_staticitem("Source Package: ",rec.SourcePkg()));
    }
  if(!pkg.VersionList().end())
    setup_package_deps(pkg.VersionList(), tree);
  pkg_vertree_generic *newtree=new pkg_vertree_generic("Versions", true);
  setup_package_versions(pkg, newtree);
  tree->add_child(newtree);
}

pkg_info_screen::pkg_info_screen(pkgCache::PkgIterator pkg):vs_tree(NULL,true)
{
  pkg_item_with_generic_subtree *tree=new pkg_item_with_generic_subtree(pkg, true);
  pkg_grouppolicy_info::setup_package_info(pkg, tree);
  set_root(tree,true);
  set_header("Information about "+string(pkg.Name()));

  prev=vscreen_show(this);
}

void pkg_info_screen::dispatch_char(chtype ch)
{
  if(global_bindings.key_matches(ch, "ExitScreen"))
    {
      vscreen_show(prev);
      vscreen_preparedelete(this);
    }
  else
    vs_tree::dispatch_char(ch);
}
