// keybindings.h, -*-c++-*-
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.

#ifndef KEYBINDINGS_H
#define KEYBINDINGS_H

#include <string>
#include <list>
#include <hash_map>
#include "../strhash.h"
#include "../curses++.h"

typedef list<chtype> keybinding;

class keybindings
{
  hash_map<string, keybinding> keymap;
public:
  void set(string tag, keybinding strokes);
  // Adds a setting for the given binding, clobbering whatever was there
  // previously.

  void set(string tag, chtype stroke)
  {
    keybinding strokes;
    strokes.push_back(stroke);
    set(tag, strokes);
  }

  bool key_matches(chtype ch, string tag);
  // Tests whether the given keystroke matches the keybinding with the given
  // name.  If no keybinding by that name exists, the match fails.
};

chtype parse_key(string keystr);
// Parses a string to a keycode.  Returns ERR if the parse fails.

extern keybindings global_bindings;
// For now, this is where the global bindings are stored (I might want to move
// it in the future, hmmm..)

#endif
