 /* 
  * UAE - The Un*x Amiga Emulator
  * 
  * Memory access functions
  *
  * Copyright 1996 Bernd Schmidt
  */

#ifdef __cplusplus
extern "C" {
#endif

#include "Switches.h"

static __inline__ uae_u32 do_get_mem_long(void* a)
{
#if WORDSWAP_MEMORY || !UNALIGNED_LONG_ACCESS
	return	(((uae_u32) *(((uae_u16*) a) + 0)) << 16) |
			(((uae_u32) *(((uae_u16*) a) + 1)));
#else
	return *(uae_u32*) a;
#endif
}


static __inline__ uae_u16 do_get_mem_word(void* a)
{
	return *(uae_u16*) a;
}


static __inline__ uae_u8 do_get_mem_byte(void* a)
{
#if WORDSWAP_MEMORY
	return *(uae_u8*) ((long) a ^ 1);
#else
	return *(uae_u8*) a;
#endif
}


static __inline__ void do_put_mem_long(void* a, uae_u32 v)
{
#if WORDSWAP_MEMORY || !UNALIGNED_LONG_ACCESS
	*(((uae_u16*) a) + 0) = (uae_u16) (v >> 16);
	*(((uae_u16*) a) + 1) = (uae_u16) (v);
#else
	*(uae_u32*) a = v;
#endif
}


static __inline__ void do_put_mem_word(void* a, uae_u16 v)
{
	*(uae_u16*) a = v;
}


static __inline__ void do_put_mem_byte(void* a, uae_u8 v)
{
#if WORDSWAP_MEMORY
	*(uae_u8*) ((long) a ^ 1) = v;
#else
	*(uae_u8*) a = v;
#endif
}


#define call_mem_get_func(func, addr)		((*func)(addr))
#define call_mem_put_func(func, addr, v)	((*func)(addr, v))

#undef NO_INLINE_MEMORY_ACCESS
#undef MD_HAVE_MEM_1_FUNCS

#ifdef __cplusplus
}
#endif

