/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#include "EmulatorCommon.h"
#include "ROMStubs.h"

#include "ATraps.h"				// ATrap
#include "Byteswapping.h"		// Canonical
#include "Logging.h"
#include "Miscellaneous.h"		// StMemoryMapper
#include "UAE_Utils.h"			// uae_memmove


// (I actually tried using function templates here, but they ended up adding
//  more code, instead of saving code by coalescing identical functions like
//  I'd hoped.)

#define PushParm(p)	PushParameter (theTrap, p)

inline void PushParameter (ATrap& theTrap, uae_u32 p)	{ theTrap.PushLong (p); }
inline void PushParameter (ATrap& theTrap, uae_s32 p)	{ theTrap.PushLong (p); }
inline void PushParameter (ATrap& theTrap, uae_u16 p)	{ theTrap.PushWord (p); }
inline void PushParameter (ATrap& theTrap, uae_s16 p)	{ theTrap.PushWord (p); }
inline void PushParameter (ATrap& theTrap, uae_u8 p)	{ theTrap.PushByte (p); }
inline void PushParameter (ATrap& theTrap, uae_s8 p)	{ theTrap.PushByte (p); }

template <typename T>
inline void PushParameter (ATrap& theTrap, const T* p)	{ theTrap.PushLong ((uae_u32) p); }

#define CallROM0(trapWord)				\
	ATrap theTrap;						\
	theTrap.Call (trapWord)

#define CallROM1(trapWord, p1)			\
	ATrap theTrap;						\
	PushParm(p1);						\
	theTrap.Call (trapWord)

#define CallROM2(trapWord, p1, p2)		\
	ATrap theTrap;						\
	PushParm(p2);						\
	PushParm(p1);						\
	theTrap.Call (trapWord)

#define CallROM3(trapWord, p1, p2, p3)	\
	ATrap theTrap;						\
	PushParm(p3);						\
	PushParm(p2);						\
	PushParm(p1);						\
	theTrap.Call (trapWord)

#define CallROM4(trapWord, p1, p2, p3, p4)	\
	ATrap theTrap;						\
	PushParm(p4);						\
	PushParm(p3);						\
	PushParm(p2);						\
	PushParm(p1);						\
	theTrap.Call (trapWord)

#define CallROM5(trapWord, p1, p2, p3, p4, p5)	\
	ATrap theTrap;						\
	PushParm(p5);						\
	PushParm(p4);						\
	PushParm(p3);						\
	PushParm(p2);						\
	PushParm(p1);						\
	theTrap.Call (trapWord)

#define CallROM6(trapWord, p1, p2, p3, p4, p5, p6)	\
	ATrap theTrap;						\
	PushParm(p6);						\
	PushParm(p5);						\
	PushParm(p4);						\
	PushParm(p3);						\
	PushParm(p2);						\
	PushParm(p1);						\
	theTrap.Call (trapWord)

#define CallROM7(trapWord, p1, p2, p3, p4, p5, p6, p7)	\
	ATrap theTrap;						\
	PushParm(p7);						\
	PushParm(p6);						\
	PushParm(p5);						\
	PushParm(p4);						\
	PushParm(p3);						\
	PushParm(p2);						\
	PushParm(p1);						\
	theTrap.Call (trapWord)

#define CallROM13(trapWord, p1, p2, p3, p4, p5, p6, p7, p8, p9, pA, pB, pC, pD)	\
	ATrap theTrap;						\
	PushParm(pD);						\
	PushParm(pC);						\
	PushParm(pB);						\
	PushParm(pA);						\
	PushParm(p9);						\
	PushParm(p8);						\
	PushParm(p7);						\
	PushParm(p6);						\
	PushParm(p5);						\
	PushParm(p4);						\
	PushParm(p3);						\
	PushParm(p2);						\
	PushParm(p1);						\
	theTrap.Call (trapWord)

#define CallIntl1(selector, p1)			\
	ATrap theTrap;						\
	PushParm(p1);						\
	theTrap.SetNewDReg (2, selector);	\
	theTrap.Call (sysTrapIntlDispatch)

#define CallIntl3(selector, p1, p2, p3)	\
	ATrap theTrap;						\
	PushParm(p3);						\
	PushParm(p2);						\
	PushParm(p1);						\
	theTrap.SetNewDReg (2, selector);	\
	theTrap.Call (sysTrapIntlDispatch)

#define CallIntl4(selector, p1, p2, p3, p4)	\
	ATrap theTrap;						\
	PushParm(p4);						\
	PushParm(p3);						\
	PushParm(p2);						\
	PushParm(p1);						\
	theTrap.SetNewDReg (2, selector);	\
	theTrap.Call (sysTrapIntlDispatch)


// ---------------------------------------------------------------------------
//		 Canonical_If_Not_Null
// ---------------------------------------------------------------------------
// Pointer parameters often need a little extra handling.  If they are not
// NULL, they generally point to either stack or heap buffers.  If they're on
// the stack, then on Windows they're in little-endian format and need to be
// converted into big-endian format.  Fortunately, we don't have to worry
// about the goofy word-swapping done for ROM and RAM memory, as the memory
// accessors that deal with data on the stack doesn't do any of that.
//
// For now, we don't actually check to see if data is on the stack or not.
// We just use this function on pointers that we _expect_ point to
// stack-resident data.  So far we haven't run into any problems with that
// approach.

template <class T>
inline void Canonical_If_Not_Null (T* p)
{
	if (p)
		Canonical (*p);
}


// ---------------------------------------------------------------------------
//		 Data Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

Err DlkDispatchRequest (DlkServerSessionPtr sessP)
{
	CallROM1 (sysTrapDlkDispatchRequest, sessP);

	return (Err) theTrap.GetD0 ();
}

Err DlkGetSyncInfo (ULongPtr succSyncDateP, ULongPtr lastSyncDateP,
			DlkSyncStateType* syncStateP, CharPtr nameBufP,
			CharPtr logBufP, ULongPtr logLenP)
{
	CallROM6 (sysTrapDlkGetSyncInfo, succSyncDateP, lastSyncDateP, syncStateP,
				nameBufP, logBufP, logLenP);

	Canonical_If_Not_Null (succSyncDateP);
	Canonical_If_Not_Null (lastSyncDateP);
//	Canonical_If_Not_Null (syncStateP);
	Canonical_If_Not_Null (logLenP);

	return (Err) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Data Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

Err DmCloseDatabase (DmOpenRef dbR)
{
	CallROM1 (sysTrapDmCloseDatabase, dbR);

	return (Err) theTrap.GetD0 ();
}

Err DmCreateDatabase (UInt cardNo, const Char * const nameP, 
					ULong creator, ULong type, Boolean resDB)
{
	CallROM5 (sysTrapDmCreateDatabase, cardNo, nameP, creator, type, resDB);

	return (Err) theTrap.GetD0 ();
}

Err DmDatabaseInfo (UInt cardNo, LocalID	dbID, const CharPtr nameP,
					UIntPtr attributesP, UIntPtr versionP, ULongPtr crDateP,
					ULongPtr modDateP, ULongPtr bckUpDateP,
					ULongPtr modNumP, LocalID* appInfoIDP,
					LocalID* sortInfoIDP, ULongPtr typeP,
					ULongPtr creatorP)
{
	// Put the name on the stack so that the emulation memory
	// access routines can sort of the byteswapping.

	char	tempName[dmDBNameLength];

	Canonical_If_Not_Null (attributesP);
	Canonical_If_Not_Null (versionP);
	Canonical_If_Not_Null (crDateP);
	Canonical_If_Not_Null (modDateP);
	Canonical_If_Not_Null (bckUpDateP);
	Canonical_If_Not_Null (modNumP);
	Canonical_If_Not_Null (appInfoIDP);
	Canonical_If_Not_Null (sortInfoIDP);
	Canonical_If_Not_Null (typeP);
	Canonical_If_Not_Null (creatorP);

	CallROM13 (sysTrapDmDatabaseInfo, cardNo, dbID, &tempName[0], attributesP,
				versionP, crDateP, modDateP, bckUpDateP, modNumP, appInfoIDP,
				sortInfoIDP, typeP, creatorP);

	Canonical_If_Not_Null (attributesP);
	Canonical_If_Not_Null (versionP);
	Canonical_If_Not_Null (crDateP);
	Canonical_If_Not_Null (modDateP);
	Canonical_If_Not_Null (bckUpDateP);
	Canonical_If_Not_Null (modNumP);
	Canonical_If_Not_Null (appInfoIDP);
	Canonical_If_Not_Null (sortInfoIDP);
	Canonical_If_Not_Null (typeP);
	Canonical_If_Not_Null (creatorP);

	if (nameP)
	{
		strcpy (nameP, tempName);
	}

	return (Err) theTrap.GetD0 ();
}

Err DmDeleteDatabase (UInt cardNo, LocalID dbID)
{
	CallROM2 (sysTrapDmDeleteDatabase, cardNo, dbID);

	return (Err) theTrap.GetD0 ();
}

LocalID DmFindDatabase (UInt cardNo, const CharPtr nameP)
{
	// Put the name on the stack so that the emulation memory
	// access routines can sort of the byteswapping.

	char	tempName[dmDBNameLength];
	strcpy (tempName, nameP);

	CallROM2 (sysTrapDmFindDatabase, cardNo, &tempName[0]);

	return (LocalID) theTrap.GetD0 ();
}

VoidHand DmGet1Resource (ULong type, Int id)
{
	CallROM2 (sysTrapDmGet1Resource, type, id);

	return (VoidHand) theTrap.GetA0 ();
}

LocalID DmGetDatabase (UInt cardNo, UInt index)
{
	CallROM2 (sysTrapDmGetDatabase, cardNo, index);

	return (LocalID) theTrap.GetD0 ();
}

Err DmGetLastErr (void)
{
	CallROM0 (sysTrapDmGetLastErr);

	return (Err) theTrap.GetD0 ();
}

Err	DmGetNextDatabaseByTypeCreator (Boolean newSearch, DmSearchStatePtr stateInfoP,
			 		ULong type, ULong creator, Boolean onlyLatestVers, 
			 		UIntPtr cardNoP, LocalID* dbIDP)
{
	Canonical_If_Not_Null (cardNoP);
	Canonical_If_Not_Null (dbIDP);

	CallROM7 (sysTrapDmGetNextDatabaseByTypeCreator, newSearch, stateInfoP,
				type, creator, onlyLatestVers, cardNoP, dbIDP);

	Canonical_If_Not_Null (cardNoP);
	Canonical_If_Not_Null (dbIDP);

	return (Err) theTrap.GetD0 ();
}

VoidHand DmGetResource (ULong type, Int id)
{
	CallROM2 (sysTrapDmGetResource, type, id);

	return (VoidHand) theTrap.GetA0 ();
}

VoidHand DmGetResourceIndex (DmOpenRef dbP, Int index)
{
	CallROM2 (sysTrapDmGetResourceIndex, dbP, index);

	return (VoidHand) theTrap.GetA0 ();
}

VoidHand DmNewHandle (DmOpenRef dbR, ULong size)
{
	CallROM2 (sysTrapDmNewHandle, dbR, size);

	return (VoidHand) theTrap.GetA0 ();
}

VoidHand DmNewRecord (DmOpenRef dbR, UIntPtr atP, ULong size)
{
	Canonical_If_Not_Null (atP);

	CallROM3 (sysTrapDmNewRecord, dbR, atP, size);

	Canonical_If_Not_Null (atP);

	return (VoidHand) theTrap.GetA0 ();
}

UInt DmNumDatabases (UInt cardNo)
{
	CallROM1 (sysTrapDmNumDatabases, cardNo);

	return (UInt) theTrap.GetD0 ();
}

VoidHand DmNewResource (DmOpenRef dbR, ULong resType, Int resID, ULong size)
{
	CallROM4 (sysTrapDmNewResource, dbR, resType, resID, size);

	return (VoidHand) theTrap.GetA0 ();
}

UInt DmNumRecords (DmOpenRef dbP)
{
	CallROM1 (sysTrapDmNumRecords, dbP);

	return (UInt) theTrap.GetD0 ();
}

DmOpenRef DmOpenDatabase (UInt cardNo, LocalID dbID, UInt mode)
{
	CallROM3 (sysTrapDmOpenDatabase, cardNo, dbID, mode);

	return (DmOpenRef) theTrap.GetA0 ();
}

Err DmOpenDatabaseInfo (DmOpenRef dbP, LocalID* dbIDP, 
					UIntPtr openCountP, UIntPtr modeP, UIntPtr cardNoP,
					BooleanPtr resDBP)
{
	Canonical_If_Not_Null (dbIDP);
	Canonical_If_Not_Null (openCountP);
	Canonical_If_Not_Null (modeP);
	Canonical_If_Not_Null (cardNoP);
	Canonical_If_Not_Null (resDBP);

	CallROM6 (sysTrapDmOpenDatabaseInfo, dbP, dbIDP, openCountP, modeP, cardNoP, resDBP);

	Canonical_If_Not_Null (dbIDP);
	Canonical_If_Not_Null (openCountP);
	Canonical_If_Not_Null (modeP);
	Canonical_If_Not_Null (cardNoP);
	Canonical_If_Not_Null (resDBP);

	return (Err) theTrap.GetD0 ();
}

Err DmRecordInfo (DmOpenRef dbP, UInt index,
					UIntPtr attrP, ULongPtr uniqueIDP, LocalID* chunkIDP)
{
	Canonical_If_Not_Null (attrP);
	Canonical_If_Not_Null (uniqueIDP);
	Canonical_If_Not_Null (chunkIDP);

	CallROM5 (sysTrapDmRecordInfo, dbP, index, attrP, uniqueIDP, chunkIDP);

	Canonical_If_Not_Null (attrP);
	Canonical_If_Not_Null (uniqueIDP);
	Canonical_If_Not_Null (chunkIDP);

	return (Err) theTrap.GetD0 ();
}

Err DmReleaseRecord (DmOpenRef dbR, UInt index, Boolean dirty)
{
	CallROM3 (sysTrapDmReleaseRecord, dbR, index, dirty);

	return (Err) theTrap.GetD0 ();
}

Err DmReleaseResource (VoidHand resourceH)
{
	CallROM1 (sysTrapDmReleaseResource, resourceH);

	return (Err) theTrap.GetD0 ();
}

Err DmResourceInfo (DmOpenRef dbP, Int index,
					ULongPtr resTypeP, IntPtr resIDP,  
					LocalID* chunkLocalIDP)
{
	Canonical_If_Not_Null (resTypeP);
	Canonical_If_Not_Null (resIDP);
	Canonical_If_Not_Null (chunkLocalIDP);

	CallROM5 (sysTrapDmResourceInfo, dbP, index, resTypeP, resIDP, chunkLocalIDP);

	Canonical_If_Not_Null (resTypeP);
	Canonical_If_Not_Null (resIDP);
	Canonical_If_Not_Null (chunkLocalIDP);

	return (Err) theTrap.GetD0 ();
}

VoidHand DmQueryRecord (DmOpenRef dbP, UInt index)
{
	CallROM2 (sysTrapDmQueryRecord, dbP, index);

	return (VoidHand) theTrap.GetA0 ();
}

Err DmSetDatabaseInfo (UInt cardNo, LocalID dbID, const CharPtr nameP,
					UIntPtr attributesP, UIntPtr versionP, ULongPtr crDateP,
					ULongPtr modDateP, ULongPtr bckUpDateP,
					ULongPtr modNumP, LocalID* appInfoIDP,
					LocalID* sortInfoIDP, ULongPtr typeP,
					ULongPtr creatorP)
{
	// Put the name on the stack so that the emulation memory
	// access routines can sort of the byteswapping.

	CharPtr	nameP2 = nameP;
	char	tempName[dmDBNameLength];
	if (nameP)
	{
		strcpy (tempName, nameP);
		nameP2 = tempName;
	}

	Canonical_If_Not_Null (attributesP);
	Canonical_If_Not_Null (versionP);
	Canonical_If_Not_Null (crDateP);
	Canonical_If_Not_Null (modDateP);
	Canonical_If_Not_Null (bckUpDateP);
	Canonical_If_Not_Null (modNumP);
	Canonical_If_Not_Null (appInfoIDP);
	Canonical_If_Not_Null (sortInfoIDP);
	Canonical_If_Not_Null (typeP);
	Canonical_If_Not_Null (creatorP);

	CallROM13 (sysTrapDmSetDatabaseInfo, cardNo, dbID, nameP2, attributesP, versionP,
		crDateP, modDateP, bckUpDateP, modNumP, appInfoIDP, sortInfoIDP, typeP, creatorP);

	Canonical_If_Not_Null (attributesP);
	Canonical_If_Not_Null (versionP);
	Canonical_If_Not_Null (crDateP);
	Canonical_If_Not_Null (modDateP);
	Canonical_If_Not_Null (bckUpDateP);
	Canonical_If_Not_Null (modNumP);
	Canonical_If_Not_Null (appInfoIDP);
	Canonical_If_Not_Null (sortInfoIDP);
	Canonical_If_Not_Null (typeP);
	Canonical_If_Not_Null (creatorP);

	return (Err) theTrap.GetD0 ();
}

Err DmSetRecordInfo (DmOpenRef dbR, UInt index, UIntPtr attrP, ULongPtr uniqueIDP)
{
	Canonical_If_Not_Null (attrP);
	Canonical_If_Not_Null (uniqueIDP);

	CallROM4 (sysTrapDmSetRecordInfo, dbR, index, attrP, uniqueIDP);

	Canonical_If_Not_Null (attrP);
	Canonical_If_Not_Null (uniqueIDP);

	return (Err) theTrap.GetD0 ();
}

Err DmWrite (VoidPtr recordP, ULong offset, const void * const srcP, ULong bytes)
{
	CallROM4 (sysTrapDmWrite, recordP, offset, srcP, bytes);

	return (Err) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Event Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

Err EvtEnqueueKey (UInt ascii, UInt keycode, UInt modifiers)
{
	CallROM3 (sysTrapEvtEnqueueKey, ascii, keycode, modifiers);

	return (Err) theTrap.GetD0 ();
}

Err EvtEnqueuePenPoint (PointType* ptP)
{
	// Make a copy of the point, as we may be munging it.

	PointType	pt = *ptP;

	// Enqueue the new pen position. We must "reverse" correct it because the
	// Event Manager assumes that all points enqueued are raw digitizer points.

	if (pt.x != -1 || pt.y != -1)
	{
		(void) PenScreenToRaw(&pt);
	}

	// Byteswap it so that the ROM routines get it in the right format.
	// Byteswap it _after_ PenScreenToRaw, as PenScreenToRaw will do its
	// own byteswapping.

	Canonical (pt);

	CallROM1 (sysTrapEvtEnqueuePenPoint, &pt);

	return (Err) theTrap.GetD0 ();
}

PenBtnInfoPtr	EvtGetPenBtnList(UIntPtr numButtons)
{
	Canonical_If_Not_Null (numButtons);

	CallROM1 (sysTrapEvtGetPenBtnList, numButtons);

	Canonical_If_Not_Null (numButtons);

	// This one's tricky; it's returning a pointer to ROM data.  There are
	// no functions to access the fields in the struct, so the caller needs
	// to access those fields directly.  However, not only is the address
	// returned in "emulated space" and not native space, but there are
	// word- and byte-swapping issues involved.  To help out the caller,
	// we'll address those issues here, returning a pointer to a "pre-
	// digested" copy of the struct.

	static PenBtnInfoPtr	buttonListP;

	if (!buttonListP)
	{
		long	buttonListSize = *numButtons * sizeof (PenBtnInfoType);

		buttonListP = (PenBtnInfoPtr) malloc (buttonListSize);
		// !!! Should check for NULL here, but how to handle it?

		// Copy the data, sorting out address and wordswapping issues

		uae_memmove ((void*) buttonListP, theTrap.GetA0 (), buttonListSize);

		// Now sort out the byte-swapping issues.

		for (UInt ii = 0; ii < *numButtons; ++ii)
			Canonical (buttonListP[ii]);
	}

	return buttonListP;
}

Err EvtResetAutoOffTimer (void)
{
	CallROM0 (sysTrapEvtResetAutoOffTimer);

	return (Err) theTrap.GetD0 ();
}

Err EvtWakeup (void)
{
	CallROM0 (sysTrapEvtWakeup);

	return (Err) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Feature Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

Err FtrGet (DWord creator, UInt featureNum, DWordPtr valueP)
{
	Canonical_If_Not_Null (valueP);

	CallROM3 (sysTrapFtrGet, creator, featureNum, valueP);

	Canonical_If_Not_Null (valueP);

	return (Err) theTrap.GetD0 ();
}

Err FtrSet (DWord creator, UInt featureNum, DWord newValue)
{
	CallROM3 (sysTrapFtrSet, creator, featureNum, newValue);

	return (Err) theTrap.GetD0 ();
}


Err	FtrUnregister (UInt32 creator, UInt16 featureNum)
{
	CallROM2 (sysTrapFtrUnregister, creator, featureNum);

	return (Err) theTrap.GetD0 ();
}


// ---------------------------------------------------------------------------
//		 Field Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

void FldGetAttributes (const FieldPtr fld, const FieldAttrPtr attrP)
{
	Canonical_If_Not_Null (attrP);

	CallROM2 (sysTrapFldGetAttributes, fld, attrP);

	Canonical_If_Not_Null (attrP);

//	LogAppendMsg ("attr == 0x%04X", (int) *(short*) attrP);
}

Word FldGetMaxChars (const FieldPtr fld)
{
	CallROM1 (sysTrapFldGetMaxChars, fld);

	return (Word) theTrap.GetD0 ();
}

Word FldGetTextLength (const FieldPtr fld)
{
	CallROM1 (sysTrapFldGetTextLength, fld);

	return (Word) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Font Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

SWord FntLineHeight (void)
{
	CallROM0 (sysTrapFntLineHeight);

	return (SWord) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Form Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

FormPtr FrmGetActiveForm (void)
{
	CallROM0 (sysTrapFrmGetActiveForm);

	return (FormPtr) theTrap.GetA0 ();
}

Word FrmGetFocus (const FormPtr frm)
{
	CallROM1 (sysTrapFrmGetFocus, frm);

	return (Word) theTrap.GetD0 ();
}

Word FrmGetFormId (const FormPtr frm)
{
	CallROM1 (sysTrapFrmGetFormId, frm);

	return (Word) theTrap.GetD0 ();
}

Word FrmGetNumberOfObjects (const FormPtr frm)
{
	CallROM1 (sysTrapFrmGetNumberOfObjects, frm);

	return (Word) theTrap.GetD0 ();
}

void FrmGetObjectBounds (const FormPtr frm, const Word pObjIndex, const RectanglePtr r)
{
	Canonical_If_Not_Null (r);

	CallROM3 (sysTrapFrmGetObjectBounds, frm, pObjIndex, r);

	Canonical_If_Not_Null (r);
}

Word FrmGetObjectId (const FormPtr frm, const Word objIndex)
{
	CallROM2 (sysTrapFrmGetObjectId, frm, objIndex);

	return (Word) theTrap.GetD0 ();
}

VoidPtr FrmGetObjectPtr (const FormPtr frm, const Word objIndex)
{
	CallROM2 (sysTrapFrmGetObjectPtr, frm, objIndex);

	return (VoidPtr) theTrap.GetA0 ();
}

FormObjectKind FrmGetObjectType (const FormPtr frm, const Word objIndex)
{
	CallROM2 (sysTrapFrmGetObjectType, frm, objIndex);

	// Cast to an 8-bit type first.  FormObjectKind is an 8-bit
	// value on 68K machines, but a 32-bit (int) value on other
	// platforms.  If we don't cast to an 8-bit value first, we'll
	// end up with unwanted garbage in the upper 24 bits.

	return (FormObjectKind) (uae_u8) theTrap.GetD0 ();
}

WinHandle FrmGetWindowHandle (const FormPtr frm)
{
	CallROM1 (sysTrapFrmGetWindowHandle, frm);

	return (WinHandle) theTrap.GetA0 ();
}

// ---------------------------------------------------------------------------
//		 Hardware Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

void HwrDisableDataWrites (void)
{
	CallROM0 (sysTrapHwrDisableDataWrites);
}

Boolean HwrEnableDataWrites (void)
{
	CallROM0 (sysTrapHwrEnableDataWrites);

	return (Boolean) theTrap.GetD0 ();
}

DWord HwrMemReadable (VoidPtr addr)
{
	CallROM1 (sysTrapHwrMemReadable, addr);

	return (DWord) theTrap.GetD0 ();
}

DWord HwrMemWritable (VoidPtr addr)
{
	CallROM1 (sysTrapHwrMemWritable, addr);

	return (DWord) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Keyboard Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

ULong KeyHandleInterrupt (Boolean periodic, DWord status)
{
	CallROM2 (sysTrapKeyHandleInterrupt, periodic, status);

	return (ULong) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Memory Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

Err MemChunkFree (VoidPtr chunkDataP)
{
	CallROM1 (sysTrapMemChunkFree, chunkDataP);

	return (Err) theTrap.GetD0 ();
}

UInt MemHandleHeapID (VoidHand h)
{
	CallROM1 (sysTrapMemHandleHeapID, h);

	return (UInt) theTrap.GetD0 ();
}

VoidPtr MemHandleLock (VoidHand h)
{
	CallROM1 (sysTrapMemHandleLock, h);

	return (VoidPtr) theTrap.GetA0 ();
}

ULong MemHandleSize (VoidHand h)
{
	CallROM1 (sysTrapMemHandleSize, h);

	return (ULong) theTrap.GetD0 ();
}

LocalID MemHandleToLocalID (VoidHand h)
{
	CallROM1 (sysTrapMemHandleToLocalID, h);

	return (LocalID) theTrap.GetD0 ();
}

Err MemHandleUnlock (VoidHand h)
{
	CallROM1 (sysTrapMemHandleUnlock, h);

	return (Err) theTrap.GetD0 ();
}

VoidPtr MemHeapPtr (UInt heapID)
{
	CallROM1 (sysTrapMemHeapPtr, heapID);

	return (VoidPtr) theTrap.GetA0 ();
}

LocalIDKind MemLocalIDKind (LocalID local)
{
	CallROM1 (sysTrapMemLocalIDKind, local);

	return (LocalIDKind) theTrap.GetD0 ();
}

VoidPtr MemLocalIDToGlobal (LocalID local, UInt cardNo)
{
	CallROM2 (sysTrapMemLocalIDToGlobal, local, cardNo);

	return (VoidPtr) theTrap.GetA0 ();
}

UInt MemNumCards (void)
{
	CallROM0 (sysTrapMemNumCards);

	return (UInt) theTrap.GetD0 ();
}

UInt MemNumHeaps (UInt cardNo)
{
	CallROM1 (sysTrapMemNumHeaps, cardNo);

	return (UInt) theTrap.GetD0 ();
}

UInt MemNumRAMHeaps (UInt cardNo)
{
	CallROM1 (sysTrapMemNumRAMHeaps, cardNo);

	return (UInt) theTrap.GetD0 ();
}

Err MemNVParams (Boolean set, SysNVParamsPtr paramsP)
{
	Canonical_If_Not_Null (paramsP);

	CallROM2 (sysTrapMemNVParams, set, paramsP);

	Canonical_If_Not_Null (paramsP);

	return (Err) theTrap.GetD0 ();
}

UInt MemPtrFlags (VoidPtr p)
{
	CallROM1 (sysTrapMemPtrFlags, p);

	return (UInt) theTrap.GetD0 ();
}

UInt MemPtrHeapID (VoidPtr p)
{
	CallROM1 (sysTrapMemPtrHeapID, p);

	return (UInt) theTrap.GetD0 ();
}

VoidPtr MemPtrNew (ULong size)
{
	CallROM1 (sysTrapMemPtrNew, size);

	return (VoidPtr) theTrap.GetA0 ();
}

Err MemPtrSetOwner (VoidPtr p, UInt owner)
{
	CallROM2 (sysTrapMemPtrSetOwner, p, owner);

	return (Err) theTrap.GetD0 ();
}

ULong MemPtrSize (VoidPtr p)
{
	CallROM1 (sysTrapMemPtrSize, p);

	return (ULong) theTrap.GetD0 ();
}

Err MemPtrUnlock (VoidPtr p)
{
	CallROM1 (sysTrapMemPtrUnlock, p);

	return (Err) theTrap.GetD0 ();
}

Err MemSemaphoreRelease (Boolean writeAccess)
{
	CallROM1 (sysTrapMemSemaphoreRelease, writeAccess);

	return (Err) theTrap.GetD0 ();
}

Err MemSemaphoreReserve (Boolean writeAccess)
{
	CallROM1 (sysTrapMemSemaphoreReserve, writeAccess);

	return (Err) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Net Library functions
// ---------------------------------------------------------------------------

#pragma mark -

Err NetLibConfigMakeActive (Word refNum, Word configIndex)
{
	CallROM2 (netLibConfigMakeActive, refNum, configIndex);

	return (Err) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Pen Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

Err PenCalibrate (PointType* digTopLeftP, PointType* digBotRightP,
					PointType* scrTopLeftP, PointType* scrBotRightP)
{
	Canonical_If_Not_Null (digTopLeftP);
	Canonical_If_Not_Null (digBotRightP);
	Canonical_If_Not_Null (scrTopLeftP);
	Canonical_If_Not_Null (scrBotRightP);

	CallROM4 (sysTrapPenCalibrate, digTopLeftP, digBotRightP, scrTopLeftP, scrBotRightP);

	Canonical_If_Not_Null (digTopLeftP);
	Canonical_If_Not_Null (digBotRightP);
	Canonical_If_Not_Null (scrTopLeftP);
	Canonical_If_Not_Null (scrBotRightP);

	return (Err) theTrap.GetD0 ();
}

Err	 PenRawToScreen(PointType* penP)
{
	Canonical_If_Not_Null (penP);

	CallROM1 (sysTrapPenRawToScreen, penP);

	Canonical_If_Not_Null (penP);

	return (Err) theTrap.GetD0 ();
}

Err PenScreenToRaw (PointType* penP)
{
	Canonical_If_Not_Null (penP);

	CallROM1 (sysTrapPenScreenToRaw, penP);

	Canonical_If_Not_Null (penP);

	return (Err) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Peferences Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

DmOpenRef PrefOpenPreferenceDBV10 (void)
{
	CallROM0 (sysTrapPrefOpenPreferenceDBV10);

	return (DmOpenRef) theTrap.GetA0 ();
}

DmOpenRef PrefOpenPreferenceDB (Boolean saved)
{
	CallROM1 (sysTrapPrefOpenPreferenceDB, saved);

	return (DmOpenRef) theTrap.GetA0 ();
}

void PrefSetPreference (SystemPreferencesChoice choice, DWord value)
{
	// Coerce "choice" to a 1-byte value to match the way the 68K
	// code-generator determines an enum's size.

	CallROM2 (sysTrapPrefSetPreference, (uae_u8) choice, value);
}

// ---------------------------------------------------------------------------
//		 System Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

Err	SysCurAppDatabase (UIntPtr cardNoP, LocalID* dbIDP)
{
	Canonical_If_Not_Null (cardNoP);
	Canonical_If_Not_Null (dbIDP);

	CallROM2 (sysTrapSysCurAppDatabase, cardNoP, dbIDP);

	Canonical_If_Not_Null (cardNoP);
	Canonical_If_Not_Null (dbIDP);

	return (Err) theTrap.GetD0 ();
}

SysAppInfoPtr SysCurAppInfoPV20 (void)
{
	CallROM0 (sysTrapSysCurAppInfoPV20);

	return (SysAppInfoPtr) theTrap.GetA0 ();
}

SysAppInfoPtr SysGetAppInfo (SysAppInfoPtr *uiAppPP, SysAppInfoPtr *actionCodeAppPP)
{
	Canonical_If_Not_Null ((void**) uiAppPP);
	Canonical_If_Not_Null ((void**) actionCodeAppPP);

	CallROM2 (sysTrapSysGetAppInfo, uiAppPP, actionCodeAppPP);

	Canonical_If_Not_Null ((void**) uiAppPP);
	Canonical_If_Not_Null ((void**) actionCodeAppPP);

	return (SysAppInfoPtr) theTrap.GetA0 ();
}

Err SysKernelInfo (VoidPtr p)
{
	SysKernelInfoPtr	infoP = (SysKernelInfoPtr) p;

	Canonical_If_Not_Null (infoP);

	CallROM1 (sysTrapSysKernelInfo, p);

	Canonical_If_Not_Null (infoP);

	return (Err) theTrap.GetD0 ();
}


UInt SysSetAutoOffTime (UInt seconds)
{
	CallROM1 (sysTrapSysSetAutoOffTime, seconds);

	return (UInt) theTrap.GetD0 ();
}

Err SysUIAppSwitch (UInt cardNo, LocalID dbID, Word cmd, Ptr cmdPBP)
{	
	CallROM4 (sysTrapSysUIAppSwitch, cardNo, dbID, cmd, cmdPBP);

	return (Err) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Table Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

FieldPtr TblGetCurrentField (const TablePtr table)
{
	CallROM1 (sysTrapTblGetCurrentField, table);

	return (FieldPtr) theTrap.GetA0 ();
}

// ---------------------------------------------------------------------------
//		 Text Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

Byte TxtByteAttr(Byte inByte)
{
	CallIntl1 (intlTxtByteAttr, inByte);

	return (Byte) theTrap.GetD0 ();
}

Word TxtCharBounds (ConstCharPtr inText, ULong inOffset, ULongPtr outStart, ULongPtr outEnd)
{
	Canonical_If_Not_Null (outStart);
	Canonical_If_Not_Null (outEnd);

	StMemoryMapper	mapper (inText, inOffset + 4);

	CallIntl4 (intlTxtCharBounds, inText, inOffset, outStart, outEnd);

	Canonical_If_Not_Null (outStart);
	Canonical_If_Not_Null (outEnd);

	return (Word) theTrap.GetD0 ();
}

Word TxtGetNextChar (ConstCharPtr inText, ULong inOffset, WCharPtr outChar)
{
	Canonical_If_Not_Null (outChar);

	StMemoryMapper	mapper (inText, inOffset + 4);

	CallIntl3 (intlTxtGetNextChar, inText, inOffset, outChar);

	Canonical_If_Not_Null (outChar);

	return (Word) theTrap.GetD0 ();
}

// ---------------------------------------------------------------------------
//		 Window Manager functions
// ---------------------------------------------------------------------------

#pragma mark -

WinHandle WinGetActiveWindow (void)
{
	CallROM0 (sysTrapWinGetActiveWindow);

	return (WinHandle) theTrap.GetA0 ();
}

void WinGetDisplayExtent (SWordPtr extentX, SWordPtr extentY)
{
	Canonical_If_Not_Null (extentX);
	Canonical_If_Not_Null (extentY);

	CallROM2 (sysTrapWinGetDisplayExtent, extentX, extentY);

	Canonical_If_Not_Null (extentY);
	Canonical_If_Not_Null (extentX);
}

WinHandle WinGetFirstWindow (void)
{
	CallROM0 (sysTrapWinGetFirstWindow);

	return (WinHandle) theTrap.GetA0 ();
}

void WinGetWindowBounds (RectanglePtr r)
{
	Canonical_If_Not_Null (r);

	CallROM1 (sysTrapWinGetWindowBounds, r);

	Canonical_If_Not_Null (r);
}

WinHandle WinSetDrawWindow (WinHandle winHandle)
{
	CallROM1 (sysTrapWinSetDrawWindow, winHandle);

	return (WinHandle) theTrap.GetA0 ();
}

void WinWindowToDisplayPt (SWordPtr extentX, SWordPtr extentY)
{
	Canonical_If_Not_Null (extentX);
	Canonical_If_Not_Null (extentY);

	CallROM2 (sysTrapWinWindowToDisplayPt, extentX, extentY);

	Canonical_If_Not_Null (extentX);
	Canonical_If_Not_Null (extentY);
}
