/*
 * (C) Copyright Keith Visco 1998  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl;

import org.w3c.dom.*;

/**
 * This class represents an xsl:use element
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class XSLUse extends EmptyXSLObject {
    
    private String attributeSetName = null;

      //----------------/
     //- Constructors -/
    //----------------/
    
    
    /**
     * Creates a new XSLUse
    **/
    protected XSLUse(XSLStylesheet parentStylesheet) 
    {
        super(parentStylesheet,XSLObject.USE);
        super.setAllowActions(false);
    } //-- XSLUse
    
      //------------------/
     //- Public Methods -/
    //------------------/
	
	/**
	 * Returns the name of the AttributeSet that this XSLUse references
	 * @return the name of the AttributeSet that this XSLUse references
	**/
	public String getAttributeSetName() {
	    return this.attributeSetName;
	} //-- getAttributeSetName
	
	/**
	 * Sets the name of the AttributeSet that this XSLUse references
	 * @name the name of the AttributeSet to reference
	**/
	public void setAttributeSetName(String name) {
	    this.attributeSetName = name;
	} //-- setAttributeSetName
    
} //-- XSLUse