/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The contents of this file are released under an Open Source 
 * Definition (OSD) compliant license; you may not use this file 
 * execpt in compliance with the license. Please see license.txt, 
 * distributed with this file. You may also obtain a copy of the
 * license at http://www.clc-marketing.com/xslp/license.txt
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 *
 * 
 */

package com.kvisco.xsl;

import com.kvisco.xsl.functions.FalseFunctionCall;
import com.kvisco.xsl.functions.TrueFunctionCall;

import com.kvisco.util.List;
import org.w3c.dom.*;

/**
 * This class represents a BooleanExpr
 * <PRE>
 * [24] BooleanExpr ::= AndExpr | OrExpr | PrimaryExpr
 * </PRE>
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class BooleanExpr implements Expr {


    
    private Expr expr;
    
    
    
      //----------------/
     //- Constructors -/
    //----------------/

    /**
     * Creates a new BooleanExpr of the given type
    **/
    protected BooleanExpr() {
        this(null);
    } //-- BooleanExpr

    protected BooleanExpr(boolean bool) {
        if (bool) this.expr = new TrueFunctionCall();
        else this.expr = new FalseFunctionCall();
    } //-- BooleanExpr
    
    /**
     * Creates a new BooleanExpr of the given type
     * and adds the given BooleanPrimaryExpr to the
     * expression list
    **/
    protected BooleanExpr(Expr expr) {
        this.expr = expr;
    } //-- BooleanExpr
    
      //------------------/
     //- Public Methods -/
    //------------------/
    /**
     * Returns the type of Expr this Expr represents
     * @return the type of Expr this Expr represents
    **/
    public short getExprType() {
        return Expr.BOOLEAN;
    } //-- getExprType
    
    /**
     * Evalutes this BooleanExpr using the given Node as
     * the context
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {
        if (expr != null)
            return new BooleanResult(expr.evaluate(context, ps));
        else
            return new BooleanResult();
    } //-- evaluate
    
    /**
     * Returns the String representation of this BooleanExpr
     * @return the String representation of this BooleanExpr
    **/
    public String toString() {
        if (expr!= null) return expr.toString();
        else return "false()";
    } //-- toString
    
} //-- BooleanExpr
