/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.openxml.util.Resources;
import org.openxml.x3p.Publisher;
import org.openxml.x3p.PublisherCreator;
import org.openxml.x3p.PublisherTarget;
import org.openxml.x3p.PublisherTargetNotSupportedException;
import org.openxml.x3p.StreamFormat;
import org.openxml.x3p.publishers.PublisherFactoryImpl;
import org.openxml.x3p.publishers.StreamPublisherCreator;
import org.openxml.x3p.publishers.StreamPublisherTarget;

public class PublisherFactory {
    private static PublisherFactoryImpl _singleton = new PublisherFactoryImpl();

    static {
        _singleton.registerPublisher(new StreamPublisherCreator());
    }

    public static PublisherCreator asCreator() {
        return _singleton;
    }

    public static synchronized Publisher createPublisher(File file, StreamFormat streamFormat) throws IOException {
        return _singleton.createPublisher(new StreamPublisherTarget(file, streamFormat));
    }

    public static synchronized Publisher createPublisher(OutputStream outputStream, StreamFormat streamFormat) throws IOException {
        return _singleton.createPublisher(new StreamPublisherTarget(outputStream, streamFormat));
    }

    public static synchronized Publisher createPublisher(Writer writer, StreamFormat streamFormat) throws IOException {
        return _singleton.createPublisher(new StreamPublisherTarget(writer, streamFormat));
    }

    public static synchronized Publisher createPublisher(PublisherTarget publisherTarget) throws PublisherTargetNotSupportedException, IOException {
        Publisher publisher = _singleton.createPublisher(publisherTarget);
        if (publisher == null) {
            throw new PublisherTargetNotSupportedException(Resources.format("Publisher000", publisherTarget));
        }
        return publisher;
    }

    public static synchronized boolean isSupported(PublisherTarget publisherTarget) {
        return _singleton.isSupported(publisherTarget);
    }

    public static synchronized Class[] listTargets() {
        return _singleton.listTargets();
    }

    public static synchronized void registerPublisher(PublisherCreator publisherCreator) {
        if (publisherCreator != _singleton) {
            _singleton.registerPublisher(publisherCreator);
        }
    }
}

