/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.io;

import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.openxml.io.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Printer {
    public static final int DEFAULT = 0;
    public static final int PRETTY = 1;
    public static final int COMPACT = 2;
    public static final int NOWRAP = 4;
    public static final int DTD_ENTITIES_ONLY = 8;
    public static final int DTD_STANDALONE = 16;
    public static final int DTD_CONTENT = 32;
    private StringBuffer _textLine = new StringBuffer(80);
    private StringBuffer _textWord = new StringBuffer(20);
    private int _whiteSpaces;
    private int _thisIndent;
    private int _nextIndent;
    private int _indentSpaces = 4;
    private int _lineWidth;
    private int _mode;
    private Writer _writer;
    private String _lineSeparator;

    public Printer(Writer writer, int n, int n2, int n3) {
        this._writer = writer;
        this._mode = n;
        if (this.mode(1)) {
            this._mode &= 0xFFFFFFF9;
        }
        if (n2 <= 0) {
            throw new IllegalStateException("Argument 'lineWidth' is negative.");
        }
        if (n2 < 40) {
            n2 = 40;
        }
        this._lineWidth = n2;
        if (n3 <= 0) {
            throw new IllegalStateException("Argument 'indentSpaces' is negative.");
        }
        this._indentSpaces = n3;
    }

    protected final StringBuffer appendLiteral(StringBuffer stringBuffer, String string) {
        stringBuffer.append('\"');
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\"') {
                stringBuffer.append("&#22;");
            } else if (string.charAt(n) > '\u007f') {
                stringBuffer.append("&#").append(String.valueOf(string.charAt(n))).append(';');
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        stringBuffer.append('\"');
        return stringBuffer;
    }

    protected final void breakLine() throws IOException {
        while (this._whiteSpaces > 0) {
            this._textLine.append(' ');
            --this._whiteSpaces;
        }
        this._textLine.append((Object)this._textWord);
        this._textWord.setLength(0);
        this.flushLine();
    }

    public final void close() {
        try {
            this._writer.close();
        }
        catch (IOException iOException) {}
    }

    protected final String encode(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl) {
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    String string2 = this.getCharacterRef(c);
                    if (string2 == null) {
                        if (c < ' ' || c >= '\u007f') {
                            stringBuffer.append("&#").append(Integer.toString(c)).append(';');
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append('&').append(string2).append(';');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public final void flush() throws IOException {
        this._writer.flush();
    }

    protected final void flushLine() throws IOException {
        if (this._textLine.length() > 0) {
            block7: {
                if (this._thisIndent > 40) {
                    this._thisIndent = 40;
                }
                while (this._thisIndent > 0) {
                    this._writer.write(32);
                    --this._thisIndent;
                }
                this._thisIndent = this._nextIndent;
                try {
                    this._writer.write(this._textLine.toString());
                    while (this._whiteSpaces > 1) {
                        this._writer.write(32);
                        --this._whiteSpaces;
                    }
                    if (this._lineSeparator == null) {
                        this._writer.write(10);
                        break block7;
                    }
                    this._writer.write(this._lineSeparator);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this._whiteSpaces = 0;
                    this._textLine.setLength(0);
                    throw throwable;
                }
            }
            Object var2_1 = null;
            this._whiteSpaces = 0;
            this._textLine.setLength(0);
        }
    }

    protected String getCharacterRef(char c) {
        return null;
    }

    protected final String getEncoding() {
        if (this._writer instanceof XMLStreamWriter) {
            return ((XMLStreamWriter)this._writer).getEncoding();
        }
        return null;
    }

    protected final int getMode() {
        return this._mode;
    }

    protected final Writer getWriter() {
        return this._writer;
    }

    protected void indent() {
        this.indent(this._indentSpaces);
    }

    protected final void indent(int n) {
        if (!this.mode(2) && !this.mode(4)) {
            this._nextIndent += n;
            if (this._nextIndent < 0) {
                this._nextIndent = 0;
            }
            if (n < 0 && this._textLine.length() + this._whiteSpaces + this._textWord.length() == 0) {
                this._thisIndent = this._nextIndent;
            }
        }
    }

    protected final boolean mode(int n) {
        return (this._mode & n) != 0;
    }

    public abstract void print(Document var1) throws IOException;

    public abstract void print(DocumentFragment var1) throws IOException;

    public abstract void print(Element var1) throws IOException;

    protected final void printBreak() {
        if (this._textWord.length() > 0) {
            while (this._whiteSpaces > 0) {
                this._textLine.append(' ');
                --this._whiteSpaces;
            }
            this._textLine.append((Object)this._textWord);
            this._textWord.setLength(0);
        }
    }

    protected abstract void printDocument(Node var1, StringBuffer var2) throws IOException;

    protected abstract void printElement(Element var1, StringBuffer var2) throws IOException;

    protected final void printNode(Node node) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(100);
        switch (node.getNodeType()) {
            case 4: {
                this.breakLine();
                this.indent();
                String string = node.getNodeValue();
                int n = string.indexOf("]]>");
                if (n >= 0) {
                    stringBuffer.append("<![CDATA[").append(string.substring(0, n)).append("]]>");
                } else {
                    stringBuffer.append("<![CDATA[").append(string).append("]]>");
                }
                this.printWords(stringBuffer, true);
                this.unindent();
                this.breakLine();
                break;
            }
            case 8: {
                if (this.mode(2)) break;
                if (this.mode(1)) {
                    this.breakLine();
                }
                this.indent();
                String string = node.getNodeValue();
                int n = string.indexOf("--");
                if (n >= 0) {
                    stringBuffer.append("<!--").append(string.substring(0, n)).append("-->");
                } else {
                    stringBuffer.append("<!--").append(string).append("-->");
                }
                this.printWords(stringBuffer, true);
                this.unindent();
                if (!this.mode(1)) break;
                this.breakLine();
                break;
            }
            case 5: {
                stringBuffer.append('&').append(node.getNodeName()).append(';');
                this.printPart(stringBuffer);
                break;
            }
            case 7: {
                this.indent();
                String string = node.getNodeName();
                int n = string.indexOf("?>");
                if (n >= 0) {
                    stringBuffer.append("<?").append(string.substring(0, n));
                } else {
                    stringBuffer.append("<?").append(string);
                }
                stringBuffer.append(' ');
                string = node.getNodeValue();
                n = string.indexOf("?>");
                if (n >= 0) {
                    stringBuffer.append(string.substring(0, n)).append("?>");
                } else {
                    stringBuffer.append(string).append("?>");
                }
                this.printWords(stringBuffer, true);
                this.unindent();
                break;
            }
            case 3: {
                this.printWords(this.encode(node.getNodeValue(), this.mode(2) ^ true), this.mode(2) ^ true);
                break;
            }
            case 9: 
            case 11: {
                this.printDocument(node, stringBuffer);
                break;
            }
            case 1: {
                this.printElement((Element)node, stringBuffer);
                break;
            }
        }
    }

    protected final void printPart(char c) throws IOException {
        this._textWord.append(c);
        this.wrapLine();
    }

    protected final void printPart(String string) throws IOException {
        this._textWord.append(string);
        this.wrapLine();
    }

    protected final void printPart(StringBuffer stringBuffer) throws IOException {
        this._textWord.append((Object)stringBuffer);
        this.wrapLine();
    }

    protected final void printSpace() {
        this.printBreak();
        if (this._whiteSpaces == 0 || !this.mode(2)) {
            ++this._whiteSpaces;
        }
    }

    protected final void printWords(String string, boolean bl) throws IOException {
        if (bl) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \f\t\n\r", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                switch (string2.charAt(0)) {
                    case '\t': {
                        this.printPart('\t');
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        this.breakLine();
                        break;
                    }
                    case ' ': {
                        this.printSpace();
                        break;
                    }
                    default: {
                        this.printPart(string2);
                        break;
                    }
                }
            }
        } else {
            String string3;
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " \f\t\n\r", false);
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                this.printPart(string3);
            }
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                this.printSpace();
                this.printPart(string3);
            }
        }
    }

    protected final void printWords(StringBuffer stringBuffer, boolean bl) throws IOException {
        this.printWords(stringBuffer.toString(), bl);
    }

    public final void setLineSeparator(String string) {
        this._lineSeparator = string;
    }

    protected final void setMode(int n) {
        this._mode = n;
    }

    protected void unindent() {
        this.indent(-this._indentSpaces);
    }

    protected final void wrapLine() throws IOException {
        if (!this.mode(4) && this._thisIndent + this._textLine.length() + this._whiteSpaces + this._textWord.length() > this._lineWidth) {
            this.flushLine();
        }
    }
}

