/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sarien.h"
#include "agi.h"
#include "logic.h"

/*#define DUMP_LOGIC_TEXT*/

AGI_LOGIC	logics[MAX_DIRS];

/* decodes messages into message list from raw logic files */
UINT16 decode_logic(UINT16 resnum)
{
	UINT16	ec=err_OK;
	UINT8	*m0;
	UINT32	mstart, mend, mc;

	/* decrypt messages at end of logic + build message list */

	m0=logics[resnum].data;

	mstart=lohi_getword(m0)+2;
	mc=lohi_getbyte(m0+mstart);
	mend=lohi_getword(m0+mstart+1);
	m0+=mstart+3;				/* cover header info */
	mstart=mc<<1;

	/* if the logic was not compressed, decrypt the text messages */
	/* only if there are more than 0 messages */
	if((dir_logic[resnum].flags&RES_COMPRESSED)!=RES_COMPRESSED && mc>0)
		decrypt(m0+mstart, mend-mstart);	/* decrypt messages */

	/* build message list */
	m0=logics[resnum].data;
	mstart=lohi_getword(m0)+2;			/* +2 covers pointer */
	logics[resnum].num_texts=lohi_getbyte(m0+mstart);

	/* resetp logic pointers */
	logics[resnum].sIP=2;
	logics[resnum].cIP=2;
	logics[resnum].size=lohi_getword(m0)+2;	 /* covers logic end pointer */

	/* allocate list of pointers to point into our data */
	logics[resnum].texts=(UINT8**)calloc(1+logics[resnum].num_texts, sizeof(UINT8*));

	/* cover header info */
	m0+=mstart+3;

	if(logics[resnum].texts!=NULL)
	{
		/* move list of strings into list to make real pointers */
		for(mc=0; mc<logics[resnum].num_texts; mc++)
		{
			mend=lohi_getword(m0+mc*2);
			logics[resnum].texts[mc] = mend ?
				m0+mend-2 : null_msg;
#ifdef DUMP_LOGIC_TEXT
			if(logics[resnum].texts[mc]!=null_msg)
				printf("Logic %03i.%i\n%s\n", resnum, mc, logics[resnum].texts[mc]);
#endif
		}
		/* set loaded flag now its all completly loaded */
		dir_logic[resnum].flags|=RES_LOADED;
	}
	else
	{
		/* unload data */
		/* blah DF YA WANKER!!@!@# frag. i'm so dumb. not every logic
		   has text */
		free(logics[resnum].data);
		ec=err_NotEnoughMemory;
	}

	return ec;
}
