.\" @(#)rxvt.1	2.14 18DEC95 (mjo)
.\" -*- nroff -*-
.ds rx rxvt
.\" change to following Macros to suit your installation
.\" hk = Hotkey, bf = bigger font, sf = smaller font
.\" .ds hk Shift
.\" .ds hk Ctrl
.ds hk Alt
.ds bf KP_Add
.ds sf KP_Subtract
.\"
.\" done
.TH RXVT 2.14 "18 December 1995" "X Version 11" "X Tools"
.UC
.SH NAME
rxvt \- vt102 emulator for the X window system
.SH SYNOPSIS
\fBrxvt\fP [ \fIoptions\fP ]  [ \fI-e\fP \fIcommand\fP [ \fIargs\fP ] ]

.SH DESCRIPTION
\fIrxvt\fP is a vt102 (or vt220/320) terminal emulator for X intended as
an \fIxterm\fP(1) replacement for users who do not require the more esoteric
features of \fIxterm\fP.  Specifically, Tektronix 4014 emulation, session
logging and toolkit style configurability are not implemented.  As a result,
\fIrxvt\fP uses much less swap space than \fIxterm\fP \- a significant
advantage on a machine serving many X sessions.

.SH OPTIONS
The options supported by \fIrxvt\fP (mostly a subset of those supported by
\fIxterm\fP) are listed below.
Note that in keeping with the smaller-is-better philosophy of \fIrxvt\fP,
default option values may be decided at compile-time or eliminated entirely
(if that feature is not desired), hence the options and defaults listed
below may not (probably will not) accurately reflect the version of
\fIrxvt\fP that has been compiled for your specific system.  If you want
different compile-time default values or else add or eliminate specific
options, read the file INSTALL.
.IP "\fB-help\fP"
Print out a verbose message describing the options.
.IP "\fB-display\fP \fIdisplayname\fP"
Attempt to open a window on the named X display. In the absence of this option,
the display specified by the DISPLAY environment variable is used.
.IP "\fB-geometry\fP \fIgeom\fP"
Window geometry:
resource \fBgeometry\fP.
.\" .IP "\fB-cursor\fP \fIcursor_name\fP"
.\" Text cursor: resource \fBcursor\fP.
.IP "\fB-bg\fP \fIcolor\fP"
Window background color:
resource \fBbackground\fP.
.IP "\fB-fg\fP \fIcolor\fP"
Window foreground color:
resource \fBforeground\fP.
.IP "\fB-color<n>\fP \fIcolor\fP"
Use the specified color for the ANSI color number <n>, where <n> = 0..7 for
normal colors and <n> = 10..17 for high-intensity (bold foreground or blink
background) colors:
resource \fBcolor<n>\fP.
.IP "\fB-fn\fP \fIfontname\fP"
Main text font:
resource \fBfont\fP.
.IP "\fB-font<n>\fP \fIfontname\fP"
Alternative font <n>:
resource \fBfont<n>\fP.
.IP "\fB-name\fP \fIname\fP"
Specify the application name under which resources are to be obtained,
rather than the default executable file name.  Also sets the icon and
title name (default "rxvt").
.IP "\fB-/+ls\fP"
Start as a login-shell/sub-shell:
resource \fBloginShell\fP.
.IP "\fB-/+ut\fP"
Inhibit/enable writing a utmp entry:
resource \fButmpInhibit\fP.
.IP "\fB-/+vb\fP"
Turn on/off visual bell on receipt of a bell character:
resource \fBvisualBell\fP.
.IP "\fB-/+ma\fP"
Turn on/off deiconify (map) on receipt of a bell character:
resource \fBmapAlert\fP.
.IP "\fB-/+sb\fP"
Turn on/off a scrollbar:
resource \fBscrollBar\fP.
.IP "\fB-/+arrows\fP"
Add/remove arrows to the scrollbar:
resource \fBscrollBar\fP.
.IP "\fB-ic\fP"
Start iconified, if the window manager supports that option.
.IP "\fB-/+meta\fP"
Turn on/off processing of meta (Alt) + keypress as an escape prefix:
resource \fBmeta\fP.
.IP "\fB-meta8\fP"
Meta (Alt) + keypress sets the 8th bit:
resource \fBmeta\fP.
Note this passes responsibility of handling 8-bit characters
to the application running on the terminal.
.IP "\fB-sl\fP \fInumber\fP"
Save \fInumber\fP lines in the scrollback buffer (default 64):
resource \fBsaveLines\fP.
.IP "\fB-grk9 | -grk4\fP"
Select elot-928 or ibm-437 greek keyboard translation.
The former is an ISO-8859 standard, the latter is still used a lot.
.IP "\fB-print-pipe\fP \fIname\fP"
Specify a pipe/command for vt100 printer.
.IP "\fB-e\fP \fIcommand\fP [ \fIarguments\fP ]"
Run the command with its command-line arguments in the \fIrxvt\fP
window.  If this option is used, it must be the last on the command-line.
If there is no \fB-e\fP option then the default is to run the program
specified by the SHELL environment variable or, failing that,
\fIsh\fP(1).
.IP "\fB-T\fP \fItext\fP"
.IP "\fB-title\fP \fItext\fP"
Window title:
resource \fBtitle\fP.
.IP "\fB-n\fP \fItext\fP"
Icon name:
resource \fBiconName\fP.
.IP "\fB-C\fP"
Capture system console messages.
.IP "\fB-/+7\fP"
Turn on/off stripping of 8th bit:
resource \fBbits\fP.
.IP "\fB-refresh\fP \fInumber\fP"
Resource \fBrefreshPeriod\fP.
.IP "\fB-secure\fP \fIkeysym\fP"
Only if compiled without resources: resource \fBsecure_key\fP.
.IP "\fB-pageup\fP \fIkeysym\fP"
Only if compiled without resources: resource \fBpageup_key\fP.
.IP "\fB-pagedown\fP \fIkeysym\fP"
Only if compiled without resources: resource \fBpagedown_key\fP.
.IP "\fB-bigfont\fP \fIkeysym\fP"
Only if compiled without resources: resource \fBbigfont_key\fP.
.IP "\fB-smallfont\fP \fIkeysym\fP"
Only if compiled without resources: resource \fBsmallfont_key\fP.
.IP "\fB-prkey\fP \fIkeysym\fP"
Only if compiled without resources: resource \fBprintscreen_key\fP.

.SH RESOURCES
\fBrxvt\fP accepts resources set in ~/.Xdefaults and ~/.Xresources and
application defaults set in XAPPLOADDIR/RXvt (which would normally be
/usr/lib/X11/app-defaults/RXvt).  If no resources are specified, suitable
defaults will be used.  Command-line arguments can be used to override
resources settings. The following resources are allowed:

.IP "\fBgeometry\fP: \fIgeom\fP"
Create the window with the specified X window geometry (default 80x24):
option \fB-geometry\fP.
.\" .IP "\fBcursor\fP: \fIcursor\fP"
.\" Use the specified cursor as text cursor: option \fB-cursor\fP.
.IP "\fBbackground\fP: \fIcolor\fP"
Use the specified color as the window's background color (default white):
option \fB-bg\fP.
.IP "\fBforeground\fP: \fIcolor\fP"
Use the specified color as the window's foreground color (default black):
option \fB-fg\fP.
.IP "\fBcolor<n>\fP: \fIcolor\fP"
Color values of <n> correspond to their representative names as follows:
<0>black, <1>red, <2>green, <3>yellow, <4>blue, <5>magenta, <6>cyan,
<7>white.  Color values in the range 10..17 are the corresponding
high-intensity colors (bold foreground or blink background):
option \fB-color<n>\fP.
.IP "\fBfont\fP: \fIfontname\fP"
Set the main text font used (default fixed):
option \fB-fn\fP.
.IP "\fBfont<n>\fP: \fIfontname\fP"
Specify the alternative font <n> to be used for changing font sizes
on-the-fly with \*(hk-\*(bf or \*(hk-\*(sf:
option \fB-font<n>\fP.
.IP "\fBtitle\fP: \fItext\fP"
Set window title string, the default title is the command-line specified
after the -e option, if any, otherwise the application name:
option \fB-title\fP.
.IP "\fBiconName\fP: \fItext\fP"
Set the name used to label the window's icon or displayed in an icon manager
window, it also sets the window's title unless it is explicitly set:
option \fB-n\fP.
.IP "\fBmapAlert\fP: \fITrue\fP | \fIFalse\fP"
True = deiconify (map) on receipt of a bell character:
option \fB-ma\fP,
False = no deiconify (map) on receipt of a bell character (default):
option \fB+ma\fP.
.IP "\fBvisualBell\fP: \fITrue\fP | \fIFalse\fP"
True = use visual bell on receipt of a bell character (default):
option \fB-vb\fP.
False = no visual bell:
option \fB+vb\fP.
.IP "\fBbits\fP: \fI7\fP | \fI8\fP"
7 = strip the 8th bit from all characters typed on the keyboard:
option \fB-7\fP.
8 = 8-bit clean (default):
option \fB+7\fP.
.IP "\fBloginShell\fP: \fITrue\fP | \fIFalse\fP"
True = start as a login shell by prepending a "-" to argv[0] of the shell:
option \fB-ls\fP.
False = start as a normal sub-shell (default):
option \fB+ls\fP.
.IP "\fButmpInhibit\fP: \fITrue\fP | \fIFalse\fP"
True = inhibit writing record into the system log file /etc/utmp:
option \fB-ut\fP.
False = write record into the system log file /etc/utmp (default):
option \fB+ut\fP.
.IP "\fBscrollBar\fP: \fITrue\fP | \fIFalse\fP | \fIArrows\fP"
True = enable a scrollbar (default):
option \fB-sb\fP.
False = disable the scrollbar:
option \fB+sb\fP.
Arrows = enable a scrollbar that has arrows:
option \fB-arrows\fP.
Note that \fITrue\fP replaces \fIfat\fP and \fIArrows\fP replaces \fIthin\fP
of older versions.
.IP "\fBsmallfont_key\fP: \fIkeysym\fP"
Use \*(hk-\fIkeysym\fP to toggle to a smaller font (default \*(hk-\*(sf):
option \fB-smallfont\fP.
.IP "\fBbigfont_key\fP: \fIkeysym\fP"
Use \*(hk-\fIkeysym\fP to toggle to a bigger font (default \*(hk-\*(bf):
option \fB-bigfont\fP.
.IP "\fBpageup_key\fP: \fIkeysym\fP"
Use \*(hk-\fIkeysym\fP to scroll backward (default \*(hk-Prior):
option \fB-pageup\fP.
.IP "\fBpagedown_key\fP: \fIkeysym\fP"
Use \*(hk-\fIkeysym\fP to scroll forward (default \*(hk-Next):
option \fB-pagedown\fP.
.IP "\fBsecure_key\fP: \fIkeysym\fP"
Use \*(hk-\fIkeysym\fP to secure the keyboard (default \*(hk-S, not \*(hk-s):
option \fB-secure\fP.
.IP "\fBprintscreen_key\fP: \fIkeysym\fP"
Use \fIkeysym\fP to initiate a screen dump to the printer and
Ctrl/Shift-\fIkeysym\fP to include the scrollback as well
(default Print = PrintScreen): option \fB-prkey\fP.
.IP "\fBgreektoggle_key\fP: \fIkeysym\fP"
Use \fIkeysym\fP to toggle between normal and greek keyboard input
(default Mode_switch).
You may redefine it with `xmodmap -e "keycode ... = Mode_switch"`
.IP "\fBsaveLines\fP: \fInumber\fP"
Save \fInumber\fP lines in the scrollback buffer (default 64):
option \fB-sl\fP.
.IP "\fBmeta\fP: \fITrue\fP | \fIFalse\fP | \fI8bit\fP"
True = handle Meta (Alt) + keypress as an escape prefix (default):
option \fB-meta\fP.
False = disable Meta (Alt) key handling:
option \fB+meta\fP.
8bit = handle Meta (Alt) + keypress to set the 8th bit:
option \fB-meta8\fP.  Note that this option passes responsibility of
handling 8-bit characters to the application running on the terminal.
.IP "\fBcutcharclass\fP: \fIstring\fP"
The set of characters used as delimiters for double click word selection.
The built-in default is:  TAB SPACE [](){|}<=>"`,'*?&;
.IP "\fBrefreshPeriod\fP: \fInumber\fP"
Set maximum refresh period to this number of screeenfuls (default 10):
option -refresh.

.IP "\fBkeysym.<sym>\fP: \fIstring\fP"
Associate \fIstring\fP with keysym \fIsym\fP (\fIsym\fP = 0xFF00 \- 0xFFFF).
If \fIstring\fP starts or ends with whitespace, it must be enclosed with
double quotes.  \fIstring\fP may contain escape values:
\\b \- backspace,
\\e \- escape,
\\n \- newline,
\\r \- carriage return,
\\t \- tab,
\\000 \- octal number.
NB: this resource is only available if FAKE_RESOURCES has been used and the
intervening resource name "keysym" cannot be omitted.

.SH "TITLES AND ICON NAMES"
One occasionally confusing aspect of X applications is the collection of
names that an application window can have.  In fact, each terminal window
has two distinct names (although they are often the same value): its title
-- which is the text displayed in the title bar (if one exists) -- and its
icon name -- which is the name that appears in the window's icon or
represents it in the icon manager window.

.SH "THE SCROLLBAR"
Lines of text that scroll off the top of the \fIrxvt\fP window are saved
automatically (up to a preset maximum number) and can be viewed by scrolling
them back into the window with the scrollbar or by using \*(hk-Next or
\*(hk-Prior, although the actual key used may be altered through command-line
options or X resources (described above).  The -sb option (scrollBar: True)
selects an \fIxterm-style\fP scrollbar; the -arrows option (scrollBar: Arrows)
selects an \fIrxvt-style\fP scrollbar.

.\" I wish I knew nroff a bit better and make a nice table, oh well
.SS Scroll-down
\*(hk-Next, Button1 (xterm-style), Down Arrow (rxvt-style)
.SS Scroll-up
\*(hk-Prior, Button3 (xterm-style), Up Arrow (rxvt-style)
.SS Continuous scroll with mouse motion
Button2 (xterm-style), Any Button (rxvt-style)

.SH "TEXT SELECTION AND INSERTION"
\fIrxvt\fP uses a similar kind of text selection and insertion mechanism
to \fIxterm\fP.  Pressing and releasing the middle mouse button in an
\fIrxvt\fP window causes the current text selection to be inserted as if
it had been typed on the keyboard.  For the insertion to take place,
both the button press and the button release need to be done with the
cursor in the \fIrxvt\fP window.
.LP
The left and right mouse buttons are used to select text.
A text selection starts at the point where the left or right button is
pressed, and ends at the point where it is released.

\fBrxvt\fP can be compiled with support for selecting words if you
double-click on them, or whole lines if you triple-click.
This is a compile-time option.

.SH "MOUSE REPORTING"
If mouse reporting mode is active, the normal scrollbar actions are disabled
\- on the assumption that we are using a fullscreen application.  Instead
pressing Button1 sends "ESC[6~" (Next) and pressing Button3 sends "ESC[5~"
(Prior).  Clicking on the up arrow sends "ESC[A" (Up) and clicking on the
down arrow sends "ESC[B" (Down).
.LP
To temporarily override mouse reporting, either for using the scrollbar or
to use normal text selection/insertion, hold either the Shift key or the
Meta key (Alt) while performing the desired mouse action.

.SH "SECURING THE KEYBOARD"
You can enter or exit from the secure keyboard mode by typing \*(hk-S (not
\*(hk-s). This is typically a good thing to do when you are typing a
password.  The actual key used can be switched through command-line options
or X resources options described above.

.SH "CHANGING FONTS"
You can change fonts on-the-fly by typing \*(hk-\*(bf or \*(hk-\*(sf.
The actual key used can be switched through command-line options or X
resources options described above. This will cycle through your default font
and 4 others of various sizes.

.SH "AUTOMATIC MAPPING"
You can specify that \fBrxvt\fP will automatically de-iconify itself when it
receives a bell character. This can be configured on/off with the -/+ma
command-line option.  The current state may be toggled with \*(hk-I (not
\*(hk-i).

.SH "LOGIN STAMP"
\fIrxvt\fP tries to write an entry into the \fIutmp\fP file (usually
/etc/utmp), so that it can be seen via the \fIwho\fP(1) command, and can
accept messages.  To allow this feature, \fIrxvt\fP must be installed setuid
root, or the \fIutmp\fP file must be world readable and writable.

.SH "COLORS AND GRAPHICS"
\fIrxvt\fP can be compiled with support for colors and graphics.
In addition to the default foreground and background colors, \fIrxvt\fP
can display up to sixteen colors (8 ANSI colors plus high-intensity
bold/blink versions of the same), with color support compiled in.
.LP
If graphics support is enabled, \fIrxvt\fP can be queried with ANSI escape
sequences and can address individual pixels instead of text characters.
Note that graphics support is in alpha state yet.

.SH "GREEK KEYBOARD INPUT"
\fBrxvt\fP can be compiled with support for greek keyboard input.  ELOT-928
(option -grk9, the default) and IBM-437 (option -grk4) keyboard translations
are supported.  The window title changes to indicate which greek mode is
activated.  Of course, you need greek X fonts (928 and 437) installed and
the application you run must be 8-bit clean.  See file README.greek for more
information.

.SH BUGS
rxvt-2.14 has the utmp support somewhat cleaned and supports utmpx
(i.e. Solaris 2.x).

Cursor change support is not yet implemented.

Click-and-drag doesn't work with X11 mouse report overriding.

Graphics support is pretty crude.

Selecting/pasting very large chunks of text is a problem.

.SH FILES
.TP 16
\fI/etc/utmp\fP
System file for login records.

.SH "SEE ALSO"
xterm(1), sh(1), resize(1), X(1), pty(4), tty(4), utmp(5)

.SH AUTHOR
John Bovey, University of Kent, 1992.

Very very very heavily modified by Rob Nation
(nation@rocket.sanders.lockheed.com)

Greek keyboard input: Angelo Haritsis <ah@doc.ic.ac.uk>
Double/triple click: code from Edward Der-Hua Liu <ah@doc.ic.ac.uk>

mj olesen <olesen@me.queensu.ca> (ChangeLog 2.11 to 2.14)

Utmpx addition (Solaris 2.x) and extensive reworking of pseudo-tty handling
and addition of BSD sgtty terminal handling support by Raul Garcia Garcia
(rgg@tid.es) 16/10/95.

.\" for those who don't trust the LSM entries, perhaps this will be okay
.SH "CURRENT MAINTAINER"
Mark Olesen <olesen@me.queensu.ca> Queen's Univ at Kingston
