/*--------------------------------*-C-*---------------------------------*
 * File:	debug.h
 *
 * This module is all original work by Robert Nation
 * (nation@rocket.sanders.lockheed.com)
 *
 * Copyright 1994, Robert Nation, no rights reserved.
 *
 * You can do what you like with this source code provided you don't make
 * money from it and you include an unaltered copy of this message
 * (including the copyright).  As usual, the author accepts no
 * responsibility for anything, nor does he guarantee anything whatsoever.
 *
 * Modified by mj olesen <olesen@me.queensu.ca>
 * No additional restrictions.
 *
 * Modifications by Raul Garcia Garcia (rgg@tid.es)
 *----------------------------------------------------------------------*/
#ifndef _DEBUG_H
#define _DEBUG_H

#ifdef DEBUG_MALLOC
# define MALLOC(sz,id)		safe_malloc((sz), id)
# define FREE(ptr,id,fn)	safe_free((ptr), id, fn)
# define MEM_CHECK(id1,id2)	check_all_mem(id1,id2)
#else
# define MALLOC(sz,id)		my_malloc(sz)
# define FREE(ptr,id,fn)	my_free(ptr)
# define MEM_CHECK(id1,id2)
#endif

#ifdef __cplusplus
extern "C" {
#endif
   extern void	safe_free (void *ptr, char *which1, char *which2);
   extern void	*safe_malloc (int size, char *identifier);
   extern void	check_all_mem (char *which1, char *which2);
   extern void	my_free (void *ptr);
   extern void	*my_malloc (int size);
#ifdef __cplusplus
}
#endif
#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
