// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/
#ifndef _LYXPARAMETERS_H
#define _LYXPARAMETERS_H

#include "lyxparagraph.h"
#include "lyxcursor.h"
#include "lyxlex.h"
#include "undo.h"

extern const char* string_paragraph_separation[];
extern const char* string_quotes_language[];
extern const char* string_papersize[];
extern const char* string_orientation[];
extern const char* string_pagestyle[];

class LyXTextParameters {
private:
	void readFileOld();
	void readLyXformat2();
	void linuxDocOnePar(FILE*, LyXParagraph*&,LyXParagraph*&, int is_init);
public:  				  
        LyXTextParameters();
        LyXTextParameters(LyXTextParameters &p);
	~LyXTextParameters();
	void LinuxDocError(LyXParagraph *par, int pos, const char *message);
	int LinuxDocTag(const char *layout);
	void push_tag(FILE *file, const char *tag, int& pos, char stack[5][3]);
	void pop_tag(FILE *file, const char * tag, int& pos, char stack[5][3]);
	int GetNextParameter(LyXParagraph *par, int pos, char *buffer, 
			    int size);
	void SimpleLinuxDocOnePar(FILE *file, LyXFont &font1, 
                                 LyXParagraph *par, int &verb_on, 
                                 int &desc_on);
	void Copy (LyXTextParameters &p);
	void readFile();
	void readPreamble(LyXLexClass*);
	void readPreamble();
	void readLanguage(LyXLexClass*);
	void readLanguage();
	void readEpsfig(LyXLexClass*);
	void readEpsfig();
	void writeFile(const char*, char);
	void makeLaTeXFile(const char* filename, int column);
	void makeLinuxDocFile(const char *filename, int column);
	LyXParagraph *paragraph;
        UndoStack undostack;
        UndoStack redostack;
  	char paragraph_separation;     /* wether paragraphs are separated 
					* by using a indent like in articles
					* or by using a little skip like
					* in letters */
   
  	char quotes_language;
  	char quotes_times;
  	char papersize;
  	char fontsize;
   
 	char textclass;
   
  	/* some LaTeX options */ 
	char* epsfig;
	char* fonts;
   
	float baseline;
	signed char secnumdepth;
	signed char tocdepth;
	char* language;
	char* inputenc;
	char* preamble;
	char* options;
	char* float_placement;
  
	char columns;
	char sides;
	char orientation;
	char pagestyle;
   
  	LyXCursor cursor;

};

#endif
