$! Modified VMSMAKE for SLRN - Andy Harper, Kings College London, 14 NOV 1995
$!	- Auto-detect TCP stack and C compiler type
$!	- Override auto-selection of TCP stack via P1
$!
$ SLANGDIR := "[-.-.SLANG.SRC]"
$ SLRNLIB := "LIB$:[NEWS]"
$!
$!
$! Determine TCP stack availability (NOTE - order of test is important!)
$ TCP = "NONE"
$ if f$trnlnm("UCX$INET_HOST","LNM$SYSTEM") .nes. "" then $ TCP = "UCX"
$ if f$trnlnm("MULTINET",     "LNM$SYSTEM") .nes. "" then $ TCP = "MULTINET"
$ if f$trnlnm("NETLIB_DIR",   "LNM$SYSTEM") .nes. "" then $ TCP = "NETLIB"
$!
$ if P1 .nes. "" then $ TCP = P1	! Override via user parameter
$!
$ if TCP .eqs. "NONE"
$   then
$     write sys$error "%VMSMAKE-E-NONETWORK, Cannot determine which TCP stack you have"
$     exit
$ endif
$ write sys$output "%VMSMAKE-I-TCPFOUND, Building with the ", TCP, " network interface"
$!
$!
$! Determine which C compiler
$ if f$search("SYS$SYSTEM:DECC$COMPILER.EXE") .nes. ""
$   then ! DEC C
$     COMPILER = "DEC C"
$     PREFIX := "/PREFIX=(ALL,EXCEPT=(SOCKET,CONNECT,BIND,LISTEN,SOCKET_READ,SOCKET_WRITE,SOCKET_CLOSE,SELECT,ACCEPT,BCMP,BCOPY,BZERO,GETHOSTBYNAME,GETHOSTBYADDR,GETPEERNAME,GETDTABLESIZE,HTONS,HTONL,NTOHS,NTOHL,SEND,SENDTO,RECV,RECVFROM))"
$     CCOPT = ""
$   else ! VAX C
$     COMPILER = "VAX C"
$     PREFIX := ""
$     CCOPT = ", VAXC.OPT/OPTION"
$     DEFINE SYS SYS$LIBRARY
$ endif
$ write sys$output "%VMSMAKE-E-CC, Building with ", COMPILER
$!
$!
$! Define key macros and other flags
$ DEFS := "''TCP',SLRN_LIB_DIR=""""""""""""''SLRNLIB'"""""""""""""
$ CFLAGS := "/INCLUDE=([],''SLANGDIR') /DEFINE=(''DEFS') /nowarning ''PREFIX'"
$!
$ LFLAGS := "/NODEBUG"
$!
$!
$! Build
$ copy slrnconf.h config.h
$ purge config.h
$ CC/INCLUDE=([],'SLANGDIR') CHKSLANG.C
$ LINK/EXEC=CHKSLANG.EXE CHKSLANG.OBJ 'CCOPT'
$ CHKSLANG := $SYS$DISK:[]CHKSLANG
$ CHKSLANG SLRN 9923 9924
$ v = f$verify(1)
$ CC 'CFLAGS' SLRN.C
$ CC 'CFLAGS' GROUP.C
$ CC 'CFLAGS' MISC.C
$ CC 'CFLAGS' CLIENTLIB.C
$ CC 'CFLAGS' NNTP.C
$ CC 'CFLAGS' ART.C
$ CC 'CFLAGS' POST.C
$ CC 'CFLAGS' STARTUP.C
$ CC 'CFLAGS' HELP.C
$ CC 'CFLAGS' HASH.C
$ CC 'CFLAGS' VMS.C
$ CC 'CFLAGS' SCORE.C
$ CC 'CFLAGS' VMSMAIL.C
$ CC 'CFLAGS' MIME.C
$! CC 'CFLAGS' UUDECODE.C
$ CC 'CFLAGS' MENU.C
$ LINK/EXEC=SLRN.EXE 'LFLAGS' slrn.obj,group.obj,misc.obj,clientlib.obj,nntp.obj,-
	art.obj,post.obj,startup.obj,help.obj,hash.obj,vms.obj,score.obj, -
	mime.obj,vmsmail.obj,menu.obj -
	'SLANGDIR'SLANG.OLB/LIBR, []'TCP'.OPT/OPTION 'CCOPT'
$ v=f$verify(v)
