/* host - print information about a host
 * originally written by Paul Vixie @DEC WRL, January 1989
 */

/* DECWRL Header: host.c,v 1.1 89/04/05 15:41:12 vixie Locked $ */

#ifndef lint
static char RcsId[] = "$Id: gethost.c,v 1.5 1995/08/21 01:26:59 vixie Exp $";
#endif

#include <sys/param.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>

#include <stdio.h>
#include <resolv.h>
#include <netdb.h>
#include <syslog.h>

#ifndef LOG_PERROR
#define LOG_PERROR 0
#endif

main(argc, argv)
	int argc;
	char **argv;
{
	long l_addr;
	struct in_addr addr, **ap;
	struct hostent *host;
	char **cp, *arg;
	const char *prog = "amnesia";

	if (argc < 1) {
 usage:
		printf("usage:  %s [-d] (hostname|ipaddr)\n", prog);
		exit(1);
	}
	prog = *argv++; argc--;
#ifdef LOG_USER
	openlog(prog, LOG_PERROR, LOG_USER);
#else
	openlog(prog, LOG_PERROR);
#endif
	res_init();

	if (argc >= 1 && !strcmp(*argv, "-d")) {
		_res.options |= RES_DEBUG;
		argv++, argc--;
	}

	if (argc < 1)
		goto usage;
	arg = *argv++; argc--;

	l_addr = inet_addr(arg);
	if (l_addr != -1) {
		addr = * (struct in_addr *) &l_addr;
		printf("[%s]\n", inet_ntoa(addr));
		if (!(host = gethostbyaddr((char*)&addr, sizeof addr,
					   AF_INET))) {
			herror("gethostbyaddr");
			exit(1);
		}
	} else {
		printf("{%s}\n", arg);
		if (!(host = gethostbyname(arg))) {
			herror("gethostbyname");
			exit(1);
		}
	}
	printf("name: %s\n", host->h_name);
	if (host->h_aliases && *host->h_aliases) {
		printf("aliases:");
		for (cp = (char **) host->h_aliases; *cp; cp++)
			printf(" %s", *cp);
		printf("\n");
	}
	if (host->h_addr_list && *host->h_addr_list) {
		printf("addresses:");
		for (ap = (struct in_addr **) host->h_addr_list; *ap; ap++)
			printf(" %s", inet_ntoa(**ap));
		printf("\n");
	}
}
