/* d_cs.cc
 *$Header: /al/acs/src/RCS/d_cs.cc,v 9.20 95/10/15 22:30:59 al Exp $
 * functions for fixed current source
 * x = 0, y.f0 = nothing, ev = y.f1 = amps.
 */
#include "d_cs.h"
/*--------------------------------------------------------------------------*/
//	void	DEV_CS::expand();
// 	int	DEV_CS::dotr();
// 	void	DEV_CS::doac();
/*--------------------------------------------------------------------------*/
void DEV_CS::expand()
{
  assert(loss == 0.);
  m0.x = 0.;
  y0.x = 0.;
  m0.c0 = y0.f1 = val;
  m0.f1 = y0.f0 = 0.;
  acg = ev = 0.;
}
/*--------------------------------------------------------------------------*/
int DEV_CS::dotr()
{
  assert(m0.x == 0.);
  assert(y0.x == 0.);
  if (trfun){
    trsetup();
    (*trfun)(this);
    m0.f1 = 0.;
    m0.c0 = y0.f1;
    return converged = conv_check();
  }else if (probes){
    trsetup();
    assert(m0.c0 == val);
    return converged = TRUE;
  }else{
    assert(m0.c0 == val);
    return converged = TRUE;
  }
}
/*--------------------------------------------------------------------------*/
void DEV_CS::doac()
{
  if (acfun){
    acbias = 0.;
    acg = ev = (*acfun)(this);
    acload_source();
  }else{
    assert(acg == 0.);
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
