'\"
.so man.macros
.TH ConfigSpec n "" Tk "Perl/Tk Constructs"
.SH "NAME"
ConfigSpecs \- Defining behaviour of 'configure' for composite widgets.
.SH "SYNOPSIS"
.PP
.DS
\&  sub Populate
\&  {
\&   my ($composite,$args) = @_;
\&   ....
\&   $composite->ConfigSpecs(-attribute => [ where, dbName, dbClass, default ]);
\&   $composite->ConfigSpecs(-alias     => '-otherattribute');
\&   $composite->ConfigSpecs(  DEFAULT  => [ where ]);
\&   ....
\&  }
\& 
\&  $composite->configure( -attribute => value );
.DE
.SH "DESCRIPTION"
The aim is to make the composite widget configure method look as much like
a regular Tk widget's configure as possible.
(See the \fBconfigure\fR manual entry for a description of this behaviour.)
To enable this the attributes that the composite as a whole accepts
needs to be defined.
.sp 1
.IP "Defining the ConfigSpecs for a class." 4
Typically a widget will have one or more calls like the following
.PP
\&   $composite->ConfigSpecs(-attribute => [ where, dbName, dbClass, default ]);
.br
in its \fBPopulate\fR method. When \fBConfigSpecs\fR is called this way 
(with arguments) the arguments are used to construct or augment/replace
a hash table for the widget. 
(More than one key => value pair can be specified to a single call.)
.PP
dbName, dbClass and default are only used by \fBConfigDefault\fR described
below, or to respond to 'inquiry' configure commands.
.PP
'where' describes the \fIobject\fR\|(s) to which the attribute applies.
It may be either one of the values below, or a list of such values
enclosed in \fB[ ]\fR.
.PP
The currently permitted values of where are:
.IP "\fB'DESCENDANTS'\fR  " 4
apply 'configure' recursively to all descendants
.IP "\fB'ADVERTISED'\fR" 4
apply 'configure' to 'advertised' subwidgets.
.IP "\fB'SELF'\fR" 4
apply 'configure' to the core widget (e.g. Frame) that is the
basis of the composite. (This is the default behaviour for most 
attributes which makes a simple Frame behave the way you would expect.)
Note that once you have specified ConfigSpecs for an attribute 
you must explicitly include \fBSELF\fR in the list if you want the 
attribute to apply to the composite itself (this avoids nasty
infinite recursion problems). 
.IP "\fB'CHILDREN'\fR" 4
apply 'configure' to all children. 
.IP "\fB'PASSIVE'\fR" 4
simply store value in \fB$composite\fR\->{Configure}{\-attribute}.
.sp 1
This form is also a useful placeholder for attributes which
you currently only handle at create time.
IP "\fB'CALLBACK'\fR" 4
Setting the attribute does Tk::Callback->\fInew\fR\|($value) before storing
in \fB$composite\fR\->{Configure}{\-attribute}. This is appropriate for 
\-command => ... attributes that are handled by the composite and
not forwarded to a subwidget. (e.g. \fBTk::Tiler\fR has \-yscrollcommand 
to allow it to have scrollbar attached.)
.sp 1
This may be the first of several 'validating' keywords
(e.g. font, cursor, anchor etc.) that core Tk makes special for C code.
.IP "\fB'METHOD'\fR" 4
Call \fB$cw\fR\->\fIattribute\fR\|(value)
.sp 1
This is the most general case. Simply have a method of the 
composite class with the same name as the attribute.
The method may do any validation and have whatever side-effects you like.
(It is probably worth 'queueing' using \fBafterIdle\fR for
more complex side-effects.) 
.IP "\fB$reference\fR" 4
Call \fB$reference\fR\->configure(\-attribute => value)
.sp 1
A common case is where \fB$reference\fR is a subwidget.
.sp 1
$reference may also be result of 
.sp 1

\& Tk::Config->new(setmethod,getmethod,args,...)
.br
\fBTk::Config\fR class is used to implement all the above keyword types.
The class has 'configure' and 'cget' methods so allows higher level
code to \fIalways\fR just call one of those methods on an 'object' of some
kind.
.IP "\fB'otherstring'\fR" 4
Call \fB$cw\fR\->\fIsubwidget\fR\|('otherstring')\->configure(\-attribute => value)
.sp 1
While this is here for backward compatibility with Tk-b5, it is probably 
better just to use the subwidget reference directly.  The only case for
retaining this form is to allow an additional layer of abstraction \- perhaps
having a 'current' subwidget \- this is unproven.
.sp 1
.IP "Aliases" 4
ConfigSpecs(-alias => '-otherattribute') is used to make -alias equivalent
to '-otherattribute'. For example the aliases 
-fg => -'-foreground', -bg => -background 
are provided automatically (if not already specified).

.sp 1
.IP "Default Values" 4
When the \fBPopulate\fR method returns \fBConfigDefault\fR is called.
This calls
.PP
\& $composite->ConfigSpecs;
.br
(with no arguments) to return a reference to a hash. Entries in the 
hash take the form:
.PP
\& '-attribute' => [ where, dbName, dbClass, default ]
.br
\fBConfigDefault\fR ignores 'where' completely (and also the DEFAULT entry)
and checks the 'options' database on the widget's behalf,
and if an entry is present matching dbName/dbClass 
.PP
\& -attribute => value 
.br
is added to the list of options that \fBnew\fR will eventually apply
to the widget. Likewise if there is not a match and default is defined
this default value will be added.
.sp 1
Alias entries in the hash are used to convert user-specified values
for the alias into values for the real attribute.
.sp 1
.IP "\fBnew\fR\-time configure" 4
Once control returns to \fBnew\fR, the list of user-supplied options
augmented by those from \fBConfigDefault\fR are applied to the widget
using the \fBconfigure\fR method below.
.PP
Widgets are most flexible and most Tk-like if they handle the majority 
of their attributes this way.
.sp 1
.IP "Configuring composites" 4
Once the above have occurred calls of the form:
.PP
\&   $composite->configure( -attribute => value );
.br
should behave like any other widget as far as end-user 
code is concerned.
\fBconfigure\fR will be handled by \fBTk::Derived::configure\fR as follows:
.PP
\& $composite->ConfigSpecs;
.br
is called (with no arguments) to return a reference to a hash
\fB-attribute\fR is looked up in this hash, if \fB-attribute\fR is not
present in the hash then 'DEFAULT' is looked for instead.
(Aliases are tried as well and cause re-direction to the aliased attribute.)
The result should be a reference to a list like : 
.PP
\&  [ where, dbName, dbClass, default ]
.br
at this stage only 'where' is of interest, it maps to a list of
object references (maybe only one) foreach one 
.PP
\&   $object->configure( -attribute => value ); 
.br
is \fBeval\fRed.
.sp 1
.IP "Inquiring attributes of composites" 4
.PP
\&   $composite->cget( '-attribute' );
.br
This is handled by  \fBTk::Derived::cget\fR in a similar manner
to configure. At present if \fIwhere\fR is a list of more than one object
it is ignored completely and the "cached" value in 
    
   \fB$composite\fR\->{Configure}{\-attribute}.
.PP
is returned.

.SH CAVEATS
It is the author's intention to port as many of the "Tix" composite widgets
as make sense. The mechanism described above may have to evolve in order
to make this possible, although now aliases are handled I think the 
above is sufficient.
.SH "SEE ALSO"
configure
