/*	
 *   xtel - Emulateur MINITEL sous X11
 *
 *   Copyright (C) 1991-1994  Lectra Systemes & Pierre Ficheux
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ident "$Id: xtel.h,v 1.4 1995/04/11 14:07:16 pierre Exp $"

#ifndef _xtel_h
#define _xtel_h

/*
 * definition des constantes
 */
#include <stdio.h>
#include <fcntl.h>
#ifdef NO_NETWORK
#include <sys/socket.h>
#include <sys/un.h>
struct sockaddr_un unaddr;
#endif /* NO_NETWORK */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xos.h>

#include "demon.h"

/* le widget Videotex */
#include "Videotex.h"

/* Pour le mode Tele-informatique */
#define MODE_VIDEOTEX		0
#define MODE_TELEINFO_ASCII	1
#define MODE_TELEINFO_FR	2

/* definition d'une touche MINITEL */
struct definition_touche {
    char *nom;
    char *code;
};

/* ressources de Xtel */
typedef struct _ressources_xtel {
    String serveur;
    Boolean petiteFonte;
    Boolean nGris;
    String commandeImpression;
    String nomService;
    Boolean boutonRaccrocher;
} ressources_xtel;

/* nb de procedures */
#define MAXPROC		100

/* Procedure */
struct procedure {
    char *nom;
    char *service;
    struct chat *chat;
};


/* Chat-script */
struct chat {
    char *attente;
    char *emission;
    struct chat *suivant;
};

#include "global.h"

#endif
